/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.store;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.segmentstore.server.store.ServiceConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBuilderConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceBuilderConfig.class);
    public static final String CONFIG_FILE_PROPERTY_NAME = "pravega.configurationFile";
    private final Properties properties;

    private ServiceBuilderConfig(Properties properties) {
        Preconditions.checkNotNull((Object)properties, (Object)"properties");
        this.properties = properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T getConfig(Supplier<? extends ConfigBuilder<? extends T>> constructor) {
        return (T)constructor.get().rebase(this.properties).build();
    }

    public <T> ConfigBuilder<? extends T> getConfigBuilder(Supplier<? extends ConfigBuilder<? extends T>> constructor) {
        return constructor.get().rebase(this.properties);
    }

    public void store(File file) throws IOException {
        try (FileOutputStream s = new FileOutputStream(file, false);){
            this.properties.store(s, "");
        }
    }

    public void forEach(BiConsumer<? super Object, ? super Object> consumer) {
        this.properties.forEach(consumer);
    }

    public static ServiceBuilderConfig getDefaultConfig() {
        return new Builder().include(ServiceConfig.builder().with(ServiceConfig.CONTAINER_COUNT, (Object)1)).build();
    }

    public static class Builder {
        private final Properties properties = new Properties();

        private Builder() {
        }

        public Builder makeCopy() {
            return new Builder().include(this.properties);
        }

        public Builder include(String filePath) throws IOException {
            try (FileReader reader = new FileReader(filePath);){
                this.properties.load(reader);
            }
            return this;
        }

        public <T> Builder include(ConfigBuilder<T> builder) {
            builder.copyTo((Map)this.properties);
            return this;
        }

        public Builder include(Properties p) {
            this.properties.putAll((Map<?, ?>)p);
            return this;
        }

        public ServiceBuilderConfig build() {
            return new ServiceBuilderConfig(this.properties);
        }
    }
}

