/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.store;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.security.TLSProtocolVersion;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import io.pravega.segmentstore.server.CachePolicy;
import io.pravega.segmentstore.storage.StorageLayoutType;
import io.pravega.shared.rest.RESTServerConfig;
import io.pravega.shared.rest.impl.RESTServerConfigImpl;
import java.net.Inet4Address;
import java.time.Duration;
import java.util.Arrays;
import lombok.Generated;

public class ServiceConfig {
    public static final Property<Integer> CONTAINER_COUNT = Property.named((String)"container.count", null, (String)"containerCount");
    public static final Property<Integer> PARALLEL_CONTAINER_STARTS = Property.named((String)"container.parallelStarts", (Object)2);
    public static final Property<Integer> THREAD_POOL_SIZE = Property.named((String)"threadPool.core.size", (Object)30, (String)"threadPoolSize");
    public static final Property<Integer> STORAGE_THREAD_POOL_SIZE = Property.named((String)"threadPool.storage.size", (Object)200, (String)"storageThreadPoolSize");
    public static final Property<Integer> LOW_PRIORITY_THREAD_POOL_SIZE = Property.named((String)"threadPool.lowPriorityTasks.size", (Object)10, (String)"lowPriorityThreadPoolSize");
    public static final Property<Integer> LISTENING_PORT = Property.named((String)"service.listener.port", (Object)12345, (String)"listeningPort");
    public static final Property<Integer> PUBLISHED_PORT = Property.named((String)"service.published.port", null, (String)"publishedPort");
    public static final Property<String> LISTENING_IP_ADDRESS = Property.named((String)"service.listener.host.nameOrIp", (Object)"", (String)"listeningIPAddress");
    public static final Property<String> PUBLISHED_IP_ADDRESS = Property.named((String)"service.published.host.nameOrIp", (Object)"", (String)"publishedIPAddress");
    public static final Property<String> ZK_URL = Property.named((String)"zk.connect.uri", (Object)"localhost:2181", (String)"zkURL");
    public static final Property<Integer> ZK_RETRY_SLEEP_MS = Property.named((String)"zk.connect.retries.interval.milliseconds", (Object)5000, (String)"zkRetrySleepMs");
    public static final Property<Integer> ZK_RETRY_COUNT = Property.named((String)"zk.connect.retries.count.max", (Object)5, (String)"zkRetryCount");
    public static final Property<Integer> ZK_SESSION_TIMEOUT_MS = Property.named((String)"zk.connect.sessionTimeout.milliseconds", (Object)10000, (String)"zkSessionTimeoutMs");
    public static final Property<Boolean> SECURE_ZK = Property.named((String)"zk.connect.security.enable", (Object)false, (String)"secureZK");
    public static final Property<String> ZK_TRUSTSTORE_LOCATION = Property.named((String)"zk.connect.security.tls.trustStore.location", (Object)"", (String)"zkTrustStore");
    public static final Property<String> ZK_TRUST_STORE_PASSWORD_PATH = Property.named((String)"zk.connect.security.tls.trustStore.pwd.location", (Object)"", (String)"zkTrustStorePasswordPath");
    public static final Property<String> REST_LISTENING_HOST = Property.named((String)"rest.listener.host", (Object)"localhost");
    public static final Property<Integer> REST_LISTENING_PORT = Property.named((String)"rest.listener.port", (Object)6061);
    public static final Property<Boolean> REST_LISTENING_ENABLE = Property.named((String)"rest.listener.enable", (Object)true);
    public static final Property<String> REST_KEYSTORE_FILE = Property.named((String)"security.tls.server.keyStore.location", (Object)"");
    public static final Property<String> REST_KEYSTORE_PASSWORD_FILE = Property.named((String)"security.tls.server.keyStore.pwd.location", (Object)"");
    public static final Property<Integer> HEALTH_CHECK_INTERVAL_SECONDS = Property.named((String)"health.interval.seconds", (Object)10);
    public static final Property<String> CLUSTER_NAME = Property.named((String)"clusterName", (Object)"pravega-cluster");
    public static final Property<DataLogType> DATALOG_IMPLEMENTATION = Property.named((String)"dataLog.impl.name", (Object)((Object)DataLogType.INMEMORY), (String)"dataLogImplementation");
    public static final Property<String> STORAGE_IMPLEMENTATION = Property.named((String)"storage.impl.name", (Object)StorageType.HDFS.name(), (String)"storageImplementation");
    public static final Property<StorageLayoutType> STORAGE_LAYOUT = Property.named((String)"storage.layout", (Object)StorageLayoutType.ROLLING_STORAGE);
    public static final Property<Boolean> READONLY_SEGMENT_STORE = Property.named((String)"readOnly.enable", (Object)false, (String)"readOnlySegmentStore");
    public static final Property<Long> CACHE_POLICY_MAX_SIZE = Property.named((String)"cache.size.max", (Object)0x100000000L, (String)"cacheMaxSize");
    public static final Property<Integer> CACHE_POLICY_TARGET_UTILIZATION = Property.named((String)"cache.utilization.percent.target", (Object)75, (String)"cacheTargetUtilizationPercent");
    public static final Property<Integer> CACHE_POLICY_MAX_UTILIZATION = Property.named((String)"cache.utilization.percent.max", (Object)90, (String)"cacheMaxUtilizationPercent");
    public static final Property<Integer> CACHE_POLICY_MAX_TIME = Property.named((String)"cache.time.seconds.max", (Object)1800, (String)"cacheMaxTimeSeconds");
    public static final Property<Integer> CACHE_POLICY_GENERATION_TIME = Property.named((String)"cache.generation.duration.seconds", (Object)1, (String)"cacheGenerationTimeSeconds");
    public static final Property<Boolean> REPLY_WITH_STACK_TRACE_ON_ERROR = Property.named((String)"request.replyWithStackTraceOnError.enable", (Object)false, (String)"replyWithStackTraceOnError");
    public static final Property<String> INSTANCE_ID = Property.named((String)"instance.id", (Object)"");
    public static final Property<Boolean> ENABLE_TLS = Property.named((String)"security.tls.enable", (Object)false, (String)"enableTls");
    public static final Property<String> TLS_PROTOCOL_VERSION = Property.named((String)"security.tls.protocolVersion", (Object)"TLSv1.2,TLSv1.3");
    public static final Property<String> CERT_FILE = Property.named((String)"security.tls.server.certificate.location", (Object)"", (String)"certFile");
    public static final Property<String> KEY_FILE = Property.named((String)"security.tls.server.privateKey.location", (Object)"", (String)"keyFile");
    public static final Property<Boolean> ENABLE_TLS_RELOAD = Property.named((String)"security.tls.certificate.autoReload.enable", (Object)false, (String)"enableTlsReload");
    public static final Property<String> KEY_PASSWORD_FILE = Property.named((String)"security.tls.server.privateKey.password.location", (Object)"");
    public static final Property<Boolean> ENABLE_ADMIN_GATEWAY = Property.named((String)"admin.gateway.enable", (Object)false);
    public static final Property<Integer> ADMIN_GATEWAY_PORT = Property.named((String)"admin.gateway.port", (Object)9999);
    public static final String COMPONENT_CODE = "pravegaservice";
    private final int containerCount;
    private final int coreThreadPoolSize;
    private final int lowPriorityThreadPoolSize;
    private final int storageThreadPoolSize;
    private final int listeningPort;
    private final String listeningIPAddress;
    private final int publishedPort;
    private final String publishedIPAddress;
    private final int parallelContainerStarts;
    private final String zkURL;
    private final int zkRetrySleepMs;
    private final int zkSessionTimeoutMs;
    private final int zkRetryCount;
    private final boolean secureZK;
    private final String zkTrustStore;
    private final String zkTrustStorePasswordPath;
    private final String clusterName;
    private final DataLogType dataLogTypeImplementation;
    private final String storageImplementation;
    private final StorageLayoutType storageLayout;
    private final boolean readOnlySegmentStore;
    private final boolean enableTls;
    private final String[] tlsProtocolVersion;
    private final String certFile;
    private final String keyFile;
    private final boolean enableTlsReload;
    private final CachePolicy cachePolicy;
    private final boolean replyWithStackTraceOnError;
    private final String instanceId;
    private final boolean enableAdminGateway;
    private final int adminGatewayPort;
    private final int restListeningPort;
    private final String restListeningIPAddress;
    private final RESTServerConfig restServerConfig;
    private final boolean restServerEnabled;
    private final Duration healthCheckInterval;

    private ServiceConfig(TypedProperties properties) throws ConfigurationException {
        int publishedPort;
        this.containerCount = properties.getInt(CONTAINER_COUNT);
        this.coreThreadPoolSize = properties.getInt(THREAD_POOL_SIZE);
        this.storageThreadPoolSize = properties.getInt(STORAGE_THREAD_POOL_SIZE);
        this.lowPriorityThreadPoolSize = properties.getInt(LOW_PRIORITY_THREAD_POOL_SIZE);
        this.listeningPort = properties.getInt(LISTENING_PORT);
        try {
            publishedPort = properties.getInt(PUBLISHED_PORT);
        }
        catch (ConfigurationException e) {
            publishedPort = this.listeningPort;
        }
        this.publishedPort = publishedPort;
        String ipAddress = properties.get(LISTENING_IP_ADDRESS);
        if (ipAddress == null || ipAddress.equals(LISTENING_IP_ADDRESS.getDefaultValue())) {
            ipAddress = ServiceConfig.getHostAddress();
        }
        this.listeningIPAddress = ipAddress;
        String publishedIPAddress = properties.get(PUBLISHED_IP_ADDRESS);
        this.publishedIPAddress = Strings.isNullOrEmpty((String)publishedIPAddress) ? this.listeningIPAddress : publishedIPAddress;
        this.parallelContainerStarts = properties.getInt(PARALLEL_CONTAINER_STARTS);
        this.zkURL = properties.get(ZK_URL);
        this.zkRetrySleepMs = properties.getInt(ZK_RETRY_SLEEP_MS);
        this.zkRetryCount = properties.getInt(ZK_RETRY_COUNT);
        this.zkSessionTimeoutMs = properties.getInt(ZK_SESSION_TIMEOUT_MS);
        this.clusterName = properties.get(CLUSTER_NAME);
        this.dataLogTypeImplementation = (DataLogType)properties.getEnum(DATALOG_IMPLEMENTATION, DataLogType.class);
        this.storageImplementation = properties.get(STORAGE_IMPLEMENTATION);
        this.storageLayout = (StorageLayoutType)properties.getEnum(STORAGE_LAYOUT, StorageLayoutType.class);
        this.readOnlySegmentStore = properties.getBoolean(READONLY_SEGMENT_STORE);
        this.secureZK = properties.getBoolean(SECURE_ZK);
        this.zkTrustStore = properties.get(ZK_TRUSTSTORE_LOCATION);
        this.zkTrustStorePasswordPath = properties.get(ZK_TRUST_STORE_PASSWORD_PATH);
        this.enableTls = properties.getBoolean(ENABLE_TLS);
        TLSProtocolVersion tpr = new TLSProtocolVersion(properties.get(TLS_PROTOCOL_VERSION));
        this.tlsProtocolVersion = Arrays.copyOf(tpr.getProtocols(), tpr.getProtocols().length);
        this.keyFile = properties.get(KEY_FILE);
        this.certFile = properties.get(CERT_FILE);
        this.enableTlsReload = properties.getBoolean(ENABLE_TLS_RELOAD);
        long cachePolicyMaxSize = properties.getLong(CACHE_POLICY_MAX_SIZE);
        double cachePolicyTargetUtilization = (double)properties.getInt(CACHE_POLICY_TARGET_UTILIZATION) / 100.0;
        double cachePolicyMaxUtilization = (double)properties.getInt(CACHE_POLICY_MAX_UTILIZATION) / 100.0;
        int cachePolicyMaxTime = properties.getInt(CACHE_POLICY_MAX_TIME);
        int cachePolicyGenerationTime = properties.getInt(CACHE_POLICY_GENERATION_TIME);
        this.cachePolicy = new CachePolicy(cachePolicyMaxSize, cachePolicyTargetUtilization, cachePolicyMaxUtilization, Duration.ofSeconds(cachePolicyMaxTime), Duration.ofSeconds(cachePolicyGenerationTime));
        this.replyWithStackTraceOnError = properties.getBoolean(REPLY_WITH_STACK_TRACE_ON_ERROR);
        this.instanceId = properties.get(INSTANCE_ID);
        this.restListeningIPAddress = properties.get(REST_LISTENING_HOST);
        this.restListeningPort = properties.getInt(REST_LISTENING_PORT);
        this.restServerConfig = RESTServerConfigImpl.builder().host(properties.get(REST_LISTENING_HOST)).port(properties.getInt(REST_LISTENING_PORT)).tlsEnabled(properties.getBoolean(ENABLE_TLS)).tlsProtocolVersion(TLSProtocolVersion.parse((String)properties.get(TLS_PROTOCOL_VERSION))).keyFilePath(properties.get(REST_KEYSTORE_FILE)).keyFilePasswordPath(properties.get(REST_KEYSTORE_PASSWORD_FILE)).build();
        this.restServerEnabled = properties.getBoolean(REST_LISTENING_ENABLE);
        this.healthCheckInterval = Duration.ofSeconds(properties.getInt(HEALTH_CHECK_INTERVAL_SECONDS));
        this.enableAdminGateway = properties.getBoolean(ENABLE_ADMIN_GATEWAY);
        this.adminGatewayPort = properties.getInt(ADMIN_GATEWAY_PORT);
    }

    public static ConfigBuilder<ServiceConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, ServiceConfig::new);
    }

    public String toString() {
        return String.format("%s(", this.getClass().getSimpleName()) + String.format("containerCount: %d, ", this.containerCount) + String.format("coreThreadPoolSize: %d, ", this.coreThreadPoolSize) + String.format("storageThreadPoolSize: %d, ", this.storageThreadPoolSize) + String.format("listeningPort: %d, ", this.listeningPort) + String.format("listeningIPAddress: %s, ", this.listeningIPAddress) + String.format("publishedPort: %d, ", this.publishedPort) + String.format("publishedIPAddress: %s, ", this.publishedIPAddress) + String.format("parallelContainerStarts: %d, ", this.parallelContainerStarts) + String.format("zkURL: %s, ", this.zkURL) + String.format("zkRetrySleepMs: %d, ", this.zkRetrySleepMs) + String.format("zkSessionTimeoutMs: %d, ", this.zkSessionTimeoutMs) + String.format("zkRetryCount: %d, ", this.zkRetryCount) + String.format("secureZK: %b, ", this.secureZK) + String.format("zkTrustStore is %s, ", Strings.isNullOrEmpty((String)this.zkTrustStore) ? "unspecified" : "specified") + String.format("zkTrustStorePasswordPath is %s, ", Strings.isNullOrEmpty((String)this.zkTrustStorePasswordPath) ? "unspecified" : "specified") + String.format("clusterName: %s, ", this.clusterName) + String.format("dataLogTypeImplementation: %s, ", this.dataLogTypeImplementation.name()) + String.format("storageImplementation: %s, ", this.storageImplementation) + String.format("readOnlySegmentStore: %b, ", this.readOnlySegmentStore) + String.format("enableTls: %b, ", this.enableTls) + String.format("tlsProtocolVersion: %s, ", Arrays.toString(this.tlsProtocolVersion)) + String.format("certFile is %s, ", Strings.isNullOrEmpty((String)this.certFile) ? "unspecified" : "specified") + String.format("keyFile is %s, ", Strings.isNullOrEmpty((String)this.keyFile) ? "unspecified" : "specified") + String.format("enableTlsReload: %b, ", this.enableTlsReload) + String.format("cachePolicy is %s, ", this.cachePolicy != null ? this.cachePolicy.toString() : "null") + String.format("replyWithStackTraceOnError: %b, ", this.replyWithStackTraceOnError) + String.format("instanceId: %s", this.instanceId) + String.format("enableAdminGateway: %b, ", this.enableAdminGateway) + String.format("adminGatewayPort: %s", this.adminGatewayPort) + String.format("healthCheckInterval: %d", this.healthCheckInterval.getSeconds()) + String.format("restListeningPort: %d", this.restListeningPort) + String.format("restListeningIPAddress: %s", this.restListeningIPAddress) + String.format("restServerEnabled: %b", this.restServerEnabled) + ")";
    }

    private static String getHostAddress() {
        return Inet4Address.getLocalHost().getHostAddress();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getContainerCount() {
        return this.containerCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getCoreThreadPoolSize() {
        return this.coreThreadPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getLowPriorityThreadPoolSize() {
        return this.lowPriorityThreadPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getStorageThreadPoolSize() {
        return this.storageThreadPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getListeningPort() {
        return this.listeningPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getListeningIPAddress() {
        return this.listeningIPAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPublishedPort() {
        return this.publishedPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPublishedIPAddress() {
        return this.publishedIPAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getParallelContainerStarts() {
        return this.parallelContainerStarts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getZkURL() {
        return this.zkURL;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getZkRetrySleepMs() {
        return this.zkRetrySleepMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getZkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getZkRetryCount() {
        return this.zkRetryCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isSecureZK() {
        return this.secureZK;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getZkTrustStore() {
        return this.zkTrustStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getZkTrustStorePasswordPath() {
        return this.zkTrustStorePasswordPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DataLogType getDataLogTypeImplementation() {
        return this.dataLogTypeImplementation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStorageImplementation() {
        return this.storageImplementation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public StorageLayoutType getStorageLayout() {
        return this.storageLayout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isReadOnlySegmentStore() {
        return this.readOnlySegmentStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableTls() {
        return this.enableTls;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String[] getTlsProtocolVersion() {
        return this.tlsProtocolVersion;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCertFile() {
        return this.certFile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyFile() {
        return this.keyFile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableTlsReload() {
        return this.enableTlsReload;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isReplyWithStackTraceOnError() {
        return this.replyWithStackTraceOnError;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableAdminGateway() {
        return this.enableAdminGateway;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getAdminGatewayPort() {
        return this.adminGatewayPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRestListeningPort() {
        return this.restListeningPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRestListeningIPAddress() {
        return this.restListeningIPAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RESTServerConfig getRestServerConfig() {
        return this.restServerConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isRestServerEnabled() {
        return this.restServerEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public static enum StorageType {
        EXTENDEDS3,
        FILESYSTEM,
        HDFS,
        INMEMORY;

    }

    public static enum DataLogType {
        BOOKKEEPER,
        INMEMORY;

    }
}

