/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.store;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.MergeStreamSegmentResult;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import io.pravega.segmentstore.server.store.SegmentContainerCollection;
import io.pravega.shared.segment.SegmentToContainerMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSegmentService
extends SegmentContainerCollection
implements StreamSegmentStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamSegmentService.class);

    public StreamSegmentService(SegmentContainerRegistry segmentContainerRegistry, SegmentToContainerMapper segmentToContainerMapper) {
        super(segmentContainerRegistry, segmentToContainerMapper);
    }

    public CompletableFuture<Long> append(String streamSegmentName, BufferView data, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.append(streamSegmentName, data, attributeUpdates, timeout), "append", streamSegmentName, data.getLength(), attributeUpdates);
    }

    public CompletableFuture<Long> append(String streamSegmentName, long offset, BufferView data, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.append(streamSegmentName, offset, data, attributeUpdates, timeout), "appendWithOffset", streamSegmentName, offset, data.getLength(), attributeUpdates);
    }

    public CompletableFuture<Void> updateAttributes(String streamSegmentName, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.updateAttributes(streamSegmentName, attributeUpdates, timeout), "updateAttributes", streamSegmentName, attributeUpdates);
    }

    public CompletableFuture<Map<AttributeId, Long>> getAttributes(String streamSegmentName, Collection<AttributeId> attributeIds, boolean cache, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.getAttributes(streamSegmentName, attributeIds, cache, timeout), "getAttributes", streamSegmentName, attributeIds);
    }

    public CompletableFuture<Void> flushToStorage(int containerId, Duration timeout) {
        return this.invoke(containerId, (SegmentContainer container) -> container.flushToStorage(timeout), "flushToStorage", new Object[0]);
    }

    public CompletableFuture<ReadResult> read(String streamSegmentName, long offset, int maxLength, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.read(streamSegmentName, offset, maxLength, timeout), "read", streamSegmentName, offset, maxLength);
    }

    public CompletableFuture<SegmentProperties> getStreamSegmentInfo(String streamSegmentName, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.getStreamSegmentInfo(streamSegmentName, timeout), "getStreamSegmentInfo", streamSegmentName);
    }

    public CompletableFuture<Void> createStreamSegment(String streamSegmentName, SegmentType segmentType, Collection<AttributeUpdate> attributes, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.createStreamSegment(streamSegmentName, segmentType, attributes, timeout), "createStreamSegment", streamSegmentName, segmentType, attributes);
    }

    public CompletableFuture<MergeStreamSegmentResult> mergeStreamSegment(String targetStreamSegment, String sourceStreamSegment, Duration timeout) {
        return this.invoke(sourceStreamSegment, (SegmentContainer container) -> container.mergeStreamSegment(targetStreamSegment, sourceStreamSegment, timeout), "mergeStreamSegment", targetStreamSegment, sourceStreamSegment);
    }

    public CompletableFuture<MergeStreamSegmentResult> mergeStreamSegment(String targetStreamSegment, String sourceStreamSegment, AttributeUpdateCollection attributes, Duration timeout) {
        return this.invoke(sourceStreamSegment, (SegmentContainer container) -> container.mergeStreamSegment(targetStreamSegment, sourceStreamSegment, attributes, timeout), "mergeStreamSegment", targetStreamSegment, sourceStreamSegment);
    }

    public CompletableFuture<Long> sealStreamSegment(String streamSegmentName, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.sealStreamSegment(streamSegmentName, timeout), "sealStreamSegment", streamSegmentName);
    }

    public CompletableFuture<Void> deleteStreamSegment(String streamSegmentName, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.deleteStreamSegment(streamSegmentName, timeout), "deleteStreamSegment", streamSegmentName);
    }

    public CompletableFuture<Void> truncateStreamSegment(String streamSegmentName, long offset, Duration timeout) {
        return this.invoke(streamSegmentName, (SegmentContainer container) -> container.truncateStreamSegment(streamSegmentName, offset, timeout), "truncateStreamSegment", streamSegmentName);
    }
}

