/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.io.SerializationException;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.BufferViewBuilder;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.ReadResultEntry;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.server.reading.AsyncReadResultHandler;
import io.pravega.segmentstore.server.tables.EntrySerializer;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;

abstract class AsyncTableEntryReader<ResultT>
implements AsyncReadResultHandler {
    static final int INITIAL_READ_LENGTH = 8209;
    private final TimeoutTimer timer;
    private final BufferViewBuilder readData;
    private final CompletableFuture<ResultT> result;
    private final EntrySerializer serializer;
    private EntrySerializer.Header header;
    private final long keyVersion;

    private AsyncTableEntryReader(long keyVersion, @NonNull EntrySerializer serializer, @NonNull TimeoutTimer timer) {
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (timer == null) {
            throw new NullPointerException("timer is marked non-null but is null");
        }
        this.keyVersion = keyVersion;
        this.serializer = serializer;
        this.timer = timer;
        this.readData = BufferView.builder();
        this.result = new CompletableFuture();
    }

    static AsyncTableEntryReader<TableEntry> readEntry(BufferView soughtKey, long keyVersion, EntrySerializer serializer, TimeoutTimer timer) {
        return new EntryReader(soughtKey, keyVersion, serializer, timer);
    }

    static AsyncTableEntryReader<TableKey> readKey(long keyVersion, EntrySerializer serializer, TimeoutTimer timer) {
        return new KeyReader(keyVersion, serializer, timer);
    }

    static DeserializedEntry readEntryComponents(BufferView.Reader input, long segmentOffset, EntrySerializer serializer) throws SerializationException {
        EntrySerializer.Header h = serializer.readHeader(input);
        long version = AsyncTableEntryReader.getKeyVersion(h, segmentOffset);
        BufferView key = input.readSlice(h.getKeyLength());
        BufferView value = h.isDeletion() ? null : (h.getValueLength() == 0 ? BufferView.empty() : input.readSlice(h.getValueLength()));
        return new DeserializedEntry(h, version, key, value);
    }

    protected abstract boolean processReadData(BufferView var1);

    protected void complete(ResultT result) {
        this.result.complete(result);
    }

    private static long getKeyVersion(EntrySerializer.Header header, long segmentOffset) {
        return header.getEntryVersion() == Long.MIN_VALUE ? segmentOffset : header.getEntryVersion();
    }

    protected long getKeyVersion() {
        return AsyncTableEntryReader.getKeyVersion(this.header, this.keyVersion);
    }

    protected BufferView compactIfNeeded(BufferView source) {
        int l = source.getLength();
        if (l != 0 && l < source.getAllocatedLength() >> 1) {
            source = new ByteArraySegment(source.getCopy());
        }
        return source;
    }

    @Override
    public boolean shouldRequestContents(ReadResultEntryType entryType, long streamSegmentOffset) {
        return entryType == ReadResultEntryType.Cache || entryType == ReadResultEntryType.Storage || entryType == ReadResultEntryType.Future;
    }

    @Override
    public boolean processEntry(ReadResultEntry entry) {
        if (this.result.isDone()) {
            return false;
        }
        try {
            Preconditions.checkArgument((boolean)entry.getContent().isDone(), (Object)"Entry Contents is not yet fetched.");
            this.readData.add((BufferView)entry.getContent().join());
            if (this.header == null && this.readData.getLength() >= 17) {
                this.header = this.serializer.readHeader(this.readData.build().getBufferViewReader());
            }
            if (this.header != null) {
                return !this.processReadData(this.readData.build());
            }
            return true;
        }
        catch (Throwable ex) {
            this.processError(ex);
            return false;
        }
    }

    @Override
    public void processResultComplete() {
        if (!this.result.isDone()) {
            this.processError((Throwable)new SerializationException("Reached the end of the ReadResult but unable to read desired data."));
        }
    }

    @Override
    public void processError(Throwable cause) {
        this.result.completeExceptionally(cause);
    }

    @Override
    public Duration getRequestContentTimeout() {
        return this.timer.getRemaining();
    }

    @Override
    public int getMaxReadAtOnce() {
        if (this.result.isDone()) {
            return 0;
        }
        return this.header == null ? 8209 : this.header.getTotalLength() - this.readData.getLength();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CompletableFuture<ResultT> getResult() {
        return this.result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected EntrySerializer.Header getHeader() {
        return this.header;
    }

    static class DeserializedEntry {
        private final EntrySerializer.Header header;
        private final long version;
        private final BufferView key;
        private final BufferView value;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EntrySerializer.Header getHeader() {
            return this.header;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getVersion() {
            return this.version;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BufferView getKey() {
            return this.key;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BufferView getValue() {
            return this.value;
        }

        @ConstructorProperties(value={"header", "version", "key", "value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DeserializedEntry(EntrySerializer.Header header, long version, BufferView key, BufferView value) {
            this.header = header;
            this.version = version;
            this.key = key;
            this.value = value;
        }
    }

    private static class EntryReader
    extends AsyncTableEntryReader<TableEntry> {
        private final BufferView soughtKey;
        private boolean keyValidated;

        private EntryReader(BufferView soughtKey, long keyVersion, EntrySerializer serializer, TimeoutTimer timer) {
            super(keyVersion, serializer, timer);
            this.soughtKey = soughtKey;
            this.keyValidated = soughtKey == null;
        }

        @Override
        protected boolean processReadData(BufferView readData) {
            EntrySerializer.Header header = this.getHeader();
            assert (header != null) : "acceptResult called with no header loaded.";
            if (this.soughtKey != null && header.getKeyLength() != this.soughtKey.getLength()) {
                this.complete(null);
                return false;
            }
            if (readData.getLength() < 17 + header.getKeyLength()) {
                return false;
            }
            if (!this.keyValidated) {
                BufferView keyData = readData.slice(header.getKeyOffset(), header.getKeyLength());
                if (!this.soughtKey.equals(keyData)) {
                    this.complete(null);
                    return true;
                }
                this.keyValidated = true;
            }
            if (header.isDeletion()) {
                this.complete(TableEntry.notExists((BufferView)this.getOrReadKey(readData, header)));
                return true;
            }
            if (readData.getLength() < header.getTotalLength()) {
                return false;
            }
            BufferView valueData = header.getValueLength() == 0 ? BufferView.empty() : this.compactIfNeeded(readData.slice(header.getValueOffset(), header.getValueLength()));
            this.complete(TableEntry.versioned((BufferView)this.readKey(readData, header), (BufferView)valueData, (long)this.getKeyVersion()));
            return true;
        }

        private BufferView readKey(BufferView readData, EntrySerializer.Header header) {
            return this.compactIfNeeded(readData.slice(header.getKeyOffset(), header.getKeyLength()));
        }

        private BufferView getOrReadKey(BufferView readData, EntrySerializer.Header header) {
            return this.soughtKey != null ? this.soughtKey : this.readKey(readData, header);
        }
    }

    private static class KeyReader
    extends AsyncTableEntryReader<TableKey> {
        KeyReader(long keyVersion, EntrySerializer serializer, TimeoutTimer timer) {
            super(keyVersion, serializer, timer);
        }

        @Override
        protected boolean processReadData(BufferView readData) {
            EntrySerializer.Header header = this.getHeader();
            assert (header != null) : "acceptResult called with no header loaded.";
            if (readData.getLength() >= 17 + header.getKeyLength()) {
                BufferView keyData = this.compactIfNeeded(readData.slice(header.getKeyOffset(), header.getKeyLength()));
                if (header.isDeletion()) {
                    this.complete(TableKey.notExists((BufferView)keyData));
                } else {
                    this.complete(TableKey.versioned((BufferView)keyData, (long)this.getKeyVersion()));
                }
                return true;
            }
            return false;
        }
    }
}

