/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.server.tables.TableBucket;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

class BucketUpdate {
    private final TableBucket bucket;
    private final Map<BufferView, KeyInfo> existingKeys;
    private final Map<BufferView, KeyUpdate> updatedKeys;
    private final long bucketOffset;

    static Builder forBucket(TableBucket bucket) {
        return new Builder(bucket);
    }

    Collection<KeyInfo> getExistingKeys() {
        return this.existingKeys.values();
    }

    Collection<KeyUpdate> getKeyUpdates() {
        return this.updatedKeys.values();
    }

    boolean keyExists(BufferView key) {
        return this.existingKeys.containsKey(key);
    }

    boolean isKeyUpdated(BufferView key) {
        return this.updatedKeys.containsKey(key);
    }

    boolean hasUpdates() {
        return !this.updatedKeys.isEmpty();
    }

    @ConstructorProperties(value={"bucket", "existingKeys", "updatedKeys", "bucketOffset"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BucketUpdate(TableBucket bucket, Map<BufferView, KeyInfo> existingKeys, Map<BufferView, KeyUpdate> updatedKeys, long bucketOffset) {
        this.bucket = bucket;
        this.existingKeys = existingKeys;
        this.updatedKeys = updatedKeys;
        this.bucketOffset = bucketOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableBucket getBucket() {
        return this.bucket;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getBucketOffset() {
        return this.bucketOffset;
    }

    static class KeyUpdate
    extends KeyInfo {
        private final boolean deleted;

        KeyUpdate(BufferView key, long offset, long version, boolean deleted) {
            super(key, offset, version);
            Preconditions.checkArgument((!this.isCopied() || !deleted ? 1 : 0) != 0, (Object)"A KeyUpdate cannot be both copied and deleted at the same time.");
            this.deleted = deleted;
        }

        @Override
        public String toString() {
            return (this.deleted ? "[DELETED] " : "") + super.toString();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isDeleted() {
            return this.deleted;
        }
    }

    static class KeyInfo {
        @NonNull
        private final BufferView key;
        private final long offset;
        private final long version;

        KeyInfo(@NonNull BufferView key, long offset, long version) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            Preconditions.checkArgument((version <= offset ? 1 : 0) != 0, (String)"version (%s) cannot be lower than offset (%s).", (long)version, (long)offset);
            this.key = key;
            this.offset = offset;
            this.version = version;
        }

        boolean supersedes(KeyInfo other) {
            return this.version > other.version || this.version == other.version && this.offset > other.offset;
        }

        boolean isCopied() {
            return this.offset > this.version;
        }

        public String toString() {
            return String.format("Offset=%s, Version=%s, Key={%s}", this.offset, this.version, this.key);
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BufferView getKey() {
            return this.key;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getVersion() {
            return this.version;
        }
    }

    static class Builder {
        @NonNull
        private final TableBucket bucket;
        private final Map<BufferView, KeyInfo> existingKeys = new HashMap<BufferView, KeyInfo>();
        private final Map<BufferView, KeyUpdate> updatedKeys = new HashMap<BufferView, KeyUpdate>();

        Builder withExistingKey(KeyInfo keyInfo) {
            Preconditions.checkArgument((keyInfo.getOffset() >= 0L ? 1 : 0) != 0, (Object)"KeyInfo.getOffset() must be a non-negative number.");
            this.existingKeys.put(keyInfo.getKey(), keyInfo);
            return this;
        }

        Builder withKeyUpdate(KeyUpdate update) {
            this.updatedKeys.put(update.getKey(), update);
            return this;
        }

        BucketUpdate build() {
            ArrayList<BufferView> toRemove = new ArrayList<BufferView>();
            long bucketOffset = -1L;
            for (KeyUpdate u : this.updatedKeys.values()) {
                KeyInfo existingKey = this.existingKeys.get(u.getKey());
                if (u.isDeleted()) continue;
                if (existingKey != null && existingKey.supersedes(u) || existingKey == null && u.isCopied()) {
                    toRemove.add(u.getKey());
                    continue;
                }
                bucketOffset = Math.max(bucketOffset, u.getOffset());
            }
            toRemove.forEach(this.updatedKeys::remove);
            if (bucketOffset < 0L) {
                bucketOffset = this.existingKeys.values().stream().filter(ek -> !this.updatedKeys.containsKey(ek.getKey())).mapToLong(KeyInfo::getOffset).max().orElse(-1L);
            }
            return new BucketUpdate(this.bucket, Collections.unmodifiableMap(this.existingKeys), Collections.unmodifiableMap(this.updatedKeys), bucketOffset);
        }

        @ConstructorProperties(value={"bucket"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Builder(@NonNull TableBucket bucket) {
            if (bucket == null) {
                throw new NullPointerException("bucket is marked non-null but is null");
            }
            this.bucket = bucket;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableBucket getBucket() {
            return this.bucket;
        }
    }
}

