/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import io.pravega.common.Exceptions;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.tables.CacheBucketOffset;
import io.pravega.segmentstore.server.tables.SegmentKeyCache;
import io.pravega.segmentstore.server.tables.TableKeyBatch;
import io.pravega.segmentstore.storage.cache.CacheStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import lombok.NonNull;

class ContainerKeyCache
implements CacheManager.Client,
AutoCloseable {
    private final CacheStorage cacheStorage;
    @GuardedBy(value="segmentCaches")
    private final Map<Long, SegmentKeyCache> segmentCaches;
    @GuardedBy(value="segmentCaches")
    private int currentCacheGeneration;
    private final AtomicBoolean closed;

    ContainerKeyCache(@NonNull CacheStorage cacheStorage) {
        if (cacheStorage == null) {
            throw new NullPointerException("cacheStorage is marked non-null but is null");
        }
        this.cacheStorage = cacheStorage;
        this.segmentCaches = new HashMap<Long, SegmentKeyCache>();
        this.closed = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            ArrayList<SegmentKeyCache> toEvict;
            Map<Long, SegmentKeyCache> map = this.segmentCaches;
            synchronized (map) {
                toEvict = new ArrayList<SegmentKeyCache>(this.segmentCaches.values());
                this.segmentCaches.clear();
            }
            toEvict.forEach(s -> s.evictAll().forEach(SegmentKeyCache.CacheEntry::evict));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheManager.CacheStatus getCacheStatus() {
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            return CacheManager.CacheStatus.combine(this.segmentCaches.values().stream().filter(Objects::nonNull).map(SegmentKeyCache::getCacheStatus).iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateGenerations(int currentGeneration, int oldestGeneration, boolean essentialOnly) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        ArrayList<SegmentKeyCache.CacheEntry> evictions = new ArrayList<SegmentKeyCache.CacheEntry>();
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            this.currentCacheGeneration = currentGeneration;
            for (SegmentKeyCache segmentCache : this.segmentCaches.values()) {
                segmentCache.setEssentialCacheOnly(essentialOnly);
                evictions.addAll(segmentCache.evictBefore(oldestGeneration));
            }
        }
        boolean anyEvicted = false;
        for (SegmentKeyCache.CacheEntry e : evictions) {
            anyEvicted = e.evict() | anyEvicted;
        }
        return anyEvicted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Long> includeUpdateBatch(long segmentId, TableKeyBatch batch, long batchOffset) {
        SegmentKeyCache cache;
        int generation;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = this.segmentCaches.computeIfAbsent(segmentId, s -> new SegmentKeyCache((long)s, this.cacheStorage));
        }
        return cache.includeUpdateBatch(batch, batchOffset, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void includeTailCache(long segmentId, Map<UUID, CacheBucketOffset> keyOffsets) {
        SegmentKeyCache cache;
        int generation;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = this.segmentCaches.computeIfAbsent(segmentId, s -> new SegmentKeyCache((long)s, this.cacheStorage));
        }
        cache.includeTailCache(keyOffsets, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long includeExistingKey(long segmentId, UUID keyHash, long segmentOffset) {
        SegmentKeyCache cache;
        int generation;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = this.segmentCaches.computeIfAbsent(segmentId, s -> new SegmentKeyCache((long)s, this.cacheStorage));
        }
        return cache.includeExistingKey(keyHash, segmentOffset, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheBucketOffset get(long segmentId, UUID keyHash) {
        SegmentKeyCache cache;
        int generation;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = this.segmentCaches.get(segmentId);
        }
        return cache == null ? null : cache.get(keyHash, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSegmentIndexOffset(long segmentId, long indexOffset) {
        SegmentKeyCache cache;
        int generation;
        boolean remove = indexOffset < 0L;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = remove ? this.segmentCaches.remove(segmentId) : this.segmentCaches.computeIfAbsent(segmentId, s -> new SegmentKeyCache((long)s, this.cacheStorage));
        }
        if (cache != null) {
            if (remove) {
                cache.evictAll().forEach(SegmentKeyCache.CacheEntry::evict);
            } else {
                cache.setLastIndexedOffset(indexOffset, generation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSegmentIndexOffsetIfMissing(long segmentId, Supplier<Long> indexOffsetGetter) {
        int generation;
        SegmentKeyCache cache = null;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            if (!this.segmentCaches.containsKey(segmentId)) {
                cache = new SegmentKeyCache(segmentId, this.cacheStorage);
            }
        }
        if (cache != null) {
            cache.setLastIndexedOffset(indexOffsetGetter.get(), generation);
        }
    }

    long getSegmentIndexOffset(long segmentId) {
        return this.forSegmentCache(segmentId, SegmentKeyCache::getLastIndexedOffset, -1L);
    }

    long getBackpointer(long segmentId, long sourceOffset) {
        return this.forSegmentCache(segmentId, c -> c.getBackpointerOffset(sourceOffset), -1L);
    }

    Map<UUID, CacheBucketOffset> getTailHashes(long segmentId) {
        return this.forSegmentCache(segmentId, SegmentKeyCache::getTailBucketOffsets, Collections.emptyMap());
    }

    int getTailUpdateDelta(long segmentId) {
        return this.forSegmentCache(segmentId, SegmentKeyCache::getTailEntryCountDelta, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T forSegmentCache(long segmentId, Function<SegmentKeyCache, T> ifExists, T ifNotExists) {
        SegmentKeyCache cache;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            cache = this.segmentCaches.get(segmentId);
        }
        return cache == null ? ifNotExists : ifExists.apply(cache);
    }
}

