/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.AsyncSemaphore;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.MultiKeySequentialProcessor;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.StreamSegmentTruncatedException;
import io.pravega.segmentstore.contracts.tables.BadKeyVersionException;
import io.pravega.segmentstore.contracts.tables.KeyNotExistsException;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableSegmentNotEmptyException;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.reading.AsyncReadResultProcessor;
import io.pravega.segmentstore.server.tables.AsyncTableEntryReader;
import io.pravega.segmentstore.server.tables.CacheBucketOffset;
import io.pravega.segmentstore.server.tables.ContainerKeyCache;
import io.pravega.segmentstore.server.tables.EntrySerializer;
import io.pravega.segmentstore.server.tables.IndexReader;
import io.pravega.segmentstore.server.tables.KeyHasher;
import io.pravega.segmentstore.server.tables.TableBucket;
import io.pravega.segmentstore.server.tables.TableBucketReader;
import io.pravega.segmentstore.server.tables.TableExtensionConfig;
import io.pravega.segmentstore.server.tables.TableKeyBatch;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class ContainerKeyIndex
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerKeyIndex.class);
    private final IndexReader indexReader;
    private final ScheduledExecutorService executor;
    private final ContainerKeyCache cache;
    private final CacheManager cacheManager;
    private final MultiKeySequentialProcessor<Map.Entry<Long, UUID>> conditionalUpdateProcessor;
    private final SegmentTracker segmentTracker;
    private final AtomicBoolean closed;
    private final KeyHasher keyHasher;
    private final String traceObjectId;
    private final int containerId;
    private final TableExtensionConfig config;

    ContainerKeyIndex(int containerId, @NonNull TableExtensionConfig config, @NonNull CacheManager cacheManager, @NonNull KeyHasher keyHasher, @NonNull ScheduledExecutorService executor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (cacheManager == null) {
            throw new NullPointerException("cacheManager is marked non-null but is null");
        }
        if (keyHasher == null) {
            throw new NullPointerException("keyHasher is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.cache = new ContainerKeyCache(cacheManager.getCacheStorage());
        this.cacheManager = cacheManager;
        this.cacheManager.register(this.cache);
        this.executor = executor;
        this.indexReader = new IndexReader(executor);
        this.conditionalUpdateProcessor = new MultiKeySequentialProcessor((Executor)this.executor);
        this.segmentTracker = new SegmentTracker();
        this.keyHasher = keyHasher;
        this.closed = new AtomicBoolean();
        this.traceObjectId = String.format("KeyIndex[%d]", containerId);
        this.containerId = containerId;
        this.config = config;
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.conditionalUpdateProcessor.close();
            this.cacheManager.unregister(this.cache);
            this.cache.close();
            this.segmentTracker.close();
            log.info("{}: Closed.", (Object)this.traceObjectId);
        }
    }

    <T> CompletableFuture<T> executeIfEmpty(DirectSegmentAccess segment, Supplier<CompletableFuture<T>> action, TimeoutTimer timer) {
        return this.segmentTracker.waitIfNeeded(segment, ignored -> this.conditionalUpdateProcessor.addWithFilter(conditionKey -> ((Long)conditionKey.getKey()).longValue() == segment.getSegmentId(), () -> this.lambda$executeIfEmpty$2(segment, timer, (Supplier)action)));
    }

    private CompletableFuture<Boolean> isTableSegmentEmpty(DirectSegmentAccess segment, TimeoutTimer timer) {
        Map<UUID, CacheBucketOffset> tailHashes = this.cache.getTailHashes(segment.getSegmentId());
        List<UUID> tailRemovals = tailHashes.entrySet().stream().filter(e -> ((CacheBucketOffset)e.getValue()).isRemoval()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (tailHashes.size() > tailRemovals.size()) {
            return CompletableFuture.completedFuture(false);
        }
        SegmentMetadata sp = segment.getInfo();
        long indexedBucketCount = IndexReader.getBucketCount(sp);
        if (tailRemovals.isEmpty()) {
            return CompletableFuture.completedFuture(indexedBucketCount <= 0L);
        }
        return this.indexReader.locateBuckets(segment, tailRemovals, timer).thenApply(buckets -> {
            long removedCount = buckets.values().stream().filter(TableBucket::exists).count();
            return indexedBucketCount <= removedCount;
        });
    }

    CompletableFuture<Map<UUID, Long>> getBucketOffsets(DirectSegmentAccess segment, Collection<UUID> hashes, TimeoutTimer timer) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        if (hashes.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        HashMap<UUID, Long> result = new HashMap<UUID, Long>();
        ArrayList<UUID> toLookup = new ArrayList<UUID>();
        for (UUID hash : hashes) {
            if (result.containsKey(hash)) continue;
            CacheBucketOffset existingValue = this.cache.get(segment.getSegmentId(), hash);
            if (existingValue == null) {
                result.put(hash, -1L);
                toLookup.add(hash);
                continue;
            }
            if (!existingValue.isRemoval()) {
                result.put(hash, existingValue.getSegmentOffset());
                continue;
            }
            long backpointerOffset = this.cache.getBackpointer(segment.getSegmentId(), existingValue.getSegmentOffset());
            if (backpointerOffset < 0L) {
                result.put(hash, -1L);
                toLookup.add(hash);
                continue;
            }
            result.put(hash, existingValue.getSegmentOffset());
        }
        if (toLookup.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        return this.segmentTracker.waitIfNeeded(segment, cacheUpdated -> this.getBucketOffsetFromSegment(segment, (Map<UUID, Long>)result, (Collection<UUID>)toLookup, (boolean)cacheUpdated, timer));
    }

    CompletableFuture<Long> getBucketOffsetDirect(DirectSegmentAccess segment, UUID keyHash, TimeoutTimer timer) {
        return this.segmentTracker.waitIfNeeded(segment, cacheUpdated -> this.getBucketOffsetFromSegment(segment, Collections.synchronizedMap(new HashMap()), (Collection<UUID>)Collections.singleton(keyHash), (boolean)cacheUpdated, timer).thenApply(result -> (Long)result.get(keyHash)));
    }

    private CompletableFuture<Map<UUID, Long>> getBucketOffsetFromSegment(DirectSegmentAccess segment, Map<UUID, Long> result, Collection<UUID> toLookup, boolean tryCache, TimeoutTimer timer) {
        return this.indexReader.locateBuckets(segment, toLookup, timer).thenApplyAsync(bucketsByHash -> {
            for (Map.Entry e : bucketsByHash.entrySet()) {
                UUID keyHash = (UUID)e.getKey();
                TableBucket bucket = (TableBucket)e.getValue();
                if (bucket.exists()) {
                    long highestOffset = this.cache.includeExistingKey(segment.getSegmentId(), keyHash, bucket.getSegmentOffset());
                    result.put(keyHash, highestOffset);
                    continue;
                }
                if (tryCache) {
                    CacheBucketOffset existingValue = this.cache.get(segment.getSegmentId(), keyHash);
                    result.put(keyHash, existingValue == null || existingValue.isRemoval() ? -1L : existingValue.getSegmentOffset());
                    continue;
                }
                result.put(keyHash, -1L);
            }
            return result;
        }, (Executor)this.executor);
    }

    CompletableFuture<Long> getBackpointerOffset(DirectSegmentAccess segment, long offset, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        long cachedBackpointer = this.cache.getBackpointer(segment.getSegmentId(), offset);
        if (cachedBackpointer >= 0L) {
            return CompletableFuture.completedFuture(cachedBackpointer);
        }
        if (offset <= this.cache.getSegmentIndexOffset(segment.getSegmentId())) {
            return this.indexReader.getBackpointerOffset(segment, offset, timeout);
        }
        return this.segmentTracker.waitIfNeeded(segment, ignored -> this.indexReader.getBackpointerOffset(segment, offset, timeout));
    }

    CompletableFuture<List<Long>> update(DirectSegmentAccess segment, TableKeyBatch batch, Supplier<CompletableFuture<Long>> persist, TimeoutTimer timer) {
        Supplier update;
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        if (batch.isConditional()) {
            List keys = batch.getVersionedItems().stream().map(item -> Maps.immutableEntry((Object)segment.getSegmentId(), (Object)item.getHash())).collect(Collectors.toList());
            update = () -> this.conditionalUpdateProcessor.add((Collection)keys, () -> this.lambda$update$14(segment, batch, timer, (Supplier)persist));
        } else {
            update = () -> ((CompletableFuture)persist.get()).thenApplyAsync(batchOffset -> this.updateCache(segment, batch, (long)batchOffset), (Executor)this.executor);
        }
        return this.segmentTracker.throttleIfNeeded(segment, update, batch.getLength());
    }

    private List<Long> updateCache(DirectSegmentAccess segment, TableKeyBatch batch, long batchOffset) {
        this.cache.updateSegmentIndexOffsetIfMissing(segment.getSegmentId(), () -> IndexReader.getLastIndexedOffset(segment.getInfo()));
        return this.cache.includeUpdateBatch(segment.getSegmentId(), batch, batchOffset);
    }

    private CompletableFuture<Void> validateConditionalUpdate(DirectSegmentAccess segment, TableKeyBatch batch, TimeoutTimer timer) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        List<UUID> hashes = batch.getVersionedItems().stream().map(TableKeyBatch.Item::getHash).collect(Collectors.toList());
        CompletionStage result = this.getBucketOffsets(segment, hashes, timer).thenAccept(offsets -> this.validateConditionalUpdate(batch.getVersionedItems(), (Map<UUID, Long>)offsets, segment.getInfo().getName()));
        return Futures.exceptionallyCompose((CompletableFuture)result, ex -> {
            if ((ex = Exceptions.unwrap((Throwable)ex)) instanceof BadKeyVersionException) {
                return this.validateConditionalUpdateFailures(segment, ((BadKeyVersionException)ex).getExpectedVersions(), timer);
            }
            return Futures.failedFuture((Throwable)ex);
        });
    }

    private void validateConditionalUpdate(List<TableKeyBatch.Item> items, Map<UUID, Long> bucketOffsets, String segmentName) {
        HashMap<TableKey, Long> badKeyVersions = new HashMap<TableKey, Long>();
        for (TableKeyBatch.Item item : items) {
            TableKey key = item.getKey();
            Long bucketOffset = bucketOffsets.get(item.getHash());
            assert (key.hasVersion()) : "validateConditionalUpdate for TableKey with no compare version";
            if (bucketOffset == -1L) {
                if (key.getVersion() == -1L) continue;
                throw new KeyNotExistsException(segmentName, key.getKey());
            }
            if (bucketOffset.longValue() == key.getVersion()) continue;
            badKeyVersions.put(key, bucketOffset);
        }
        if (!badKeyVersions.isEmpty()) {
            throw new BadKeyVersionException(segmentName, badKeyVersions);
        }
    }

    private CompletableFuture<Void> validateConditionalUpdateFailures(DirectSegmentAccess segment, Map<TableKey, Long> expectedVersions, TimeoutTimer timer) {
        assert (!expectedVersions.isEmpty());
        TableBucketReader<TableKey> bucketReader = TableBucketReader.key(segment, this::getBackpointerOffset, this.executor);
        Map<TableKey, CompletableFuture> searches = expectedVersions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.findBucketEntry(segment, bucketReader, ((TableKey)e.getKey()).getKey(), (Long)e.getValue(), timer)));
        return Futures.allOf(searches.values()).thenRun(() -> {
            HashMap<TableKey, Long> failed = new HashMap<TableKey, Long>();
            for (Map.Entry e : searches.entrySet()) {
                TableKey actual = (TableKey)((CompletableFuture)e.getValue()).join();
                boolean isValid = actual == null ? ((TableKey)e.getKey()).getVersion() == -1L : ((TableKey)e.getKey()).getVersion() == actual.getVersion();
                if (isValid) continue;
                failed.put((TableKey)e.getKey(), actual == null ? -1L : actual.getVersion());
            }
            if (!failed.isEmpty()) {
                throw new CompletionException((Throwable)new BadKeyVersionException(segment.getInfo().getName(), failed));
            }
        });
    }

    <T> CompletableFuture<T> findBucketEntry(DirectSegmentAccess segment, TableBucketReader<T> bucketReader, BufferView key, long bucketOffset, TimeoutTimer timer) {
        return Futures.exceptionallyExpecting(bucketReader.find(key, bucketOffset, timer), ex -> ex instanceof StreamSegmentTruncatedException, null).thenComposeAsync(entry -> {
            if (entry != null) {
                return CompletableFuture.completedFuture(entry);
            }
            return this.getBucketOffsetDirect(segment, this.keyHasher.hash(key), timer).thenComposeAsync(newOffset -> bucketReader.find(key, (long)newOffset, timer), (Executor)this.executor);
        }, (Executor)this.executor);
    }

    void notifyIndexOffsetChanged(long segmentId, long indexOffset, int processedBytes) {
        this.cache.updateSegmentIndexOffset(segmentId, indexOffset);
        this.segmentTracker.updateSegmentIndexOffset(segmentId, indexOffset, processedBytes);
    }

    CompletableFuture<Map<UUID, CacheBucketOffset>> getUnindexedKeyHashes(DirectSegmentAccess segment) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.segmentTracker.waitIfNeeded(segment, ignored -> CompletableFuture.completedFuture(this.cache.getTailHashes(segment.getSegmentId())));
    }

    long getUniqueEntryCount(SegmentMetadata segmentMetadata) {
        return IndexReader.getEntryCount(segmentMetadata) + (long)this.cache.getTailUpdateDelta(segmentMetadata.getId());
    }

    private void triggerCacheTailIndex(DirectSegmentAccess segment, long lastIndexedOffset, SegmentTracker.RecoveryTask task) {
        long tailIndexLength = task.triggerIndexOffset - lastIndexedOffset;
        if (lastIndexedOffset >= task.triggerIndexOffset) {
            log.debug("{}: Table Segment {} fully indexed.", (Object)this.traceObjectId, (Object)segment.getSegmentId());
            return;
        }
        if (tailIndexLength > this.config.getMaxTailCachePreIndexLength()) {
            log.info("{}: Table Segment {} cannot perform tail-caching because tail index too long ({}).", new Object[]{this.traceObjectId, segment.getSegmentId(), tailIndexLength});
            return;
        }
        log.info("{}: Tail-caching started for Table Segment {}. LastIndexedOffset={}, SegmentLength={}.", new Object[]{this.traceObjectId, segment.getSegmentId(), lastIndexedOffset, task.triggerIndexOffset});
        AtomicLong preIndexOffset = new AtomicLong(lastIndexedOffset);
        Futures.loop(() -> !task.task.isDone() && preIndexOffset.get() < task.triggerIndexOffset, () -> {
            int maxLength = (int)Math.min((long)this.config.getMaxTailCachePreIndexBatchLength(), task.triggerIndexOffset - preIndexOffset.get());
            return this.preIndexBatch(segment, preIndexOffset.get(), maxLength).thenAccept(preIndexOffset::set);
        }, (Executor)this.executor).exceptionally(ex -> {
            log.warn("{}: Tail-caching failed for Table Segment {}; LastIndexedOffset={}, CurrentOffset={}, SegmentLength={}.", new Object[]{this.traceObjectId, segment.getSegmentId(), lastIndexedOffset, preIndexOffset, task.triggerIndexOffset, Exceptions.unwrap((Throwable)ex)});
            return null;
        });
    }

    private CompletableFuture<Long> preIndexBatch(DirectSegmentAccess segment, long startOffset, int maxLength) {
        log.trace("{}: Tail-caching batch started for Table Segment {}. StartOffset={}, MaxLength={}.", new Object[]{this.traceObjectId, segment.getSegmentId(), startOffset, maxLength});
        Timer timer = new Timer();
        ReadResult rr = segment.read(startOffset, maxLength, this.config.getRecoveryTimeout());
        return AsyncReadResultProcessor.processAll(rr, this.executor, this.config.getRecoveryTimeout()).thenApplyAsync(inputData -> {
            TailUpdates updates = new TailUpdates();
            this.collectLatestOffsets((BufferView)inputData, startOffset, maxLength, updates);
            this.cache.includeTailCache(segment.getSegmentId(), updates.byBucket);
            log.debug("{}: Tail-caching batch complete for Table Segment {}. StartOffset={}, EndOffset={}, Key Update Count={}, Bucket Update Count={}, Elapsed={}ms.", new Object[]{this.traceObjectId, segment.getSegmentId(), startOffset, updates.getMaxOffset(), updates.getKeyCount(), updates.byBucket.size(), timer.getElapsedMillis()});
            this.segmentTracker.updateSegmentIndexOffset(segment.getSegmentId(), updates.getMaxOffset(), 0, updates.byBucket.size() > 0);
            return updates.getMaxOffset();
        }, (Executor)this.executor);
    }

    private void collectLatestOffsets(BufferView input, long startOffset, int maxLength, TailUpdates result) {
        EntrySerializer serializer = new EntrySerializer();
        long maxOffset = startOffset + (long)maxLength;
        BufferView.Reader inputReader = input.getBufferViewReader();
        try {
            AsyncTableEntryReader.DeserializedEntry e;
            for (long nextOffset = startOffset; nextOffset < maxOffset; nextOffset += (long)e.getHeader().getTotalLength()) {
                e = AsyncTableEntryReader.readEntryComponents(inputReader, nextOffset, serializer);
                UUID hash = this.keyHasher.hash(e.getKey());
                result.add(hash, nextOffset, e.getHeader().getTotalLength(), e.getHeader().isDeletion());
            }
        }
        catch (BufferView.Reader.OutOfBoundsException outOfBoundsException) {
        }
    }

    @VisibleForTesting
    long getUnindexedSizeBytes(long segmentId) {
        return this.segmentTracker.getUnindexedSizeBytes(segmentId);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    private /* synthetic */ CompletableFuture lambda$update$14(DirectSegmentAccess segment, TableKeyBatch batch, TimeoutTimer timer, Supplier persist) {
        return ((CompletableFuture)this.validateConditionalUpdate(segment, batch, timer).thenComposeAsync(arg_0 -> ContainerKeyIndex.lambda$update$12((Supplier)persist, arg_0), (Executor)this.executor)).thenApplyAsync(batchOffset -> this.updateCache(segment, batch, (long)batchOffset), (Executor)this.executor);
    }

    private static /* synthetic */ CompletionStage lambda$update$12(Supplier persist, Void v) {
        return (CompletionStage)persist.get();
    }

    private /* synthetic */ CompletableFuture lambda$executeIfEmpty$2(DirectSegmentAccess segment, TimeoutTimer timer, Supplier action) {
        return this.isTableSegmentEmpty(segment, timer).thenCompose(arg_0 -> ContainerKeyIndex.lambda$executeIfEmpty$1((Supplier)action, segment, arg_0));
    }

    private static /* synthetic */ CompletionStage lambda$executeIfEmpty$1(Supplier action, DirectSegmentAccess segment, Boolean isEmpty) {
        if (isEmpty.booleanValue()) {
            return (CompletionStage)action.get();
        }
        return Futures.failedFuture((Throwable)new TableSegmentNotEmptyException(segment.getInfo().getName()));
    }

    @ThreadSafe
    private class SegmentTracker
    implements AutoCloseable {
        @GuardedBy(value="this")
        private final HashSet<Long> recoveredSegments = new HashSet();
        @GuardedBy(value="this")
        private final HashMap<Long, RecoveryTask> recoveryTasks = new HashMap();
        @GuardedBy(value="this")
        private final HashMap<Long, AsyncSemaphore> throttlers = new HashMap();

        private SegmentTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ArrayList<AsyncSemaphore> toClose;
            ArrayList<RecoveryTask> toCancel;
            SegmentTracker segmentTracker = this;
            synchronized (segmentTracker) {
                toCancel = new ArrayList<RecoveryTask>(this.recoveryTasks.values());
                this.recoveryTasks.clear();
                toClose = new ArrayList<AsyncSemaphore>(this.throttlers.values());
                this.throttlers.clear();
            }
            ObjectClosedException ex = new ObjectClosedException((Object)ContainerKeyIndex.this);
            toCancel.forEach(task -> {
                task.task.completeExceptionally((Throwable)ex);
                log.info("{}: Cancelled one or more tasks that were waiting on Table Segment {} recovery.", (Object)ContainerKeyIndex.this.traceObjectId, (Object)task.segmentId);
            });
            toClose.forEach(AsyncSemaphore::close);
        }

        void updateSegmentIndexOffset(long segmentId, long indexOffset, int processedSizeBytes) {
            this.updateSegmentIndexOffset(segmentId, indexOffset, processedSizeBytes, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSegmentIndexOffset(long segmentId, long indexOffset, int processedSizeBytes, boolean cacheUpdated) {
            AsyncSemaphore throttler;
            RecoveryTask task;
            boolean removed = indexOffset < 0L;
            SegmentTracker segmentTracker = this;
            synchronized (segmentTracker) {
                task = this.recoveryTasks.get(segmentId);
                throttler = this.throttlers.get(segmentId);
                if (removed) {
                    this.recoveredSegments.remove(segmentId);
                    this.throttlers.remove(segmentId);
                }
                if (task != null && !removed) {
                    if (indexOffset < task.triggerIndexOffset) {
                        log.debug("{}: For TableSegment {}, IndexOffset={}, TriggerOffset={}.", new Object[]{ContainerKeyIndex.this.traceObjectId, segmentId, indexOffset, task.triggerIndexOffset});
                        task = null;
                    } else {
                        this.recoveredSegments.add(segmentId);
                    }
                }
            }
            if (task != null) {
                if (removed) {
                    log.info("{}: TableSegment {} evicted; cancelling dependent tasks.", (Object)ContainerKeyIndex.this.traceObjectId, (Object)segmentId);
                    task.task.cancel(true);
                } else if (indexOffset >= task.triggerIndexOffset) {
                    log.info("{}: TableSegment {} fully recovered ({} ms); triggering dependent tasks.", new Object[]{ContainerKeyIndex.this.traceObjectId, segmentId, task.timer.getElapsedMillis()});
                    task.task.complete(cacheUpdated);
                }
            }
            if (throttler != null) {
                if (removed) {
                    throttler.close();
                } else if (processedSizeBytes >= 0) {
                    throttler.release((long)processedSizeBytes);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> CompletableFuture<T> throttleIfNeeded(DirectSegmentAccess segment, Supplier<CompletableFuture<T>> toExecute, int updateSize) {
            AsyncSemaphore throttler;
            SegmentTracker segmentTracker = this;
            synchronized (segmentTracker) {
                throttler = this.throttlers.getOrDefault(segment.getSegmentId(), null);
                if (throttler == null) {
                    SegmentMetadata si = segment.getInfo();
                    long initialDelta = Math.max(0L, si.getLength() - IndexReader.getLastIndexedOffset(si));
                    throttler = new AsyncSemaphore((long)ContainerKeyIndex.this.config.getMaxUnindexedLength(), initialDelta, String.format("%s-%s", ContainerKeyIndex.this.containerId, segment.getSegmentId()));
                    this.throttlers.put(segment.getSegmentId(), throttler);
                }
            }
            return throttler.run(toExecute, (long)updateSize, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getUnindexedSizeBytes(long segmentId) {
            SegmentTracker segmentTracker = this;
            synchronized (segmentTracker) {
                AsyncSemaphore throttler = this.throttlers.getOrDefault(segmentId, null);
                return throttler == null ? 0L : throttler.getUsedCredits();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> CompletableFuture<T> waitIfNeeded(DirectSegmentAccess segment, Function<Boolean, CompletableFuture<T>> toExecute) {
            RecoveryTask task = null;
            long segmentLength = -1L;
            long lastIndexedOffset = -1L;
            boolean firstTask = false;
            SegmentTracker segmentTracker = this;
            synchronized (segmentTracker) {
                if (!this.recoveredSegments.contains(segment.getSegmentId()) && (task = this.recoveryTasks.get(segment.getSegmentId())) == null) {
                    SegmentMetadata sp = segment.getInfo();
                    segmentLength = sp.getLength();
                    lastIndexedOffset = IndexReader.getLastIndexedOffset(sp);
                    if (lastIndexedOffset >= segmentLength) {
                        this.recoveredSegments.add(segment.getSegmentId());
                    } else {
                        task = new RecoveryTask(segment.getSegmentId(), segmentLength);
                        this.recoveryTasks.put(segment.getSegmentId(), task);
                        firstTask = true;
                    }
                }
            }
            if (task == null) {
                return toExecute.apply(false);
            }
            log.debug("{}: TableSegment {} is not fully recovered. Queuing 1 task.", (Object)ContainerKeyIndex.this.traceObjectId, (Object)segment.getSegmentId());
            if (firstTask) {
                this.setupRecoveryTask(task);
                assert (lastIndexedOffset >= 0L);
                ContainerKeyIndex.this.triggerCacheTailIndex(segment, lastIndexedOffset, task);
            }
            return task.task.thenComposeAsync(toExecute, (Executor)ContainerKeyIndex.this.executor);
        }

        private void setupRecoveryTask(RecoveryTask task) {
            ScheduledFuture<Boolean> sf = ContainerKeyIndex.this.executor.schedule(() -> task.task.completeExceptionally(new TimeoutException(String.format("Table Segment %d recovery timed out.", task.segmentId))), ContainerKeyIndex.this.config.getRecoveryTimeout().toMillis(), TimeUnit.MILLISECONDS);
            task.task.whenComplete((r, ex) -> {
                SegmentTracker segmentTracker = this;
                synchronized (segmentTracker) {
                    RecoveryTask removed = this.recoveryTasks.remove(task.segmentId);
                    if (removed != task) {
                        this.recoveryTasks.put(task.segmentId, removed);
                    }
                }
                sf.cancel(true);
            });
        }

        private class RecoveryTask {
            final long segmentId;
            final long triggerIndexOffset;
            final CompletableFuture<Boolean> task = new CompletableFuture();
            final Timer timer = new Timer();

            @ConstructorProperties(value={"segmentId", "triggerIndexOffset"})
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public RecoveryTask(long segmentId, long triggerIndexOffset) {
                this.segmentId = segmentId;
                this.triggerIndexOffset = triggerIndexOffset;
            }
        }
    }

    private static class TailUpdates {
        final Map<UUID, CacheBucketOffset> byBucket = new HashMap<UUID, CacheBucketOffset>();
        private int keyCount = 0;
        private long maxOffset = -1L;

        void add(UUID keyHash, long offset, int serializationLength, boolean isDeletion) {
            CacheBucketOffset cbo = new CacheBucketOffset(offset, isDeletion);
            this.byBucket.put(keyHash, cbo);
            ++this.keyCount;
            this.maxOffset = offset + (long)serializationLength;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TailUpdates() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getKeyCount() {
            return this.keyCount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getMaxOffset() {
            return this.maxOffset;
        }
    }
}

