/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.BadSegmentTypeException;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.tables.IteratorArgs;
import io.pravega.segmentstore.contracts.tables.IteratorItem;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableSegmentConfig;
import io.pravega.segmentstore.contracts.tables.TableSegmentInfo;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.tables.ContainerTableExtension;
import io.pravega.segmentstore.server.tables.FixedKeyLengthTableSegmentLayout;
import io.pravega.segmentstore.server.tables.HashTableSegmentLayout;
import io.pravega.segmentstore.server.tables.KeyHasher;
import io.pravega.segmentstore.server.tables.TableExtensionConfig;
import io.pravega.segmentstore.server.tables.TableSegmentLayout;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTableExtensionImpl
implements ContainerTableExtension {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerTableExtensionImpl.class);
    private final SegmentContainer segmentContainer;
    private final ScheduledExecutorService executor;
    private final FixedKeyLengthTableSegmentLayout fixedKeyLayout;
    private final HashTableSegmentLayout hashTableLayout;
    private final AtomicBoolean closed;
    private final String traceObjectId;
    private final TableExtensionConfig config;

    public ContainerTableExtensionImpl(TableExtensionConfig config, SegmentContainer segmentContainer, CacheManager cacheManager, ScheduledExecutorService executor) {
        this(config, segmentContainer, cacheManager, KeyHasher.sha256(), executor);
    }

    @VisibleForTesting
    ContainerTableExtensionImpl(@NonNull TableExtensionConfig config, @NonNull SegmentContainer segmentContainer, @NonNull CacheManager cacheManager, @NonNull KeyHasher hasher, @NonNull ScheduledExecutorService executor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (segmentContainer == null) {
            throw new NullPointerException("segmentContainer is marked non-null but is null");
        }
        if (cacheManager == null) {
            throw new NullPointerException("cacheManager is marked non-null but is null");
        }
        if (hasher == null) {
            throw new NullPointerException("hasher is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.config = config;
        this.segmentContainer = segmentContainer;
        this.executor = executor;
        TableSegmentLayout.Connector connector = new TableSegmentLayout.Connector(this.segmentContainer.getId(), this.segmentContainer::forSegment, (arg_0, arg_1) -> ((SegmentContainer)this.segmentContainer).deleteStreamSegment(arg_0, arg_1));
        this.hashTableLayout = new HashTableSegmentLayout(connector, cacheManager, hasher, this.config, this.executor);
        this.fixedKeyLayout = new FixedKeyLengthTableSegmentLayout(connector, this.config, this.executor);
        this.closed = new AtomicBoolean();
        this.traceObjectId = String.format("TableExtension[%d]", this.segmentContainer.getId());
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.hashTableLayout.close();
            this.fixedKeyLayout.close();
            log.info("{}: Closed.", (Object)this.traceObjectId);
        }
    }

    @Override
    public Collection<WriterSegmentProcessor> createWriterSegmentProcessors(UpdateableSegmentMetadata metadata) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        if (!metadata.getType().isTableSegment()) {
            return Collections.emptyList();
        }
        return this.selectLayout(metadata).createWriterSegmentProcessors(metadata);
    }

    private TableSegmentLayout selectLayout(SegmentMetadata segmentMetadata) {
        SegmentType type = segmentMetadata.getType();
        if (!type.isTableSegment()) {
            type = SegmentType.fromAttributes(segmentMetadata.getAttributes());
        }
        return this.selectLayout(segmentMetadata.getName(), type);
    }

    private TableSegmentLayout selectLayout(String segmentName, SegmentType segmentType) {
        if (segmentType.isFixedKeyLengthTableSegment()) {
            return this.fixedKeyLayout;
        }
        if (segmentType.isTableSegment()) {
            return this.hashTableLayout;
        }
        throw new BadSegmentTypeException(segmentName, SegmentType.builder().tableSegment().build(), segmentType);
    }

    public CompletableFuture<Void> createSegment(@NonNull String segmentName, SegmentType segmentType, TableSegmentConfig config, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        segmentType = SegmentType.builder((SegmentType)segmentType).tableSegment().build();
        HashMap<AttributeId, Long> attributes = new HashMap<AttributeId, Long>(TableAttributes.DEFAULT_VALUES);
        attributes.putAll(this.selectLayout(segmentName, segmentType).getNewSegmentAttributes(config));
        List attributeUpdates = attributes.entrySet().stream().map(e -> new AttributeUpdate((AttributeId)e.getKey(), AttributeUpdateType.None, ((Long)e.getValue()).longValue())).collect(Collectors.toList());
        this.logRequest("createSegment", segmentName, segmentType, config);
        return this.segmentContainer.createStreamSegment(segmentName, segmentType, attributeUpdates, timeout);
    }

    public CompletableFuture<Void> deleteSegment(@NonNull String segmentName, boolean mustBeEmpty, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.logRequest("deleteSegment", segmentName, mustBeEmpty);
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.segmentContainer.forSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.selectLayout(segment.getInfo()).deleteSegment(segmentName, mustBeEmpty, timer.getRemaining()), (Executor)this.executor);
    }

    public CompletableFuture<List<Long>> put(@NonNull String segmentName, @NonNull List<TableEntry> entries, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return this.put(segmentName, entries, -1L, timeout);
    }

    public CompletableFuture<List<Long>> put(@NonNull String segmentName, @NonNull List<TableEntry> entries, long tableSegmentOffset, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.segmentContainer.forSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.selectLayout(segment.getInfo()).put((DirectSegmentAccess)segment, entries, tableSegmentOffset, timer), (Executor)this.executor);
    }

    public CompletableFuture<Void> remove(@NonNull String segmentName, @NonNull Collection<TableKey> keys, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.remove(segmentName, keys, -1L, timeout);
    }

    public CompletableFuture<Void> remove(@NonNull String segmentName, @NonNull Collection<TableKey> keys, long tableSegmentOffset, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.segmentContainer.forSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.selectLayout(segment.getInfo()).remove((DirectSegmentAccess)segment, keys, tableSegmentOffset, timer), (Executor)this.executor);
    }

    public CompletableFuture<List<TableEntry>> get(@NonNull String segmentName, @NonNull List<BufferView> keys, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.segmentContainer.forSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.selectLayout(segment.getInfo()).get((DirectSegmentAccess)segment, keys, timer), (Executor)this.executor);
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableKey>>> keyIterator(String segmentName, IteratorArgs args) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.segmentContainer.forSegment(segmentName, args.getFetchTimeout()).thenComposeAsync(segment -> this.selectLayout(segment.getInfo()).keyIterator((DirectSegmentAccess)segment, args), (Executor)this.executor);
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryIterator(String segmentName, IteratorArgs args) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.segmentContainer.forSegment(segmentName, args.getFetchTimeout()).thenComposeAsync(segment -> this.selectLayout(segment.getInfo()).entryIterator((DirectSegmentAccess)segment, args), (Executor)this.executor);
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryDeltaIterator(String segmentName, long fromPosition, Duration fetchTimeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.segmentContainer.forSegment(segmentName, fetchTimeout).thenApplyAsync(segment -> this.selectLayout(segment.getInfo()).entryDeltaIterator((DirectSegmentAccess)segment, fromPosition, fetchTimeout), (Executor)this.executor);
    }

    public CompletableFuture<TableSegmentInfo> getInfo(String segmentName, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.logRequest("getInfo", segmentName);
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.segmentContainer.forSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.selectLayout(segment.getInfo()).getInfo((DirectSegmentAccess)segment, timer.getRemaining()), (Executor)this.executor);
    }

    private void logRequest(String requestName, Object ... args) {
        log.debug("{}: {} {}", new Object[]{this.traceObjectId, requestName, args});
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableExtensionConfig getConfig() {
        return this.config;
    }
}

