/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.tables.IteratorState;
import java.io.IOException;
import lombok.Generated;

public class DeltaIteratorState
implements IteratorState {
    private static final Serializer SERIALIZER = new Serializer();
    private static final int BOOLEAN_BYTES = 1;
    private final long fromPosition;
    private final boolean reachedEnd;
    private final boolean shouldClear;
    private final boolean deletionRecord;

    DeltaIteratorState(long fromPosition, boolean reachedEnd, boolean shouldClear, boolean deletionRecord) {
        Preconditions.checkArgument((boolean)DeltaIteratorState.isValid(fromPosition), (Object)"Position must be at least 0 (a non-negative integer).");
        this.fromPosition = fromPosition;
        this.reachedEnd = reachedEnd;
        this.shouldClear = shouldClear;
        this.deletionRecord = deletionRecord;
    }

    public DeltaIteratorState() {
        this.fromPosition = 0L;
        this.reachedEnd = true;
        this.shouldClear = false;
        this.deletionRecord = false;
    }

    static boolean isValid(long position) {
        return position >= 0L;
    }

    public static DeltaIteratorState deserialize(BufferView data) {
        return (DeltaIteratorState)SERIALIZER.deserialize(data);
    }

    public ArrayView serialize() {
        return SERIALIZER.serialize(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static DeltaIteratorStateBuilder builder() {
        return new DeltaIteratorStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DeltaIteratorState(fromPosition=" + this.getFromPosition() + ", reachedEnd=" + this.isReachedEnd() + ", shouldClear=" + this.isShouldClear() + ", deletionRecord=" + this.isDeletionRecord() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getFromPosition() {
        return this.fromPosition;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isReachedEnd() {
        return this.reachedEnd;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isShouldClear() {
        return this.shouldClear;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDeletionRecord() {
        return this.deletionRecord;
    }

    private static class Serializer
    extends VersionedSerializer.WithBuilder<DeltaIteratorState, DeltaIteratorStateBuilder> {
        private Serializer() {
        }

        protected DeltaIteratorStateBuilder newBuilder() {
            return new DeltaIteratorStateBuilder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, DeltaIteratorStateBuilder builder) throws IOException {
            builder.fromPosition = revisionDataInput.readCompactLong();
            builder.reachedEnd = revisionDataInput.readBoolean();
            builder.shouldClear = revisionDataInput.readBoolean();
            builder.deletionRecord = revisionDataInput.readBoolean();
        }

        private void write00(DeltaIteratorState state, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.length(revisionDataOutput.getCompactLongLength(state.fromPosition) + 3);
            revisionDataOutput.writeCompactLong(state.fromPosition);
            revisionDataOutput.writeBoolean(state.reachedEnd);
            revisionDataOutput.writeBoolean(state.shouldClear);
            revisionDataOutput.writeBoolean(state.deletionRecord);
        }
    }

    private static class DeltaIteratorStateBuilder
    implements ObjectBuilder<DeltaIteratorState> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long fromPosition;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean reachedEnd;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean shouldClear;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean deletionRecord;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        DeltaIteratorStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeltaIteratorStateBuilder fromPosition(long fromPosition) {
            this.fromPosition = fromPosition;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeltaIteratorStateBuilder reachedEnd(boolean reachedEnd) {
            this.reachedEnd = reachedEnd;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeltaIteratorStateBuilder shouldClear(boolean shouldClear) {
            this.shouldClear = shouldClear;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeltaIteratorStateBuilder deletionRecord(boolean deletionRecord) {
            this.deletionRecord = deletionRecord;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeltaIteratorState build() {
            return new DeltaIteratorState(this.fromPosition, this.reachedEnd, this.shouldClear, this.deletionRecord);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "DeltaIteratorState.DeltaIteratorStateBuilder(fromPosition=" + this.fromPosition + ", reachedEnd=" + this.reachedEnd + ", shouldClear=" + this.shouldClear + ", deletionRecord=" + this.deletionRecord + ")";
        }
    }
}

