/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.SerializationException;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.BufferViewBuilder;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

class EntrySerializer {
    static final int HEADER_LENGTH = 17;
    static final int MAX_KEY_LENGTH = 8192;
    static final int MAX_SERIALIZATION_LENGTH = 0x100000;
    static final int MAX_BATCH_SIZE = 0x2000000;
    private static final int VERSION_POSITION = 0;
    private static final int KEY_POSITION = 1;
    private static final int VALUE_POSITION = 5;
    private static final int ENTRY_VERSION_POSITION = 9;
    private static final byte CURRENT_SERIALIZATION_VERSION = 0;
    private static final int NO_VALUE = -1;

    EntrySerializer() {
    }

    int getUpdateLength(@NonNull TableEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return 17 + entry.getKey().getKey().getLength() + entry.getValue().getLength();
    }

    BufferView serializeUpdate(@NonNull Collection<TableEntry> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return this.serializeUpdate(entries, e -> Long.MIN_VALUE);
    }

    private BufferView serializeUpdate(@NonNull Collection<TableEntry> entries, Function<TableKey, Long> getVersion) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        BufferViewBuilder builder = BufferView.builder((int)(entries.size() * 3));
        entries.forEach(e -> this.serializeUpdate((TableEntry)e, getVersion, arg_0 -> ((BufferViewBuilder)builder).add(arg_0)));
        Preconditions.checkArgument((builder.getLength() <= 0x2000000 ? 1 : 0) != 0, (String)"Update batch size cannot exceed %s. Given %s.", (int)0x2000000, (int)builder.getLength());
        return builder.build();
    }

    private void serializeUpdate(@NonNull TableEntry entry, Function<TableKey, Long> getVersion, Consumer<BufferView> acceptBuffer) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        BufferView key = entry.getKey().getKey();
        BufferView value = entry.getValue();
        Preconditions.checkArgument((key.getLength() <= 8192 ? 1 : 0) != 0, (Object)"Key too large.");
        int serializationLength = this.getUpdateLength(entry);
        Preconditions.checkArgument((serializationLength <= 0x100000 ? 1 : 0) != 0, (Object)"Key+Value serialization too large.");
        acceptBuffer.accept(this.serializeHeader(key.getLength(), value.getLength(), getVersion.apply(entry.getKey())));
        acceptBuffer.accept(key);
        acceptBuffer.accept(value);
    }

    BufferView serializeUpdateWithExplicitVersion(@NonNull Collection<TableEntry> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return this.serializeUpdate(entries, TableKey::getVersion);
    }

    int getRemovalLength(@NonNull TableKey key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return 17 + key.getKey().getLength();
    }

    BufferView serializeRemoval(@NonNull Collection<TableKey> keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        BufferViewBuilder builder = BufferView.builder((int)(keys.size() * 2));
        keys.forEach(k -> this.serializeRemoval((TableKey)k, arg_0 -> ((BufferViewBuilder)builder).add(arg_0)));
        return builder.build();
    }

    private void serializeRemoval(@NonNull TableKey tableKey, Consumer<BufferView> acceptBuffer) {
        if (tableKey == null) {
            throw new NullPointerException("tableKey is marked non-null but is null");
        }
        BufferView key = tableKey.getKey();
        Preconditions.checkArgument((key.getLength() <= 8192 ? 1 : 0) != 0, (Object)"Key too large.");
        acceptBuffer.accept(this.serializeHeader(key.getLength(), -1, Long.MIN_VALUE));
        acceptBuffer.accept(key);
    }

    Header readHeader(@NonNull BufferView.Reader input) throws SerializationException {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        byte version = input.readByte();
        int keyLength = input.readInt();
        int valueLength = input.readInt();
        long entryVersion = input.readLong();
        this.validateHeader(keyLength, valueLength);
        return new Header(version, keyLength, valueLength, entryVersion);
    }

    private BufferView serializeHeader(int keyLength, int valueLength, long entryVersion) {
        ByteArraySegment data = new ByteArraySegment(new byte[17]);
        data.set(0, (byte)0);
        data.setInt(1, keyLength);
        data.setInt(5, valueLength);
        data.setLong(9, entryVersion);
        return data;
    }

    private void validateHeader(int keyLength, int valueLength) throws SerializationException {
        if (keyLength <= 0 || keyLength > 8192 || valueLength < 0 && valueLength != -1 || keyLength + valueLength > 0x100000) {
            throw new SerializationException(String.format("Read header with invalid data. KeyLength=%s, ValueLength=%s", keyLength, valueLength));
        }
    }

    static class Header {
        private final byte serializationVersion;
        private final int keyLength;
        private final int valueLength;
        private final long entryVersion;

        int getKeyOffset() {
            return 17;
        }

        int getValueOffset() {
            Preconditions.checkState((!this.isDeletion() ? 1 : 0) != 0, (Object)"Cannot request value offset for a removal entry.");
            return 17 + this.keyLength;
        }

        int getTotalLength() {
            return 17 + this.keyLength + Math.max(0, this.valueLength);
        }

        boolean isDeletion() {
            return this.valueLength == -1;
        }

        public String toString() {
            return String.format("Length: {K=%s, V=%s}, EntryVersion: %s", this.keyLength, this.valueLength, this.entryVersion);
        }

        @ConstructorProperties(value={"serializationVersion", "keyLength", "valueLength", "entryVersion"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Header(byte serializationVersion, int keyLength, int valueLength, long entryVersion) {
            this.serializationVersion = serializationVersion;
            this.keyLength = keyLength;
            this.valueLength = valueLength;
            this.entryVersion = entryVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getKeyLength() {
            return this.keyLength;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getValueLength() {
            return this.valueLength;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getEntryVersion() {
            return this.entryVersion;
        }
    }
}

