/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import io.pravega.common.TimeoutTimer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.Retry;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.BadAttributeUpdateException;
import io.pravega.segmentstore.contracts.DynamicAttributeUpdate;
import io.pravega.segmentstore.contracts.DynamicAttributeValue;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.tables.TableCompactor;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import lombok.NonNull;

class FixedKeyLengthTableCompactor
extends TableCompactor {
    private static final Retry.RetryAndThrowBase<Exception> RETRY_POLICY = Retry.withExpBackoff((long)1L, (int)5, (int)5).retryingOn(BadAttributeUpdateException.class).throwingOn(Exception.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);

    FixedKeyLengthTableCompactor(@NonNull DirectSegmentAccess segment, @NonNull TableCompactor.Config config, @NonNull ScheduledExecutorService executor) {
        super(segment, config, executor);
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
    }

    @Override
    protected long getLastIndexedOffset() {
        return this.metadata.getLength();
    }

    @Override
    protected CompletableFuture<Long> getUniqueEntryCount() {
        return this.segment.getExtendedAttributeCount(DEFAULT_TIMEOUT);
    }

    @Override
    protected CompletableFuture<Void> excludeObsolete(TableCompactor.CompactionArgs args, TimeoutTimer timer) {
        Map<AttributeId, TableCompactor.Candidate> byAttributeId = args.getAll().stream().collect(Collectors.toMap(c -> AttributeId.from((byte[])c.entry.getKey().getKey().getCopy()), c -> c));
        return this.segment.getAttributes(byAttributeId.keySet(), false, timer.getRemaining()).thenAcceptAsync(attributeValues -> this.excludeObsolete(args, byAttributeId, (Map<AttributeId, Long>)attributeValues), (Executor)this.executor);
    }

    private void excludeObsolete(TableCompactor.CompactionArgs args, Map<AttributeId, TableCompactor.Candidate> candidatesByAttributeId, Map<AttributeId, Long> indexValues) {
        Iterator<Map.Entry<AttributeId, TableCompactor.Candidate>> entryIterator = candidatesByAttributeId.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<AttributeId, TableCompactor.Candidate> e = entryIterator.next();
            boolean exists = indexValues.getOrDefault(e.getKey(), Long.MIN_VALUE) != Long.MIN_VALUE;
            if (exists) continue;
            args.remove(e.getValue());
            entryIterator.remove();
        }
        for (Map.Entry<AttributeId, Long> e : indexValues.entrySet()) {
            if (e.getValue() == Long.MIN_VALUE) continue;
            TableKey existingKey = TableKey.versioned((BufferView)e.getKey().toBuffer(), (long)e.getValue());
            args.handleExistingKey(existingKey, e.getValue());
        }
    }

    @Override
    protected int calculateTotalEntryDelta(TableCompactor.CompactionArgs candidates) {
        int delta = candidates.getCount() - candidates.getCopyCandidateCount();
        assert (delta >= 0) : "compaction cannot increase total entry count";
        return -delta;
    }

    @Override
    protected void generateIndexUpdates(TableCompactor.Candidate c, int batchOffset, AttributeUpdateCollection indexUpdates) {
        DynamicAttributeUpdate au = new DynamicAttributeUpdate(AttributeId.from((byte[])c.entry.getKey().getKey().getCopy()), AttributeUpdateType.ReplaceIfEquals, DynamicAttributeValue.segmentLength((long)batchOffset), c.segmentOffset);
        indexUpdates.add((AttributeUpdate)au);
    }

    @Override
    protected Retry.RetryAndThrowBase<Exception> getRetryPolicy() {
        return RETRY_POLICY;
    }
}

