/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.DelayedProcessor;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.BadAttributeUpdateException;
import io.pravega.segmentstore.contracts.DynamicAttributeUpdate;
import io.pravega.segmentstore.contracts.DynamicAttributeValue;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.StreamSegmentTruncatedException;
import io.pravega.segmentstore.contracts.tables.BadKeyVersionException;
import io.pravega.segmentstore.contracts.tables.IteratorArgs;
import io.pravega.segmentstore.contracts.tables.IteratorItem;
import io.pravega.segmentstore.contracts.tables.IteratorState;
import io.pravega.segmentstore.contracts.tables.KeyNotExistsException;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableSegmentConfig;
import io.pravega.segmentstore.contracts.tables.TableSegmentInfo;
import io.pravega.segmentstore.server.AttributeIterator;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.reading.AsyncReadResultProcessor;
import io.pravega.segmentstore.server.tables.AsyncTableEntryReader;
import io.pravega.segmentstore.server.tables.FixedKeyLengthTableCompactor;
import io.pravega.segmentstore.server.tables.TableCompactor;
import io.pravega.segmentstore.server.tables.TableExtensionConfig;
import io.pravega.segmentstore.server.tables.TableSegmentLayout;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
class FixedKeyLengthTableSegmentLayout
extends TableSegmentLayout {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FixedKeyLengthTableSegmentLayout.class);
    private final DelayedProcessor<CompactionCandidate> compactionService;
    private final TableCompactor.Config tableCompactorConfig;

    FixedKeyLengthTableSegmentLayout(TableSegmentLayout.Connector connector, TableExtensionConfig config, ScheduledExecutorService executor) {
        super(connector, config, executor);
        this.compactionService = new DelayedProcessor(this::compactIfNeeded, config.getCompactionFrequency(), executor, String.format("TableCompactor[%s]", connector.getContainerId()));
        this.tableCompactorConfig = new TableCompactor.Config(config.getMaxCompactionSize());
    }

    @Override
    public void close() {
        this.compactionService.close();
        log.info("{}: Closed.", (Object)this.traceObjectId);
    }

    @Override
    Collection<WriterSegmentProcessor> createWriterSegmentProcessors(UpdateableSegmentMetadata metadata) {
        return Collections.emptyList();
    }

    @Override
    Map<AttributeId, Long> getNewSegmentAttributes(@NonNull TableSegmentConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.ensureValidKeyLength("", config.getKeyLength());
        HashMap<AttributeId, Long> result = new HashMap<AttributeId, Long>();
        result.put(Attributes.ATTRIBUTE_ID_LENGTH, Long.valueOf(config.getKeyLength()));
        result.putAll(this.config.getDefaultCompactionAttributes());
        if (config.getRolloverSizeBytes() > 0L) {
            result.put(Attributes.ROLLOVER_SIZE, config.getRolloverSizeBytes());
        }
        return result;
    }

    @Override
    CompletableFuture<Void> deleteSegment(@NonNull String segmentName, boolean mustBeEmpty, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked non-null but is null");
        }
        if (mustBeEmpty) {
            throw new UnsupportedOperationException("mustBeEmpty not supported on Fixed-Key-Length Table Segments.");
        }
        return this.connector.deleteSegment(segmentName, timeout).thenRun(() -> this.compactionService.cancel(segmentName));
    }

    @Override
    CompletableFuture<List<Long>> put(@NonNull DirectSegmentAccess segment, @NonNull List<TableEntry> entries, long tableSegmentOffset, TimeoutTimer timer) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        SegmentMetadata segmentInfo = segment.getInfo();
        this.ensureSegmentType(segmentInfo.getName(), segmentInfo.getType());
        int segmentKeyLength = this.getSegmentKeyLength(segmentInfo);
        this.ensureValidKeyLength(segmentInfo.getName(), segmentKeyLength);
        AttributeUpdateCollection attributeUpdates = new AttributeUpdateCollection();
        int batchOffset = 0;
        ArrayList<Integer> batchOffsets = new ArrayList<Integer>();
        boolean isConditional = false;
        for (TableEntry e : entries) {
            TableKey key = e.getKey();
            Preconditions.checkArgument((key.getKey().getLength() == segmentKeyLength ? 1 : 0) != 0, (String)"Entry Key Length for key `%s` incompatible with segment '%s' which requires key lengths of %s.", (Object)key, (Object)segmentInfo.getName(), (Object)segmentKeyLength);
            attributeUpdates.add(this.createIndexUpdate(key, batchOffset));
            isConditional |= key.hasVersion();
            batchOffsets.add(batchOffset);
            batchOffset += this.serializer.getUpdateLength(e);
        }
        this.logRequest("put", segmentInfo.getName(), isConditional, tableSegmentOffset, entries.size(), batchOffset);
        if (batchOffset > this.config.getMaxBatchSize()) {
            throw new TableSegmentLayout.UpdateBatchTooLargeException(batchOffset, this.config.getMaxBatchSize());
        }
        attributeUpdates.add(new AttributeUpdate(TableAttributes.TOTAL_ENTRY_COUNT, AttributeUpdateType.Accumulate, (long)entries.size()));
        BufferView serializedEntries = this.serializer.serializeUpdate(entries);
        CompletableFuture<Long> append = tableSegmentOffset == -1L ? segment.append(serializedEntries, attributeUpdates, timer.getRemaining()) : segment.append(serializedEntries, attributeUpdates, tableSegmentOffset, timer.getRemaining());
        return this.handleConditionalUpdateException(append, segmentInfo).thenApply(segmentOffset -> {
            this.compactionService.process((DelayedProcessor.Item)new CompactionCandidate(segment));
            return batchOffsets.stream().map(offset -> (long)offset.intValue() + segmentOffset).collect(Collectors.toList());
        });
    }

    @Override
    CompletableFuture<Void> remove(@NonNull DirectSegmentAccess segment, @NonNull Collection<TableKey> keys, long tableSegmentOffset, TimeoutTimer timer) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        SegmentMetadata segmentInfo = segment.getInfo();
        this.ensureSegmentType(segmentInfo.getName(), segmentInfo.getType());
        int segmentKeyLength = this.getSegmentKeyLength(segmentInfo);
        this.ensureValidKeyLength(segmentInfo.getName(), segmentKeyLength);
        AttributeUpdateCollection attributeUpdates = new AttributeUpdateCollection();
        boolean isConditional = false;
        for (TableKey key : keys) {
            Preconditions.checkArgument((key.getKey().getLength() == segmentKeyLength ? 1 : 0) != 0, (String)"Key Length for key `%s` incompatible with segment '%s' which requires key lengths of %s.", (Object)key, (Object)segmentInfo.getName(), (Object)segmentKeyLength);
            attributeUpdates.add(this.createIndexRemoval(key));
            isConditional |= key.hasVersion();
        }
        this.logRequest("remove", segmentInfo.getName(), isConditional, tableSegmentOffset, keys.size());
        CompletableFuture<Void> result = tableSegmentOffset == -1L ? segment.updateAttributes(attributeUpdates, timer.getRemaining()) : segment.append(BufferView.empty(), attributeUpdates, tableSegmentOffset, timer.getRemaining());
        return this.handleConditionalUpdateException(result, segmentInfo).thenRun(() -> this.compactionService.process((DelayedProcessor.Item)new CompactionCandidate(segment)));
    }

    @Override
    CompletableFuture<List<TableEntry>> get(@NonNull DirectSegmentAccess segment, @NonNull List<BufferView> keys, TimeoutTimer timer) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        SegmentMetadata segmentInfo = segment.getInfo();
        this.ensureSegmentType(segmentInfo.getName(), segmentInfo.getType());
        List<AttributeId> attributes = keys.stream().map(key -> {
            this.ensureValidKeyLength(segmentInfo.getName(), key.getLength());
            return AttributeId.from((byte[])key.getCopy());
        }).collect(Collectors.toList());
        this.logRequest("get", segmentInfo.getName(), keys.size());
        return this.getByAttributes(segment, attributes, timer);
    }

    private CompletableFuture<List<TableEntry>> getByAttributes(DirectSegmentAccess segment, List<AttributeId> attributes, TimeoutTimer timer) {
        return segment.getAttributes(attributes, false, timer.getRemaining()).thenComposeAsync(attributeValues -> {
            ArrayList<CompletableFuture<TableEntry>> result = new ArrayList<CompletableFuture<TableEntry>>(attributes.size());
            for (AttributeId attributeId : attributes) {
                Long segmentOffset = attributeValues.getOrDefault(attributeId, -1L);
                result.add(this.getEntryWithSingleRetry(segment, attributeId, segmentOffset, timer));
            }
            return Futures.allOfWithResults(result);
        }, (Executor)this.executor);
    }

    private CompletableFuture<TableEntry> getEntryWithSingleRetry(DirectSegmentAccess segment, AttributeId attributeId, long segmentOffset, TimeoutTimer timer) {
        return Futures.exceptionallyComposeExpecting(this.getEntry(segment, attributeId, segmentOffset, timer), ex -> ex instanceof StreamSegmentTruncatedException, () -> {
            log.debug("{}: Offset {} truncated while reading key '{}'. Retrying once.", new Object[]{this.traceObjectId, segmentOffset, attributeId});
            return segment.getAttributes(Collections.singletonList(attributeId), false, timer.getRemaining()).thenComposeAsync(attributeValues -> this.getEntry(segment, attributeId, attributeValues.getOrDefault(attributeId, -1L), timer));
        });
    }

    private CompletableFuture<TableEntry> getEntry(@NonNull DirectSegmentAccess segment, AttributeId attributeId, long segmentOffset, TimeoutTimer timer) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (segmentOffset < 0L) {
            return CompletableFuture.completedFuture(null);
        }
        AsyncTableEntryReader<TableEntry> entryReader = AsyncTableEntryReader.readEntry((BufferView)attributeId.toBuffer(), segmentOffset, this.serializer, timer);
        ReadResult readResult = segment.read(segmentOffset, 0x100000, timer.getRemaining());
        AsyncReadResultProcessor.process(readResult, entryReader, this.executor);
        return entryReader.getResult();
    }

    @Override
    CompletableFuture<AsyncIterator<IteratorItem<TableKey>>> keyIterator(@NonNull DirectSegmentAccess segment, IteratorArgs args) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        this.logRequest("keyIterator", segment.getInfo().getName(), args);
        return this.newIterator(segment, this::getIteratorKeys, args);
    }

    @Override
    CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryIterator(@NonNull DirectSegmentAccess segment, IteratorArgs args) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        this.logRequest("entryIterator", segment.getInfo().getName(), args);
        return this.newIterator(segment, this::getIteratorEntries, args);
    }

    @Override
    AsyncIterator<IteratorItem<TableEntry>> entryDeltaIterator(@NonNull DirectSegmentAccess segment, long fromPosition, Duration fetchTimeout) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        throw new UnsupportedOperationException("entryDeltaIterator");
    }

    @Override
    CompletableFuture<TableSegmentInfo> getInfo(@NonNull DirectSegmentAccess segment, Duration timeout) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        SegmentMetadata m = segment.getInfo();
        return segment.getExtendedAttributeCount(timeout).thenApply(entryCount -> TableSegmentInfo.builder().name(m.getName()).length(m.getLength()).startOffset(m.getStartOffset()).type(m.getType()).entryCount(entryCount.longValue()).keyLength(this.getSegmentKeyLength(m)).build());
    }

    private AttributeUpdate createIndexUpdate(TableKey key, int batchOffset) {
        AttributeId attributeId = AttributeId.from((byte[])key.getKey().getCopy());
        DynamicAttributeValue ref = DynamicAttributeValue.segmentLength((long)batchOffset);
        return key.hasVersion() ? new DynamicAttributeUpdate(attributeId, AttributeUpdateType.ReplaceIfEquals, ref, this.getCompareVersion(key)) : new DynamicAttributeUpdate(attributeId, AttributeUpdateType.Replace, ref);
    }

    private AttributeUpdate createIndexRemoval(TableKey key) {
        AttributeId attributeId = AttributeId.from((byte[])key.getKey().getCopy());
        return key.hasVersion() ? new AttributeUpdate(attributeId, AttributeUpdateType.ReplaceIfEquals, Long.MIN_VALUE, this.getCompareVersion(key)) : new AttributeUpdate(attributeId, AttributeUpdateType.Replace, Long.MIN_VALUE);
    }

    private <T> CompletableFuture<T> handleConditionalUpdateException(CompletableFuture<T> update, SegmentProperties segmentInfo) {
        return update.exceptionally(ex -> {
            if ((ex = Exceptions.unwrap((Throwable)ex)) instanceof BadAttributeUpdateException) {
                BadAttributeUpdateException bau = (BadAttributeUpdateException)ex;
                ex = bau.isPreviousValueMissing() ? new KeyNotExistsException(segmentInfo.getName(), (BufferView)bau.getAttributeId().toBuffer()) : new BadKeyVersionException(segmentInfo.getName(), Collections.emptyMap());
            }
            throw new CompletionException((Throwable)ex);
        });
    }

    private CompletableFuture<Void> compactIfNeeded(CompactionCandidate candidate) {
        FixedKeyLengthTableCompactor compactor = new FixedKeyLengthTableCompactor(candidate.getSegment(), this.tableCompactorConfig, this.executor);
        TimeoutTimer timer = new TimeoutTimer(this.config.getRecoveryTimeout());
        return compactor.isCompactionRequired().thenComposeAsync(isRequired -> {
            if (isRequired.booleanValue()) {
                return this.compact(candidate.getSegment(), compactor, timer);
            }
            log.debug("{}: No compaction required at this time.", (Object)this.traceObjectId);
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.executor);
    }

    private CompletableFuture<Void> compact(DirectSegmentAccess segment, FixedKeyLengthTableCompactor compactor, TimeoutTimer timer) {
        return compactor.compact(timer).thenComposeAsync(v -> {
            SegmentMetadata metadata = segment.getInfo();
            long truncateOffset = compactor.calculateTruncationOffset(-1L);
            if (truncateOffset > metadata.getStartOffset()) {
                log.debug("{}: Truncating segment at offset {}.", (Object)this.traceObjectId, (Object)truncateOffset);
                return segment.truncate(truncateOffset, timer.getRemaining());
            }
            log.debug("{}: No segment truncation possible now.", (Object)this.traceObjectId);
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.executor);
    }

    private <T> CompletableFuture<AsyncIterator<IteratorItem<T>>> newIterator(@NonNull DirectSegmentAccess segment, @NonNull GetIteratorItem<T> getItems, @NonNull IteratorArgs args) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (getItems == null) {
            throw new NullPointerException("getItems is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        Preconditions.checkArgument((args.getContinuationToken() == null ? 1 : 0) != 0, (Object)"ContinuationToken not supported for FixedKeyLengthTableSegments.");
        int segmentKeyLength = this.getSegmentKeyLength(segment.getInfo());
        AttributeId fromId = args.getFrom() == null ? AttributeId.Variable.minValue((int)segmentKeyLength) : AttributeId.from((byte[])args.getFrom().getCopy());
        AttributeId toId = args.getTo() == null ? AttributeId.Variable.maxValue((int)segmentKeyLength) : AttributeId.from((byte[])args.getTo().getCopy());
        TimeoutTimer timer = new TimeoutTimer(args.getFetchTimeout());
        return segment.attributeIterator(fromId, toId, timer.getRemaining()).thenApply(ai -> new TableIterator((AttributeIterator)ai, segment, getItems, timer));
    }

    private void ensureSegmentType(String segmentName, SegmentType segmentType) {
        Preconditions.checkArgument((boolean)segmentType.isFixedKeyLengthTableSegment(), (String)"FixedKeyTableSegmentLayout can only be used for Fixed-Key Table Segments; Segment '%s' is '%s;.", (Object)segmentName, (Object)segmentType);
    }

    private void ensureValidKeyLength(String segmentName, int keyLength) {
        Preconditions.checkArgument((keyLength > 0 && keyLength <= 256 ? 1 : 0) != 0, (String)"Segment KeyLength for segment `%s' must be a positive integer smaller than or equal to %s; actual %s.", (Object)segmentName, (Object)256, (Object)keyLength);
    }

    private int getSegmentKeyLength(SegmentProperties segmentInfo) {
        return (int)segmentInfo.getAttributes().getOrDefault(Attributes.ATTRIBUTE_ID_LENGTH, -1L).longValue();
    }

    private CompletableFuture<List<TableKey>> getIteratorKeys(DirectSegmentAccess segment, List<Map.Entry<AttributeId, Long>> keys, TimeoutTimer timer) {
        return CompletableFuture.completedFuture(keys.stream().map(e -> TableKey.versioned((BufferView)((AttributeId)e.getKey()).toBuffer(), (long)((Long)e.getValue()))).collect(Collectors.toList()));
    }

    private CompletableFuture<List<TableEntry>> getIteratorEntries(DirectSegmentAccess segment, List<Map.Entry<AttributeId, Long>> keys, TimeoutTimer timer) {
        return this.get(segment, keys.stream().map(e -> ((AttributeId)e.getKey()).toBuffer()).collect(Collectors.toList()), timer);
    }

    private long getCompareVersion(TableKey key) {
        return key.getVersion() == -1L ? Long.MIN_VALUE : key.getVersion();
    }

    public static class IteratorStateImpl
    implements IteratorState {
        private static final Serializer SERIALIZER = new Serializer();
        private final BufferView lastKey;

        public String toString() {
            return String.format("LastKey = %s", this.lastKey);
        }

        static IteratorStateImpl deserialize(BufferView data) throws IOException {
            return (IteratorStateImpl)SERIALIZER.deserialize(data);
        }

        public ArrayView serialize() {
            return SERIALIZER.serialize(this);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static IteratorStateImplBuilder builder() {
            return new IteratorStateImplBuilder();
        }

        @ConstructorProperties(value={"lastKey"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public IteratorStateImpl(BufferView lastKey) {
            this.lastKey = lastKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BufferView getLastKey() {
            return this.lastKey;
        }

        private static class Serializer
        extends VersionedSerializer.WithBuilder<IteratorStateImpl, IteratorStateImplBuilder> {
            private Serializer() {
            }

            protected IteratorStateImplBuilder newBuilder() {
                return new IteratorStateImplBuilder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput revisionDataInput, IteratorStateImplBuilder builder) throws IOException {
                builder.lastKey = new ByteArraySegment(revisionDataInput.readArray());
                if (builder.lastKey.getLength() == 0) {
                    builder.lastKey = null;
                }
            }

            private void write00(IteratorStateImpl state, RevisionDataOutput revisionDataOutput) throws IOException {
                revisionDataOutput.writeBuffer(state.lastKey);
            }
        }

        private static class IteratorStateImplBuilder
        implements ObjectBuilder<IteratorStateImpl> {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private BufferView lastKey;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            IteratorStateImplBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public IteratorStateImplBuilder lastKey(BufferView lastKey) {
                this.lastKey = lastKey;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public IteratorStateImpl build() {
                return new IteratorStateImpl(this.lastKey);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "FixedKeyLengthTableSegmentLayout.IteratorStateImpl.IteratorStateImplBuilder(lastKey=" + this.lastKey + ")";
            }
        }
    }

    @FunctionalInterface
    private static interface GetIteratorItem<T> {
        public CompletableFuture<List<T>> apply(DirectSegmentAccess var1, List<Map.Entry<AttributeId, Long>> var2, TimeoutTimer var3);
    }

    private class TableIterator<T>
    implements AsyncIterator<IteratorItem<T>> {
        private final AttributeIterator attributeIterator;
        private final DirectSegmentAccess segment;
        private final GetIteratorItem<T> getItems;
        private final TimeoutTimer timer;

        public CompletableFuture<IteratorItem<T>> getNext() {
            return this.getNextAttributes().thenCompose(attributePairs -> {
                IteratorStateImpl.IteratorStateImplBuilder stateBuilder = IteratorStateImpl.builder();
                if (attributePairs == null) {
                    return CompletableFuture.completedFuture(null);
                }
                stateBuilder.lastKey((BufferView)((AttributeId)((Map.Entry)attributePairs.get(attributePairs.size() - 1)).getKey()).toBuffer());
                CompletableFuture<List<T>> result = this.getItems.apply(this.segment, (List<Map.Entry<AttributeId, Long>>)attributePairs, this.timer);
                return result.thenApply(items -> new TableSegmentLayout.IteratorItemImpl((BufferView)stateBuilder.build().serialize(), items));
            });
        }

        private CompletableFuture<List<Map.Entry<AttributeId, Long>>> getNextAttributes() {
            AtomicReference result = new AtomicReference();
            AtomicBoolean retry = new AtomicBoolean(true);
            return Futures.loop(retry::get, () -> ((AttributeIterator)this.attributeIterator).getNext(), p -> {
                result.set(p);
                if (p == null) {
                    retry.set(false);
                } else {
                    p.removeIf(e -> (Long)e.getValue() == Long.MIN_VALUE);
                    retry.set(p.isEmpty());
                }
            }, (Executor)FixedKeyLengthTableSegmentLayout.this.executor).thenApply(v -> (List)result.get());
        }

        @ConstructorProperties(value={"attributeIterator", "segment", "getItems", "timer"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableIterator(AttributeIterator attributeIterator, DirectSegmentAccess segment, GetIteratorItem<T> getItems, TimeoutTimer timer) {
            this.attributeIterator = attributeIterator;
            this.segment = segment;
            this.getItems = getItems;
            this.timer = timer;
        }
    }

    private static class CompactionCandidate
    implements DelayedProcessor.Item {
        private final DirectSegmentAccess segment;

        public String key() {
            return this.segment.getInfo().getName();
        }

        @ConstructorProperties(value={"segment"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CompactionCandidate(DirectSegmentAccess segment) {
            this.segment = segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DirectSegmentAccess getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompactionCandidate)) {
                return false;
            }
            CompactionCandidate other = (CompactionCandidate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DirectSegmentAccess this$segment = this.getSegment();
            DirectSegmentAccess other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CompactionCandidate;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DirectSegmentAccess $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "FixedKeyLengthTableSegmentLayout.CompactionCandidate(segment=" + this.getSegment() + ")";
        }
    }
}

