/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.tables.IndexReader;
import io.pravega.segmentstore.server.tables.KeyHasher;
import io.pravega.segmentstore.server.tables.TableBucket;
import io.pravega.segmentstore.server.tables.TableBucketReader;
import io.pravega.segmentstore.server.tables.TableCompactor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import lombok.NonNull;

class HashTableCompactor
extends TableCompactor {
    private final KeyHasher hasher;
    private final IndexReader indexReader;

    HashTableCompactor(DirectSegmentAccess segment, TableCompactor.Config config, @NonNull IndexReader indexReader, @NonNull KeyHasher hasher, ScheduledExecutorService executor) {
        super(segment, config, executor);
        if (indexReader == null) {
            throw new NullPointerException("indexReader is marked non-null but is null");
        }
        if (hasher == null) {
            throw new NullPointerException("hasher is marked non-null but is null");
        }
        this.hasher = hasher;
        this.indexReader = indexReader;
    }

    @Override
    protected long getLastIndexedOffset() {
        return IndexReader.getLastIndexedOffset(this.metadata);
    }

    @Override
    protected CompletableFuture<Long> getUniqueEntryCount() {
        return CompletableFuture.completedFuture(IndexReader.getEntryCount(this.metadata));
    }

    @Override
    protected IndexedCompactionArgs newCompactionArgs(long startOffset) {
        return new IndexedCompactionArgs(startOffset);
    }

    @Override
    protected CompletableFuture<Void> excludeObsolete(TableCompactor.CompactionArgs args, TimeoutTimer timer) {
        IndexedCompactionArgs indexedArgs = (IndexedCompactionArgs)args;
        return this.indexReader.locateBuckets(this.segment, indexedArgs.candidatesByHash.keySet(), timer).thenComposeAsync(buckets -> this.excludeObsolete(indexedArgs, (Map<UUID, TableBucket>)buckets, timer), (Executor)this.executor);
    }

    private CompletableFuture<Void> excludeObsolete(IndexedCompactionArgs args, Map<UUID, TableBucket> buckets, TimeoutTimer timer) {
        List deletedBuckets = args.candidatesByHash.keySet().stream().filter(k -> {
            TableBucket bucket = (TableBucket)buckets.get(k);
            return bucket == null || !bucket.exists();
        }).collect(Collectors.toList());
        for (UUID bucket : deletedBuckets) {
            args.removeBucket(bucket);
        }
        TableBucketReader<TableKey> br = TableBucketReader.key(this.segment, this.indexReader::getBackpointerOffset, this.executor);
        Iterator<UUID> candidateBuckets = args.candidatesByHash.keySet().iterator();
        return Futures.loop(candidateBuckets::hasNext, () -> {
            UUID bucketId = (UUID)candidateBuckets.next();
            long bucketOffset = ((TableBucket)buckets.get(bucketId)).getSegmentOffset();
            return br.findAll(bucketOffset, args::handleExistingKey, timer);
        }, (Executor)this.executor);
    }

    @Override
    protected int calculateTotalEntryDelta(TableCompactor.CompactionArgs candidates) {
        return -candidates.getCount();
    }

    private class IndexedCompactionArgs
    extends TableCompactor.CompactionArgs {
        private final Map<UUID, Map<BufferView, TableCompactor.Candidate>> candidatesByHash;

        IndexedCompactionArgs(long startOffset) {
            super(startOffset);
            this.candidatesByHash = new HashMap<UUID, Map<BufferView, TableCompactor.Candidate>>();
        }

        @Override
        boolean add(TableCompactor.Candidate c) {
            boolean added = super.add(c);
            if (added) {
                UUID hash = HashTableCompactor.this.hasher.hash(c.entry.getKey().getKey());
                Map hashCandidates = this.candidatesByHash.computeIfAbsent(hash, h -> new HashMap());
                hashCandidates.put(c.entry.getKey().getKey(), c);
            }
            return added;
        }

        void removeBucket(UUID bucketId) {
            Map<BufferView, TableCompactor.Candidate> candidates = this.candidatesByHash.remove(bucketId);
            if (candidates != null) {
                super.removeAll(candidates.values());
            }
        }
    }
}

