/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Runnables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.IllegalDataFormatException;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.tables.IteratorArgs;
import io.pravega.segmentstore.contracts.tables.IteratorItem;
import io.pravega.segmentstore.contracts.tables.IteratorState;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableSegmentConfig;
import io.pravega.segmentstore.contracts.tables.TableSegmentInfo;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.logs.operations.OperationPriority;
import io.pravega.segmentstore.server.tables.CacheBucketOffset;
import io.pravega.segmentstore.server.tables.ContainerKeyIndex;
import io.pravega.segmentstore.server.tables.DeltaIteratorState;
import io.pravega.segmentstore.server.tables.EntrySerializer;
import io.pravega.segmentstore.server.tables.KeyHasher;
import io.pravega.segmentstore.server.tables.TableBucketReader;
import io.pravega.segmentstore.server.tables.TableEntryDeltaIterator;
import io.pravega.segmentstore.server.tables.TableExtensionConfig;
import io.pravega.segmentstore.server.tables.TableIterator;
import io.pravega.segmentstore.server.tables.TableKeyBatch;
import io.pravega.segmentstore.server.tables.TableSegmentLayout;
import io.pravega.segmentstore.server.tables.TableWriterConnector;
import io.pravega.segmentstore.server.tables.WriterTableProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

class HashTableSegmentLayout
extends TableSegmentLayout {
    private final KeyHasher hasher;
    private final ContainerKeyIndex keyIndex;

    HashTableSegmentLayout(TableSegmentLayout.Connector connector, @NonNull CacheManager cacheManager, KeyHasher hasher, TableExtensionConfig config, ScheduledExecutorService executorService) {
        super(connector, config, executorService);
        if (cacheManager == null) {
            throw new NullPointerException("cacheManager is marked non-null but is null");
        }
        this.hasher = hasher;
        this.keyIndex = new ContainerKeyIndex(connector.getContainerId(), config, cacheManager, this.hasher, this.executor);
    }

    @Override
    public void close() {
        this.keyIndex.close();
    }

    @Override
    Collection<WriterSegmentProcessor> createWriterSegmentProcessors(UpdateableSegmentMetadata metadata) {
        this.ensureSegmentType(metadata.getName(), metadata.getType());
        return Collections.singletonList(new WriterTableProcessor(new TableWriterConnectorImpl(metadata), this.executor));
    }

    @Override
    Map<AttributeId, Long> getNewSegmentAttributes(@NonNull TableSegmentConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        Preconditions.checkArgument((config.getKeyLength() == 0 ? 1 : 0) != 0, (String)"Segment KeyLength must be 0 for HashTableSegments; actual %s.", (int)config.getKeyLength());
        HashMap<AttributeId, Long> result = new HashMap<AttributeId, Long>();
        result.putAll(this.config.getDefaultCompactionAttributes());
        if (config.getRolloverSizeBytes() > 0L) {
            result.put(Attributes.ROLLOVER_SIZE, config.getRolloverSizeBytes());
        }
        return result;
    }

    @Override
    CompletableFuture<Void> deleteSegment(@NonNull String segmentName, boolean mustBeEmpty, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked non-null but is null");
        }
        if (mustBeEmpty) {
            TimeoutTimer timer = new TimeoutTimer(timeout);
            return this.connector.getSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.keyIndex.executeIfEmpty((DirectSegmentAccess)segment, () -> this.connector.deleteSegment(segmentName, timer.getRemaining()), timer), (Executor)this.executor);
        }
        return this.connector.deleteSegment(segmentName, timeout);
    }

    @Override
    CompletableFuture<List<Long>> put(@NonNull DirectSegmentAccess segment, @NonNull List<TableEntry> entries, long tableSegmentOffset, TimeoutTimer timer) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        SegmentMetadata segmentInfo = segment.getInfo();
        this.ensureSegmentType(segmentInfo.getName(), segmentInfo.getType());
        TableKeyBatch updateBatch = this.batch(entries, TableEntry::getKey, this.serializer::getUpdateLength, TableKeyBatch.update());
        this.logRequest("put", segmentInfo.getName(), updateBatch.isConditional(), tableSegmentOffset, entries.size(), updateBatch.getLength());
        return this.keyIndex.update(segment, updateBatch, () -> this.commit(entries, this.serializer::serializeUpdate, segment, tableSegmentOffset, timer.getRemaining()), timer);
    }

    @Override
    CompletableFuture<Void> remove(@NonNull DirectSegmentAccess segment, @NonNull Collection<TableKey> keys, long tableSegmentOffset, TimeoutTimer timer) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        SegmentMetadata segmentInfo = segment.getInfo();
        this.ensureSegmentType(segmentInfo.getName(), segmentInfo.getType());
        TableKeyBatch removeBatch = this.batch(keys, key -> key, this.serializer::getRemovalLength, TableKeyBatch.removal());
        this.logRequest("remove", segmentInfo.getName(), removeBatch.isConditional(), removeBatch.isRemoval(), keys.size(), removeBatch.getLength());
        return this.keyIndex.update(segment, removeBatch, () -> this.commit(keys, this.serializer::serializeRemoval, segment, tableSegmentOffset, timer.getRemaining()), timer).thenRun(Runnables.doNothing());
    }

    @Override
    CompletableFuture<List<TableEntry>> get(@NonNull DirectSegmentAccess segment, @NonNull List<BufferView> keys, TimeoutTimer timer) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        SegmentMetadata segmentInfo = segment.getInfo();
        this.ensureSegmentType(segmentInfo.getName(), segmentInfo.getType());
        this.logRequest("get", segmentInfo.getName(), keys.size());
        GetResultBuilder resultBuilder = new GetResultBuilder(keys, this.hasher);
        return this.keyIndex.getBucketOffsets(segment, resultBuilder.getHashes(), timer).thenComposeAsync(offsets -> this.get(segment, resultBuilder, (Map<UUID, Long>)offsets, timer), (Executor)this.executor);
    }

    private CompletableFuture<List<TableEntry>> get(DirectSegmentAccess segment, GetResultBuilder builder, Map<UUID, Long> bucketOffsets, TimeoutTimer timer) {
        TableBucketReader<TableEntry> bucketReader = TableBucketReader.entry(segment, this.keyIndex::getBackpointerOffset, this.executor);
        int resultSize = builder.getHashes().size();
        for (int i = 0; i < resultSize; ++i) {
            UUID keyHash = builder.getHashes().get(i);
            long offset = bucketOffsets.get(keyHash);
            if (offset == -1L) {
                builder.includeResult(CompletableFuture.completedFuture(null));
                continue;
            }
            BufferView key = builder.getKeys().get(i);
            builder.includeResult((CompletableFuture<TableEntry>)this.keyIndex.findBucketEntry(segment, bucketReader, key, offset, timer).thenApply(this::maybeDeleted));
        }
        return builder.getResultFutures();
    }

    @Override
    CompletableFuture<AsyncIterator<IteratorItem<TableKey>>> keyIterator(@NonNull DirectSegmentAccess segment, IteratorArgs args) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        SegmentMetadata segmentInfo = segment.getInfo();
        this.ensureSegmentType(segmentInfo.getName(), segmentInfo.getType());
        this.logRequest("keyIterator", segmentInfo.getName(), args);
        return this.newIterator(segment, args, TableBucketReader::key);
    }

    @Override
    CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryIterator(@NonNull DirectSegmentAccess segment, IteratorArgs args) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        SegmentMetadata segmentInfo = segment.getInfo();
        this.ensureSegmentType(segmentInfo.getName(), segmentInfo.getType());
        this.logRequest("entryIterator", segmentInfo.getName(), args);
        return this.newIterator(segment, args, TableBucketReader::entry);
    }

    @Override
    AsyncIterator<IteratorItem<TableEntry>> entryDeltaIterator(@NonNull DirectSegmentAccess segment, long fromPosition, Duration fetchTimeout) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        SegmentMetadata segmentInfo = segment.getInfo();
        this.ensureSegmentType(segmentInfo.getName(), segmentInfo.getType());
        Preconditions.checkArgument((fromPosition <= segmentInfo.getLength() ? 1 : 0) != 0, (String)"fromPosition (%s) can not exceed the length (%s) of the TableSegment.", (long)fromPosition, (long)segmentInfo.getLength());
        this.logRequest("entryDeltaIterator", segment.getSegmentId(), fromPosition);
        long compactionOffset = segmentInfo.getAttributes().getOrDefault(TableAttributes.COMPACTION_OFFSET, 0L);
        long startOffset = Math.max(fromPosition, compactionOffset);
        boolean shouldClear = fromPosition < compactionOffset;
        int maxBytesToRead = (int)(segmentInfo.getLength() - startOffset);
        TableEntryDeltaIterator.ConvertResult converter = item -> CompletableFuture.completedFuture(new TableSegmentLayout.IteratorItemImpl<TableEntry>((BufferView)((DeltaIteratorState)item.getKey()).serialize(), Collections.singletonList((TableEntry)item.getValue())));
        return TableEntryDeltaIterator.builder().segment(segment).entrySerializer(this.serializer).executor(this.executor).maxBytesToRead(maxBytesToRead).startOffset(startOffset).currentBatchOffset(fromPosition).fetchTimeout(fetchTimeout).resultConverter(converter).shouldClear(shouldClear).build();
    }

    @Override
    CompletableFuture<TableSegmentInfo> getInfo(@NonNull DirectSegmentAccess segment, Duration timeout) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        SegmentMetadata m = segment.getInfo();
        return CompletableFuture.completedFuture(TableSegmentInfo.builder().name(m.getName()).length(m.getLength()).startOffset(m.getStartOffset()).type(m.getType()).entryCount(this.keyIndex.getUniqueEntryCount(m)).keyLength(0).build());
    }

    private <T> CompletableFuture<AsyncIterator<IteratorItem<T>>> newIterator(@NonNull DirectSegmentAccess segment, @NonNull IteratorArgs args, @NonNull GetBucketReader<T> createBucketReader) {
        UUID fromHash;
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (createBucketReader == null) {
            throw new NullPointerException("createBucketReader is marked non-null but is null");
        }
        Preconditions.checkArgument((args.getFrom() == null && args.getTo() == null ? 1 : 0) != 0, (Object)"Range Iterators not supported for HashTableSegments.");
        BufferView serializedState = args.getContinuationToken();
        try {
            fromHash = KeyHasher.getNextHash(serializedState == null ? null : IteratorStateImpl.deserialize(serializedState).getKeyHash());
        }
        catch (IOException ex) {
            throw new IllegalDataFormatException("Unable to deserialize `serializedState`.", (Throwable)ex);
        }
        if (fromHash == null) {
            return CompletableFuture.completedFuture(TableIterator.empty());
        }
        TableBucketReader bucketReader = createBucketReader.apply(segment, this.keyIndex::getBackpointerOffset, this.executor);
        TableIterator.ConvertResult converter = bucket -> bucketReader.findAllExisting(bucket.getSegmentOffset(), new TimeoutTimer(args.getFetchTimeout())).thenApply(result -> new TableSegmentLayout.IteratorItemImpl((BufferView)new IteratorStateImpl(bucket.getHash()).serialize(), result));
        return this.keyIndex.getUnindexedKeyHashes(segment).thenComposeAsync(cacheHashes -> TableIterator.builder().segment(segment).cacheHashes((Map<UUID, CacheBucketOffset>)cacheHashes).firstHash(fromHash).executor(this.executor).resultConverter(converter).fetchTimeout(args.getFetchTimeout()).build(), (Executor)this.executor);
    }

    private <T> TableKeyBatch batch(Collection<T> toBatch, Function<T, TableKey> getKey, Function<T, Integer> getLength, TableKeyBatch batch) {
        for (T item : toBatch) {
            Integer length = getLength.apply(item);
            TableKey key = getKey.apply(item);
            batch.add(key, this.hasher.hash(key.getKey()), length);
        }
        if (batch.getLength() > this.config.getMaxBatchSize()) {
            throw new TableSegmentLayout.UpdateBatchTooLargeException(batch.getLength(), this.config.getMaxBatchSize());
        }
        return batch;
    }

    private <T> CompletableFuture<Long> commit(Collection<T> toCommit, Function<Collection<T>, BufferView> serializer, DirectSegmentAccess segment, long tableSegmentOffset, Duration timeout) {
        BufferView s = serializer.apply(toCommit);
        if (tableSegmentOffset == -1L) {
            return segment.append(s, null, timeout);
        }
        return segment.append(s, null, tableSegmentOffset, timeout);
    }

    private void ensureSegmentType(String segmentName, SegmentType segmentType) {
        Preconditions.checkArgument((segmentType.isTableSegment() && !segmentType.isFixedKeyLengthTableSegment() ? 1 : 0) != 0, (String)"HashTableSegment can only be used for variable-key Table Segments; Segment '%s' is '%s;.", (Object)segmentName, (Object)segmentType);
    }

    public static class IteratorStateImpl
    implements IteratorState {
        private static final Serializer SERIALIZER = new Serializer();
        @NonNull
        private final UUID keyHash;

        IteratorStateImpl(@NonNull UUID keyHash) {
            if (keyHash == null) {
                throw new NullPointerException("keyHash is marked non-null but is null");
            }
            Preconditions.checkArgument((boolean)KeyHasher.isValid(keyHash), (Object)"keyHash must be at least IteratorState.MIN_HASH and at most IteratorState.MAX_HASH.");
            this.keyHash = keyHash;
        }

        public String toString() {
            return String.format("Hash = %s", this.keyHash);
        }

        static IteratorStateImpl deserialize(BufferView data) throws IOException {
            return (IteratorStateImpl)SERIALIZER.deserialize(data);
        }

        public ArrayView serialize() {
            return SERIALIZER.serialize(this);
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getKeyHash() {
            return this.keyHash;
        }

        private static class Serializer
        extends VersionedSerializer.WithBuilder<IteratorStateImpl, IteratorStateBuilder> {
            private Serializer() {
            }

            protected IteratorStateBuilder newBuilder() {
                return new IteratorStateBuilder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput revisionDataInput, IteratorStateBuilder builder) throws IOException {
                builder.keyHash = revisionDataInput.readUUID();
            }

            private void write00(IteratorStateImpl state, RevisionDataOutput revisionDataOutput) throws IOException {
                revisionDataOutput.length(16);
                revisionDataOutput.writeUUID(state.keyHash);
            }
        }

        private static class IteratorStateBuilder
        implements ObjectBuilder<IteratorStateImpl> {
            private UUID keyHash;

            private IteratorStateBuilder() {
            }

            public IteratorStateImpl build() {
                return new IteratorStateImpl(this.keyHash);
            }
        }
    }

    @FunctionalInterface
    private static interface GetBucketReader<T> {
        public TableBucketReader<T> apply(DirectSegmentAccess var1, TableBucketReader.GetBackpointer var2, ScheduledExecutorService var3);
    }

    private static class GetResultBuilder {
        private final List<BufferView> keys;
        private final List<UUID> hashes;
        private final List<CompletableFuture<TableEntry>> resultFutures;

        GetResultBuilder(List<BufferView> keys, KeyHasher hasher) {
            this.keys = keys;
            this.hashes = keys.stream().map(hasher::hash).collect(Collectors.toList());
            this.resultFutures = new ArrayList<CompletableFuture<TableEntry>>();
        }

        void includeResult(CompletableFuture<TableEntry> entryFuture) {
            this.resultFutures.add(entryFuture);
        }

        CompletableFuture<List<TableEntry>> getResultFutures() {
            return Futures.allOfWithResults(this.resultFutures);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<BufferView> getKeys() {
            return this.keys;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<UUID> getHashes() {
            return this.hashes;
        }
    }

    private class TableWriterConnectorImpl
    implements TableWriterConnector {
        private final SegmentMetadata metadata;

        @Override
        public EntrySerializer getSerializer() {
            return HashTableSegmentLayout.this.serializer;
        }

        @Override
        public KeyHasher getKeyHasher() {
            return HashTableSegmentLayout.this.hasher;
        }

        @Override
        public CompletableFuture<DirectSegmentAccess> getSegment(Duration timeout) {
            return HashTableSegmentLayout.this.connector.getSegment(this.metadata.getName(), OperationPriority.Critical, timeout);
        }

        @Override
        public void notifyIndexOffsetChanged(long lastIndexedOffset, int processedSizeBytes) {
            HashTableSegmentLayout.this.keyIndex.notifyIndexOffsetChanged(this.metadata.getId(), lastIndexedOffset, processedSizeBytes);
        }

        @Override
        public int getMaxCompactionSize() {
            return HashTableSegmentLayout.this.config.getMaxCompactionSize();
        }

        @Override
        public void close() {
            HashTableSegmentLayout.this.keyIndex.notifyIndexOffsetChanged(this.metadata.getId(), -1L, 0);
        }

        @ConstructorProperties(value={"metadata"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableWriterConnectorImpl(SegmentMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadata getMetadata() {
            return this.metadata;
        }
    }
}

