/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.tables.TableBucket;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

class IndexReader {
    @NonNull
    protected final ScheduledExecutorService executor;

    static long getLastIndexedOffset(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.INDEX_OFFSET, 0L);
    }

    static long getEntryCount(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.ENTRY_COUNT, 0L);
    }

    static long getTotalEntryCount(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.TOTAL_ENTRY_COUNT, 0L);
    }

    static long getBucketCount(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.BUCKET_COUNT, 0L);
    }

    static long getCompactionOffset(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.COMPACTION_OFFSET, 0L);
    }

    static long getCompactionUtilizationThreshold(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.MIN_UTILIZATION, 0L);
    }

    CompletableFuture<Map<UUID, TableBucket>> locateBuckets(DirectSegmentAccess segment, Collection<UUID> keyHashes, TimeoutTimer timer) {
        List<AttributeId> attributeIds = keyHashes.stream().map(AttributeId::fromUUID).collect(Collectors.toList());
        return segment.getAttributes(attributeIds, false, timer.getRemaining()).thenApply(attributes -> attributes.entrySet().stream().map(e -> new TableBucket(((AttributeId.UUID)e.getKey()).toUUID(), (Long)e.getValue())).collect(Collectors.toMap(TableBucket::getHash, b -> b)));
    }

    CompletableFuture<Long> getBackpointerOffset(DirectSegmentAccess segment, long offset, Duration timeout) {
        AttributeId key = this.getBackpointerAttributeKey(offset);
        return segment.getAttributes(Collections.singleton(key), false, timeout).thenApply(attributes -> {
            long result = attributes.getOrDefault(key, Long.MIN_VALUE);
            return result == Long.MIN_VALUE ? -1L : result;
        });
    }

    @VisibleForTesting
    CompletableFuture<List<Long>> getBucketOffsets(DirectSegmentAccess segment, TableBucket bucket, TimeoutTimer timer) {
        ArrayList result = new ArrayList();
        AtomicLong offset = new AtomicLong(bucket.getSegmentOffset());
        return Futures.loop(() -> offset.get() >= 0L, () -> {
            result.add(offset.get());
            return this.getBackpointerOffset(segment, offset.get(), timer.getRemaining());
        }, offset::set, (Executor)this.executor).thenApply(v -> result);
    }

    protected AttributeId getBackpointerAttributeKey(long offset) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be a non-negative number.");
        return AttributeId.uuid((long)Long.MAX_VALUE, (long)offset);
    }

    @VisibleForTesting
    static boolean isBackpointerAttributeKey(AttributeId key) {
        return key.getBitGroup(0) == Long.MAX_VALUE;
    }

    @ConstructorProperties(value={"executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IndexReader(@NonNull ScheduledExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.executor = executor;
    }
}

