/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.tables.BucketUpdate;
import io.pravega.segmentstore.server.tables.IndexReader;
import io.pravega.segmentstore.server.tables.KeyHasher;
import io.pravega.segmentstore.server.tables.TableBucket;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexWriter
extends IndexReader {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexWriter.class);
    private final KeyHasher hasher;

    IndexWriter(@NonNull KeyHasher keyHasher, ScheduledExecutorService executor) {
        super(executor);
        if (keyHasher == null) {
            throw new NullPointerException("keyHasher is marked non-null but is null");
        }
        this.hasher = keyHasher;
    }

    CompletableFuture<Collection<BucketUpdate.Builder>> groupByBucket(DirectSegmentAccess segment, Collection<BucketUpdate.KeyUpdate> keyUpdates, TimeoutTimer timer) {
        Map<UUID, List<BucketUpdate.KeyUpdate>> updatesByHash = keyUpdates.stream().collect(Collectors.groupingBy(k -> this.hasher.hash(k.getKey())));
        return this.locateBuckets(segment, updatesByHash.keySet(), timer).thenApplyAsync(buckets -> {
            HashMap result = new HashMap();
            buckets.forEach((keyHash, bucket) -> {
                BucketUpdate.Builder bu = result.computeIfAbsent(bucket, BucketUpdate::forBucket);
                ((List)updatesByHash.get(keyHash)).forEach(bu::withKeyUpdate);
            });
            return result.values();
        }, (Executor)this.executor);
    }

    CompletableFuture<Integer> updateBuckets(DirectSegmentAccess segment, Collection<BucketUpdate> bucketUpdates, long firstIndexedOffset, long lastIndexedOffset, int processedCount, Duration timeout) {
        UpdateInstructions update = new UpdateInstructions();
        for (BucketUpdate bucketUpdate : bucketUpdates) {
            this.generateAttributeUpdates(bucketUpdate, update);
        }
        if (lastIndexedOffset > firstIndexedOffset) {
            this.generateTableAttributeUpdates(firstIndexedOffset, lastIndexedOffset, processedCount, update);
        }
        if (update.getAttributes().isEmpty()) {
            log.debug("IndexWriter[{}]: FirstIdxOffset={}, LastIdxOffset={}, No Changes.", new Object[]{segment.getSegmentId(), firstIndexedOffset, lastIndexedOffset});
            return CompletableFuture.completedFuture(0);
        }
        log.debug("IndexWriter[{}]: FirstIdxOffset={}, LastIdxOffset={}, AttrUpdates={}, Processed={}, Entries+={}, Buckets+={}.", new Object[]{segment.getSegmentId(), firstIndexedOffset, lastIndexedOffset, update.getAttributes().size(), processedCount, update.getEntryCountDelta(), update.getBucketCountDelta()});
        return segment.updateAttributes(update.getAttributes(), timeout).thenApply(v -> update.getAttributes().size());
    }

    private void generateAttributeUpdates(BucketUpdate bucketUpdate, UpdateInstructions update) {
        if (!bucketUpdate.hasUpdates()) {
            return;
        }
        TableBucket bucket = bucketUpdate.getBucket();
        Preconditions.checkArgument((bucket.exists() != bucketUpdate.getExistingKeys().isEmpty() ? 1 : 0) != 0, (Object)"Non-existing buckets must have no existing keys, while non-index Buckets must have at least one.");
        this.generateBackpointerUpdates(bucketUpdate, update);
        long bucketOffset = bucketUpdate.getBucketOffset();
        if (bucketOffset >= 0L) {
            this.generateBucketUpdate(bucket, bucketOffset, update);
        } else {
            this.generateBucketDelete(bucket, update);
        }
    }

    private void generateBucketUpdate(TableBucket bucket, long bucketOffset, UpdateInstructions update) {
        assert (bucketOffset >= 0L);
        update.withAttribute(new AttributeUpdate(AttributeId.fromUUID((UUID)bucket.getHash()), AttributeUpdateType.Replace, bucketOffset));
        if (!bucket.exists()) {
            update.bucketAdded();
        }
    }

    private void generateBucketDelete(TableBucket bucket, UpdateInstructions update) {
        if (bucket.exists()) {
            update.withAttribute(new AttributeUpdate(AttributeId.fromUUID((UUID)bucket.getHash()), AttributeUpdateType.Replace, Long.MIN_VALUE));
            update.bucketRemoved();
        }
    }

    private void generateTableAttributeUpdates(long currentOffset, long newOffset, int processedCount, UpdateInstructions update) {
        Preconditions.checkArgument((currentOffset <= newOffset ? 1 : 0) != 0, (Object)"newOffset must be larger than existingOffset");
        update.withAttribute(new AttributeUpdate(TableAttributes.INDEX_OFFSET, AttributeUpdateType.ReplaceIfEquals, newOffset, currentOffset));
        if (update.getEntryCountDelta() != 0) {
            update.withAttribute(new AttributeUpdate(TableAttributes.ENTRY_COUNT, AttributeUpdateType.Accumulate, (long)update.getEntryCountDelta()));
        }
        if (update.getBucketCountDelta() != 0) {
            update.withAttribute(new AttributeUpdate(TableAttributes.BUCKET_COUNT, AttributeUpdateType.Accumulate, (long)update.getBucketCountDelta()));
        }
        if (processedCount > 0) {
            update.withAttribute(new AttributeUpdate(TableAttributes.TOTAL_ENTRY_COUNT, AttributeUpdateType.Accumulate, (long)processedCount));
        }
    }

    private void generateBackpointerUpdates(BucketUpdate update, UpdateInstructions updateInstructions) {
        AtomicLong previousOffset = new AtomicLong(Long.MIN_VALUE);
        AtomicBoolean previousReplaced = new AtomicBoolean(false);
        AtomicBoolean first = new AtomicBoolean(true);
        update.getExistingKeys().stream().sorted(Comparator.comparingLong(BucketUpdate.KeyInfo::getOffset)).forEach(keyInfo -> {
            boolean replaced = update.isKeyUpdated(keyInfo.getKey());
            if (replaced) {
                if (!first.get()) {
                    updateInstructions.withAttribute(this.generateBackpointerRemoval(keyInfo.getOffset()));
                }
                updateInstructions.entryRemoved();
                previousReplaced.set(true);
            } else {
                if (previousReplaced.get()) {
                    updateInstructions.withAttribute(this.generateBackpointerUpdate(keyInfo.getOffset(), previousOffset.get()));
                    previousReplaced.set(false);
                }
                previousOffset.set(keyInfo.getOffset());
            }
            first.set(false);
        });
        update.getKeyUpdates().stream().filter(keyUpdate -> !keyUpdate.isDeleted()).sorted(Comparator.comparingLong(BucketUpdate.KeyInfo::getOffset)).forEach(keyUpdate -> {
            if (previousOffset.get() != Long.MIN_VALUE) {
                updateInstructions.withAttribute(this.generateBackpointerUpdate(keyUpdate.getOffset(), previousOffset.get()));
            }
            updateInstructions.entryAdded();
            previousOffset.set(keyUpdate.getOffset());
        });
    }

    private AttributeUpdate generateBackpointerUpdate(long fromOffset, long toOffset) {
        return new AttributeUpdate(this.getBackpointerAttributeKey(fromOffset), AttributeUpdateType.Replace, toOffset);
    }

    private AttributeUpdate generateBackpointerRemoval(long fromOffset) {
        return new AttributeUpdate(this.getBackpointerAttributeKey(fromOffset), AttributeUpdateType.Replace, Long.MIN_VALUE);
    }

    private static class UpdateInstructions {
        private final AttributeUpdateCollection attributes = new AttributeUpdateCollection();
        private int bucketCountDelta = 0;
        private int entryCountDelta = 0;

        private UpdateInstructions() {
        }

        void withAttribute(AttributeUpdate au) {
            this.attributes.add(au);
        }

        void bucketAdded() {
            ++this.bucketCountDelta;
        }

        void bucketRemoved() {
            --this.bucketCountDelta;
        }

        void entryAdded() {
            ++this.entryCountDelta;
        }

        void entryRemoved() {
            --this.entryCountDelta;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AttributeUpdateCollection getAttributes() {
            return this.attributes;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getBucketCountDelta() {
            return this.bucketCountDelta;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getEntryCountDelta() {
            return this.entryCountDelta;
        }
    }
}

