/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.hash.HashHelper;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.tables.CacheBucketOffset;
import io.pravega.segmentstore.server.tables.TableKeyBatch;
import io.pravega.segmentstore.storage.cache.CacheStorage;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class SegmentKeyCache {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentKeyCache.class);
    private static final int HASH_GROUP_COUNT = 1024;
    private static final HashHelper HASH = HashHelper.seededWith((String)SegmentKeyCache.class.getName());
    private static final int VALUE_SERIALIZATION_LENGTH = 8;
    private final long segmentId;
    private final CacheStorage cacheStorage;
    private volatile boolean essentialCacheOnly;
    @GuardedBy(value="this")
    private long lastIndexedOffset;
    @GuardedBy(value="this")
    private final HashMap<Long, Long> backpointers = new HashMap();
    @GuardedBy(value="this")
    private final HashMap<Short, CacheEntry> cacheEntries = new HashMap();
    @GuardedBy(value="this")
    private final HashMap<UUID, CacheBucketOffset> tailOffsets = new HashMap();

    synchronized CacheManager.CacheStatus getCacheStatus() {
        return CacheManager.CacheStatus.fromGenerations(this.cacheEntries.values().stream().filter(Objects::nonNull).map(CacheEntry::getGeneration).iterator());
    }

    synchronized List<CacheEntry> evictBefore(int oldestGeneration) {
        ArrayList<CacheEntry> removedEntries = new ArrayList<CacheEntry>();
        for (Map.Entry<Short, CacheEntry> e2 : this.cacheEntries.entrySet()) {
            CacheEntry entry = e2.getValue();
            if (entry.getGeneration() >= oldestGeneration || entry.getHighestOffset() >= this.lastIndexedOffset) continue;
            removedEntries.add(entry);
        }
        removedEntries.forEach(e -> this.cacheEntries.remove(e.hashGroup));
        return removedEntries;
    }

    synchronized List<CacheEntry> evictAll() {
        ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>(this.cacheEntries.values());
        this.cacheEntries.clear();
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Long> includeUpdateBatch(TableKeyBatch batch, long batchOffset, int generation) {
        ArrayList<Long> result = new ArrayList<Long>(batch.getItems().size());
        SegmentKeyCache segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            for (TableKeyBatch.Item item : batch.getItems()) {
                long itemOffset = batchOffset + (long)item.getOffset();
                CacheBucketOffset existingOffset = this.get(item.getHash(), generation);
                if (existingOffset == null || itemOffset > existingOffset.getSegmentOffset()) {
                    this.tailOffsets.put(item.getHash(), new CacheBucketOffset(itemOffset, batch.isRemoval()));
                    result.add(itemOffset);
                } else {
                    result.add(existingOffset.getSegmentOffset());
                }
                if (existingOffset == null) continue;
                this.backpointers.put(itemOffset, existingOffset.getSegmentOffset());
            }
        }
        return result;
    }

    synchronized void includeTailCache(Map<UUID, CacheBucketOffset> keyOffsets, int generation) {
        for (Map.Entry<UUID, CacheBucketOffset> e : keyOffsets.entrySet()) {
            CacheBucketOffset offset = e.getValue();
            CacheBucketOffset existingOffset = this.get(e.getKey(), generation);
            if (existingOffset != null && offset.getSegmentOffset() <= existingOffset.getSegmentOffset()) continue;
            this.tailOffsets.put(e.getKey(), offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long includeExistingKey(UUID keyHash, long segmentOffset, int generation) {
        CacheEntry entry;
        Preconditions.checkArgument((segmentOffset >= 0L ? 1 : 0) != 0, (Object)"segmentOffset must be non-negative.");
        short hashGroup = this.getHashGroup(keyHash);
        SegmentKeyCache segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            CacheBucketOffset tailOffset = this.tailOffsets.get(keyHash);
            if (tailOffset != null && tailOffset.getSegmentOffset() >= segmentOffset) {
                return tailOffset.getSegmentOffset();
            }
            entry = this.cacheEntries.computeIfAbsent(hashGroup, hg -> new CacheEntry(hashGroup, generation));
        }
        if (!entry.update(keyHash, segmentOffset, generation)) {
            this.evictEntry(entry);
        }
        return segmentOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictEntry(CacheEntry entry) {
        SegmentKeyCache segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            this.cacheEntries.remove(entry.hashGroup);
        }
        entry.evict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheBucketOffset get(UUID keyHash, int generation) {
        Long r;
        CacheEntry entry;
        SegmentKeyCache segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            CacheBucketOffset tailOffset = this.tailOffsets.get(keyHash);
            if (tailOffset != null) {
                return tailOffset;
            }
            entry = this.cacheEntries.get(this.getHashGroup(keyHash));
        }
        if (entry != null && (r = entry.get(keyHash, generation)) != null) {
            return CacheBucketOffset.decode(r);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastIndexedOffset(long currentLastIndexedOffset, int cacheGeneration) {
        ArrayList<MigrationCandidate> candidates = new ArrayList<MigrationCandidate>();
        SegmentKeyCache segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            Preconditions.checkArgument((currentLastIndexedOffset >= this.lastIndexedOffset ? 1 : 0) != 0, (String)"currentLastIndexedOffset (%s) must be at least the current value (%s).", (long)currentLastIndexedOffset, (long)this.lastIndexedOffset);
            this.lastIndexedOffset = currentLastIndexedOffset;
            this.backpointers.keySet().removeIf(sourceOffset -> sourceOffset < currentLastIndexedOffset);
            for (Map.Entry<UUID, CacheBucketOffset> tailHash : this.tailOffsets.entrySet()) {
                CacheBucketOffset offset = tailHash.getValue();
                if (offset.getSegmentOffset() >= currentLastIndexedOffset) continue;
                CacheEntry cacheEntry = this.cacheEntries.computeIfAbsent(this.getHashGroup(tailHash.getKey()), hg -> new CacheEntry((short)hg, cacheGeneration));
                candidates.add(new MigrationCandidate(tailHash.getKey(), cacheEntry, offset));
            }
        }
        candidates.forEach(mc -> this.commitMigrationCandidate((MigrationCandidate)mc, cacheGeneration));
        segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            candidates.forEach(c -> this.tailOffsets.remove(c.keyHash, c.offset));
        }
    }

    private void commitMigrationCandidate(MigrationCandidate mc, int cacheGeneration) {
        if (!mc.commit(cacheGeneration)) {
            this.evictEntry(mc.cacheEntry);
        }
    }

    synchronized long getLastIndexedOffset() {
        return this.lastIndexedOffset;
    }

    synchronized long getBackpointerOffset(long sourceOffset) {
        return this.backpointers.getOrDefault(sourceOffset, -1L);
    }

    synchronized Map<UUID, CacheBucketOffset> getTailBucketOffsets() {
        return new HashMap<UUID, CacheBucketOffset>(this.tailOffsets);
    }

    synchronized int getTailEntryCountDelta() {
        return this.tailOffsets.values().stream().mapToInt(o -> o.isRemoval() ? -1 : 1).sum();
    }

    public synchronized String toString() {
        return String.format("LIO = %s, Entries = %s, Backpointers = %s, BucketOffsets = %s.", this.lastIndexedOffset, this.cacheEntries.size(), this.backpointers.size(), this.tailOffsets.size());
    }

    private short getHashGroup(UUID keyHash) {
        return (short)HASH.hashToBucket(keyHash, 1024);
    }

    @ConstructorProperties(value={"segmentId", "cacheStorage"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentKeyCache(long segmentId, CacheStorage cacheStorage) {
        this.segmentId = segmentId;
        this.cacheStorage = cacheStorage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getSegmentId() {
        return this.segmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEssentialCacheOnly(boolean essentialCacheOnly) {
        this.essentialCacheOnly = essentialCacheOnly;
    }

    private static class CacheDisabledException
    extends IllegalStateException {
        CacheDisabledException() {
            super("Cache disabled for non-essential data.");
        }
    }

    private static class CacheEntryEvictedException
    extends IllegalStateException {
        CacheEntryEvictedException() {
            super("CacheEntry evicted.");
        }
    }

    class CacheEntry {
        private static final int HEADER_LENGTH = 4;
        private static final int HASH_LENGTH = 16;
        private static final int ENTRY_LENGTH = 28;
        private static final int INITIAL_ADDRESS = -1;
        private static final int EVICTED_ADDRESS = -2;
        private final short hashGroup;
        private volatile int generation;
        private volatile long highestOffset;
        @GuardedBy(value="this")
        private int cacheAddress;

        private CacheEntry(short hashGroup, int currentGeneration) {
            this.hashGroup = hashGroup;
            this.generation = currentGeneration;
            this.highestOffset = 0L;
            this.cacheAddress = -1;
        }

        int getGeneration() {
            return this.generation;
        }

        long getHighestOffset() {
            return this.highestOffset;
        }

        Long get(UUID keyHash, int currentGeneration) {
            ArrayView data = this.getFromCache();
            int offset = this.locate(keyHash, data);
            if (offset >= 0) {
                this.generation = currentGeneration;
                return data.getLong(offset);
            }
            return null;
        }

        synchronized boolean update(UUID keyHash, long segmentOffset, int currentGeneration) {
            ArrayView entryData = this.getFromCache();
            int entryOffset = this.locate(keyHash, entryData);
            if (entryOffset < 0) {
                if (entryData == null) {
                    entryData = new ByteArraySegment(new byte[28]);
                    entryOffset = 4;
                } else {
                    ByteArraySegment newData = new ByteArraySegment(new byte[entryData.getLength() + 16 + 8]);
                    newData.copyFrom(entryData, 0, entryData.getLength());
                    entryOffset = entryData.getLength();
                    entryData = newData;
                }
                entryData.setInt(0, entryData.getInt(0) + 1);
                this.serializeHash(entryData, entryOffset, keyHash);
                entryOffset += 16;
            }
            entryData.setLong(entryOffset, segmentOffset);
            try {
                this.storeInCache(entryData);
                this.generation = currentGeneration;
                this.highestOffset = Math.max(this.highestOffset, segmentOffset);
            }
            catch (CacheEntryEvictedException cex) {
                throw cex;
            }
            catch (CacheDisabledException cex) {
                log.debug("SegmentKeyCache[{}]: Not updating cache for {} due to non-essential cache entries disabled.", (Object)SegmentKeyCache.this.segmentId, (Object)this);
                return false;
            }
            catch (Throwable ex) {
                log.warn("SegmentKeyCache[{}]: Cache Entry update failed for {}.", new Object[]{SegmentKeyCache.this.segmentId, this, ex});
                return false;
            }
            return true;
        }

        synchronized boolean evict() {
            int address = this.cacheAddress;
            this.cacheAddress = -2;
            if (address >= 0) {
                SegmentKeyCache.this.cacheStorage.delete(address);
                return true;
            }
            return false;
        }

        private synchronized ArrayView getFromCache() {
            BufferView data = null;
            if (this.cacheAddress >= 0) {
                data = SegmentKeyCache.this.cacheStorage.get(this.cacheAddress);
            }
            return data == null ? null : new ByteArraySegment(data.getCopy());
        }

        @GuardedBy(value="this")
        private void storeInCache(ArrayView data) {
            if (this.cacheAddress == -2) {
                throw new CacheEntryEvictedException();
            }
            if (SegmentKeyCache.this.essentialCacheOnly) {
                if (this.cacheAddress >= 0) {
                    SegmentKeyCache.this.cacheStorage.delete(this.cacheAddress);
                    this.cacheAddress = -2;
                }
                throw new CacheDisabledException();
            }
            this.cacheAddress = this.cacheAddress >= 0 ? SegmentKeyCache.this.cacheStorage.replace(this.cacheAddress, (BufferView)data) : SegmentKeyCache.this.cacheStorage.insert((BufferView)data);
        }

        private int locate(UUID keyHash, ArrayView data) {
            if (data != null && data.getLength() > 0) {
                int count = data.getInt(0);
                int offset = 4;
                for (int i = 0; i < count; ++i) {
                    boolean match;
                    boolean bl = match = keyHash.getMostSignificantBits() == data.getLong(offset) && keyHash.getLeastSignificantBits() == data.getLong(offset + 8);
                    if (match) {
                        return offset + 16;
                    }
                    offset += 24;
                }
            }
            return -1;
        }

        private void serializeHash(ArrayView target, int targetOffset, UUID hash) {
            target.setLong(targetOffset, hash.getMostSignificantBits());
            target.setLong(targetOffset + 8, hash.getLeastSignificantBits());
        }

        public String toString() {
            return String.format("Key = %s", this.hashGroup);
        }
    }

    @VisibleForTesting
    static class MigrationCandidate {
        final UUID keyHash;
        final CacheEntry cacheEntry;
        final CacheBucketOffset offset;

        boolean commit(int cacheGeneration) {
            try {
                return this.cacheEntry.update(this.keyHash, this.offset.encode(), cacheGeneration);
            }
            catch (CacheEntryEvictedException ex) {
                return false;
            }
        }

        @ConstructorProperties(value={"keyHash", "cacheEntry", "offset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MigrationCandidate(UUID keyHash, CacheEntry cacheEntry, CacheBucketOffset offset) {
            this.keyHash = keyHash;
            this.cacheEntry = cacheEntry;
            this.offset = offset;
        }
    }
}

