/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.MathHelpers;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.Retry;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.reading.AsyncReadResultProcessor;
import io.pravega.segmentstore.server.tables.AsyncTableEntryReader;
import io.pravega.segmentstore.server.tables.EntrySerializer;
import io.pravega.segmentstore.server.tables.IndexReader;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TableCompactor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableCompactor.class);
    private static final EntrySerializer SERIALIZER = new EntrySerializer();
    protected final DirectSegmentAccess segment;
    protected final SegmentMetadata metadata;
    protected final Config config;
    protected final ScheduledExecutorService executor;
    protected final String traceLogId;

    TableCompactor(@NonNull DirectSegmentAccess segment, @NonNull Config config, @NonNull ScheduledExecutorService executor) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.segment = segment;
        this.config = config;
        this.executor = executor;
        this.metadata = segment.getInfo();
        this.traceLogId = String.format("TableCompactor[%s-%s]", this.metadata.getContainerId(), this.metadata.getId());
    }

    protected abstract long getLastIndexedOffset();

    protected abstract CompletableFuture<Long> getUniqueEntryCount();

    protected CompactionArgs newCompactionArgs(long startOffset) {
        return new CompactionArgs(startOffset);
    }

    CompletableFuture<Boolean> isCompactionRequired() {
        long startOffset = this.getCompactionStartOffset();
        long lastIndexOffset = this.getLastIndexedOffset();
        if (startOffset + (long)this.config.getMaxCompactionSize() >= lastIndexOffset) {
            return CompletableFuture.completedFuture(false);
        }
        long totalEntryCount = IndexReader.getTotalEntryCount(this.metadata);
        long utilizationThreshold = (int)MathHelpers.minMax((long)IndexReader.getCompactionUtilizationThreshold(this.metadata), (long)0L, (long)100L);
        return this.getUniqueEntryCount().thenApply(entryCount -> {
            long utilization = totalEntryCount == 0L ? 100L : MathHelpers.minMax((long)Math.round(100.0 * (double)entryCount.longValue() / (double)totalEntryCount), (long)0L, (long)100L);
            return utilization < utilizationThreshold;
        });
    }

    long calculateTruncationOffset(long highestCopiedOffset) {
        long truncateOffset = -1L;
        if (highestCopiedOffset > 0L) {
            truncateOffset = highestCopiedOffset;
        } else if (this.getLastIndexedOffset() >= this.metadata.getLength()) {
            truncateOffset = IndexReader.getCompactionOffset(this.metadata);
        }
        if (truncateOffset <= this.metadata.getStartOffset()) {
            truncateOffset = -1L;
        }
        return truncateOffset;
    }

    CompletableFuture<Void> compact(TimeoutTimer timer) {
        long startOffset = this.getCompactionStartOffset();
        int maxLength = (int)Math.min((long)this.config.getMaxCompactionSize(), this.getLastIndexedOffset() - startOffset);
        if (startOffset < 0L || maxLength < 0) {
            return Futures.failedFuture((Throwable)((Object)new DataCorruptionException(String.format("%s: '%s' has CompactionStartOffset=%s and CompactionLength=%s.", this.traceLogId, this.metadata.getName(), startOffset, maxLength), new Object[0])));
        }
        if (maxLength == 0) {
            log.debug("{}: Up to date.", (Object)this.traceLogId);
            return CompletableFuture.completedFuture(null);
        }
        return this.getRetryPolicy().runAsync(() -> this.readCandidates(startOffset, maxLength, timer).thenComposeAsync(candidates -> this.excludeObsolete((CompactionArgs)candidates, timer).thenComposeAsync(v -> this.copyCandidates((CompactionArgs)candidates, timer), (Executor)this.executor), (Executor)this.executor), this.executor);
    }

    private CompletableFuture<CompactionArgs> readCandidates(long startOffset, int maxLength, TimeoutTimer timer) {
        ReadResult rr = this.segment.read(startOffset, maxLength, timer.getRemaining());
        return AsyncReadResultProcessor.processAll(rr, this.executor, timer.getRemaining()).thenApply(inputData -> this.parseEntries((BufferView)inputData, startOffset, maxLength));
    }

    private CompactionArgs parseEntries(BufferView inputData, long startOffset, int maxLength) {
        CompactionArgs result = this.newCompactionArgs(startOffset);
        long maxOffset = startOffset + (long)maxLength;
        BufferView.Reader input = inputData.getBufferViewReader();
        try {
            while (result.getEndOffset() < maxOffset) {
                AsyncTableEntryReader.DeserializedEntry e = AsyncTableEntryReader.readEntryComponents(input, result.getEndOffset(), SERIALIZER);
                if (!e.getHeader().isDeletion()) {
                    result.add(new Candidate(result.getEndOffset(), TableEntry.versioned((BufferView)e.getKey(), (BufferView)e.getValue(), (long)e.getVersion())));
                }
                result.entryProcessed(e.getHeader().getTotalLength());
            }
        }
        catch (BufferView.Reader.OutOfBoundsException outOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    protected abstract CompletableFuture<Void> excludeObsolete(CompactionArgs var1, TimeoutTimer var2);

    private CompletableFuture<Void> copyCandidates(CompactionArgs args, TimeoutTimer timer) {
        CompletableFuture<Object> result;
        AttributeUpdateCollection attributes = this.generateAttributeUpdates(args);
        ArrayList<TableEntry> toWrite = new ArrayList<TableEntry>();
        AtomicInteger totalLength = new AtomicInteger(0);
        args.getAll().stream().sorted(Comparator.comparingLong(c -> c.entry.getKey().getVersion())).forEach(c -> {
            toWrite.add(c.entry);
            this.generateIndexUpdates((Candidate)c, totalLength.get(), attributes);
            totalLength.addAndGet(SERIALIZER.getUpdateLength(c.entry));
        });
        if (totalLength.get() == 0) {
            assert (toWrite.size() == 0);
            result = this.segment.updateAttributes(attributes, timer.getRemaining());
        } else {
            BufferView appendData = SERIALIZER.serializeUpdateWithExplicitVersion(toWrite);
            result = this.segment.append(appendData, attributes, timer.getRemaining());
            log.debug("{}: Compacting {}, CopyCount={}, CopyLength={}.", new Object[]{this.traceLogId, args, toWrite.size(), totalLength});
        }
        return Futures.toVoid(result);
    }

    private AttributeUpdateCollection generateAttributeUpdates(CompactionArgs candidates) {
        return AttributeUpdateCollection.from((AttributeUpdate[])new AttributeUpdate[]{new AttributeUpdate(TableAttributes.COMPACTION_OFFSET, AttributeUpdateType.ReplaceIfEquals, candidates.getEndOffset(), candidates.getStartOffset()), new AttributeUpdate(TableAttributes.TOTAL_ENTRY_COUNT, AttributeUpdateType.Accumulate, (long)this.calculateTotalEntryDelta(candidates))});
    }

    protected abstract int calculateTotalEntryDelta(CompactionArgs var1);

    protected void generateIndexUpdates(Candidate c, int batchOffset, AttributeUpdateCollection indexUpdates) {
    }

    protected Retry.RetryAndThrowBase<Exception> getRetryPolicy() {
        return Retry.NO_RETRY;
    }

    private long getCompactionStartOffset() {
        return Math.max(IndexReader.getCompactionOffset(this.metadata), this.metadata.getStartOffset());
    }

    static class Config {
        private final int maxCompactionSize;

        @ConstructorProperties(value={"maxCompactionSize"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Config(int maxCompactionSize) {
            this.maxCompactionSize = maxCompactionSize;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getMaxCompactionSize() {
            return this.maxCompactionSize;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getMaxCompactionSize() == other.getMaxCompactionSize();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxCompactionSize();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TableCompactor.Config(maxCompactionSize=" + this.getMaxCompactionSize() + ")";
        }
    }

    protected static class Candidate {
        final long segmentOffset;
        final TableEntry entry;

        public String toString() {
            return String.format("Offset = %d, Entry = {%s}", this.segmentOffset, this.entry);
        }

        @ConstructorProperties(value={"segmentOffset", "entry"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Candidate(long segmentOffset, TableEntry entry) {
            this.segmentOffset = segmentOffset;
            this.entry = entry;
        }
    }

    protected static class CompactionArgs {
        private final long startOffset;
        private long endOffset;
        private int count;
        private final Map<BufferView, Candidate> candidatesByKey = new HashMap<BufferView, Candidate>();

        CompactionArgs(long startOffset) {
            this.endOffset = this.startOffset = startOffset;
            this.count = 0;
        }

        void entryProcessed(int serializationLength) {
            this.endOffset += (long)serializationLength;
            ++this.count;
        }

        boolean add(Candidate c) {
            BufferView key = c.entry.getKey().getKey();
            Candidate existing = this.candidatesByKey.get(key);
            if (existing == null || existing.entry.getKey().getVersion() < c.entry.getKey().getVersion()) {
                this.candidatesByKey.put(key, c);
                return true;
            }
            return false;
        }

        void remove(Candidate candidate) {
            this.candidatesByKey.remove(candidate.entry.getKey().getKey());
        }

        void removeAll(Collection<Candidate> candidates) {
            candidates.forEach(this::remove);
        }

        void handleExistingKey(TableKey existingKey, long existingKeyOffset) {
            BufferView key = existingKey.getKey();
            Candidate c = this.candidatesByKey.get(key);
            if (c != null && c.segmentOffset < existingKeyOffset) {
                this.candidatesByKey.remove(key);
            }
        }

        Collection<Candidate> getAll() {
            return this.candidatesByKey.values();
        }

        int getCopyCandidateCount() {
            return this.candidatesByKey.size();
        }

        public String toString() {
            return String.format("StartOffset=%s, EndOffset=%s, ProcessedCount=%s, CandidateCount=%s", this.startOffset, this.endOffset, this.count, this.candidatesByKey.size());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getStartOffset() {
            return this.startOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getEndOffset() {
            return this.endOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getCount() {
            return this.count;
        }
    }
}

