/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.reading.AsyncReadResultProcessor;
import io.pravega.segmentstore.server.tables.AsyncTableEntryReader;
import io.pravega.segmentstore.server.tables.DeltaIteratorState;
import io.pravega.segmentstore.server.tables.EntrySerializer;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class TableEntryDeltaIterator<T>
implements AsyncIterator<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableEntryDeltaIterator.class);
    private static final int MAX_READ_SIZE = 0x200000;
    private final DirectSegmentAccess segment;
    private final long startOffset;
    private final int maxBytesToRead;
    private final boolean shouldClear;
    private final Duration fetchTimeout;
    private final EntrySerializer entrySerializer;
    private final ConvertResult<T> resultConverter;
    private final Executor executor;
    @GuardedBy(value="this")
    private Iterator<Map.Entry<DeltaIteratorState, TableEntry>> currentEntry;
    @GuardedBy(value="this")
    private long currentBatchOffset;

    public CompletableFuture<T> getNext() {
        return this.getNextEntry().thenCompose(entry -> {
            if (entry == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.resultConverter.apply((Map.Entry<DeltaIteratorState, TableEntry>)entry);
        });
    }

    public synchronized boolean endOfSegment() {
        return this.currentBatchOffset >= this.startOffset + (long)this.maxBytesToRead;
    }

    private synchronized CompletableFuture<Map.Entry<DeltaIteratorState, TableEntry>> getNextEntry() {
        Map.Entry<DeltaIteratorState, TableEntry> entry = this.getNextEntryFromBatch();
        if (entry != null) {
            return CompletableFuture.completedFuture(entry);
        }
        return this.fetchNextTableEntriesBatch().thenApply(val -> this.getNextEntryFromBatch());
    }

    private synchronized Map.Entry<DeltaIteratorState, TableEntry> getNextEntryFromBatch() {
        if (this.currentEntry != null) {
            Map.Entry<DeltaIteratorState, TableEntry> next = this.currentEntry.next();
            if (!this.currentEntry.hasNext()) {
                this.currentEntry = null;
            }
            return next;
        }
        return null;
    }

    private synchronized CompletableFuture<Void> fetchNextTableEntriesBatch() {
        return this.toEntries(this.currentBatchOffset).thenAccept(entries -> {
            this.currentEntry = !entries.isEmpty() ? entries.iterator() : null;
        });
    }

    private CompletableFuture<List<Map.Entry<DeltaIteratorState, TableEntry>>> toEntries(long startOffset) {
        TimeoutTimer timer = new TimeoutTimer(this.fetchTimeout);
        int length = Math.min(this.maxBytesToRead, 0x200000);
        if (this.endOfSegment()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ReadResult result = this.segment.read(startOffset, length, timer.getRemaining());
        return AsyncReadResultProcessor.processAll(result, this.executor, timer.getRemaining()).thenApply(data -> this.parseEntries((BufferView)data, startOffset, length));
    }

    private List<Map.Entry<DeltaIteratorState, TableEntry>> parseEntries(BufferView data, long startOffset, int readLength) {
        long currentOffset = startOffset;
        long maxOffset = startOffset + (long)readLength;
        BufferView.Reader input = data.getBufferViewReader();
        ArrayList<Map.Entry<DeltaIteratorState, TableEntry>> entries = new ArrayList<Map.Entry<DeltaIteratorState, TableEntry>>();
        try {
            while (currentOffset < maxOffset) {
                AsyncTableEntryReader.DeserializedEntry entry = AsyncTableEntryReader.readEntryComponents(input, currentOffset, this.entrySerializer);
                boolean reachedEnd = currentOffset + (long)entry.getHeader().getTotalLength() >= (long)this.maxBytesToRead + startOffset;
                BufferView value = entry.getValue() == null ? BufferView.empty() : entry.getValue();
                entries.add(new AbstractMap.SimpleEntry<DeltaIteratorState, TableEntry>(new DeltaIteratorState(currentOffset += (long)entry.getHeader().getTotalLength(), reachedEnd, this.shouldClear, entry.getHeader().isDeletion()), TableEntry.versioned((BufferView)entry.getKey(), (BufferView)value, (long)entry.getVersion())));
            }
        }
        catch (BufferView.Reader.OutOfBoundsException outOfBoundsException) {
            // empty catch block
        }
        this.currentBatchOffset = currentOffset;
        return entries;
    }

    static <T> TableEntryDeltaIterator<T> empty() {
        return new TableEntryDeltaIterator(null, 0L, 0, false, Duration.ofMillis(0L), new EntrySerializer(), ignored -> CompletableFuture.completedFuture(null), ForkJoinPool.commonPool(), null, 0L);
    }

    @ConstructorProperties(value={"segment", "startOffset", "maxBytesToRead", "shouldClear", "fetchTimeout", "entrySerializer", "resultConverter", "executor", "currentEntry", "currentBatchOffset"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    TableEntryDeltaIterator(DirectSegmentAccess segment, long startOffset, int maxBytesToRead, boolean shouldClear, Duration fetchTimeout, EntrySerializer entrySerializer, ConvertResult<T> resultConverter, Executor executor, Iterator<Map.Entry<DeltaIteratorState, TableEntry>> currentEntry, long currentBatchOffset) {
        this.segment = segment;
        this.startOffset = startOffset;
        this.maxBytesToRead = maxBytesToRead;
        this.shouldClear = shouldClear;
        this.fetchTimeout = fetchTimeout;
        this.entrySerializer = entrySerializer;
        this.resultConverter = resultConverter;
        this.executor = executor;
        this.currentEntry = currentEntry;
        this.currentBatchOffset = currentBatchOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static <T> TableEntryDeltaIteratorBuilder<T> builder() {
        return new TableEntryDeltaIteratorBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class TableEntryDeltaIteratorBuilder<T> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DirectSegmentAccess segment;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long startOffset;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxBytesToRead;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean shouldClear;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Duration fetchTimeout;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private EntrySerializer entrySerializer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ConvertResult<T> resultConverter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Executor executor;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Iterator<Map.Entry<DeltaIteratorState, TableEntry>> currentEntry;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long currentBatchOffset;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        TableEntryDeltaIteratorBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> segment(DirectSegmentAccess segment) {
            this.segment = segment;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> startOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> maxBytesToRead(int maxBytesToRead) {
            this.maxBytesToRead = maxBytesToRead;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> shouldClear(boolean shouldClear) {
            this.shouldClear = shouldClear;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> fetchTimeout(Duration fetchTimeout) {
            this.fetchTimeout = fetchTimeout;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> entrySerializer(EntrySerializer entrySerializer) {
            this.entrySerializer = entrySerializer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> resultConverter(ConvertResult<T> resultConverter) {
            this.resultConverter = resultConverter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> currentEntry(Iterator<Map.Entry<DeltaIteratorState, TableEntry>> currentEntry) {
            this.currentEntry = currentEntry;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIteratorBuilder<T> currentBatchOffset(long currentBatchOffset) {
            this.currentBatchOffset = currentBatchOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntryDeltaIterator<T> build() {
            return new TableEntryDeltaIterator<T>(this.segment, this.startOffset, this.maxBytesToRead, this.shouldClear, this.fetchTimeout, this.entrySerializer, this.resultConverter, this.executor, this.currentEntry, this.currentBatchOffset);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TableEntryDeltaIterator.TableEntryDeltaIteratorBuilder(segment=" + this.segment + ", startOffset=" + this.startOffset + ", maxBytesToRead=" + this.maxBytesToRead + ", shouldClear=" + this.shouldClear + ", fetchTimeout=" + this.fetchTimeout + ", entrySerializer=" + this.entrySerializer + ", resultConverter=" + this.resultConverter + ", executor=" + this.executor + ", currentEntry=" + this.currentEntry + ", currentBatchOffset=" + this.currentBatchOffset + ")";
        }
    }

    @FunctionalInterface
    static interface ConvertResult<T> {
        public CompletableFuture<T> apply(Map.Entry<DeltaIteratorState, TableEntry> var1);
    }
}

