/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import lombok.Generated;

public class TableExtensionConfig {
    public static final Property<Long> MAX_TAIL_CACHE_PREINDEX_LENGTH = Property.named((String)"preindex.bytes.max", (Object)0x8000000L);
    public static final Property<Integer> MAX_TAIL_CACHE_PREINDEX_BATCH_SIZE = Property.named((String)"preindex.batch.bytes.max", (Object)0x8000000);
    public static final Property<Integer> RECOVERY_TIMEOUT = Property.named((String)"recovery.timeout.millis", (Object)60000);
    public static final Property<Integer> MAX_UNINDEXED_LENGTH = Property.named((String)"unindexed.bytes.max", (Object)0x8000000);
    public static final Property<Integer> MAX_COMPACTION_SIZE = Property.named((String)"compaction.bytes.max", (Object)0x400000);
    public static final Property<Integer> COMPACTION_FREQUENCY = Property.named((String)"compaction.frequency.millis", (Object)30000);
    public static final Property<Integer> DEFAULT_MIN_UTILIZATION = Property.named((String)"utilization.min", (Object)75);
    public static final Property<Long> DEFAULT_ROLLOVER_SIZE = Property.named((String)"rollover.size.bytes", (Object)0x1000000L);
    public static final Property<Integer> MAX_BATCH_SIZE = Property.named((String)"batch.size.bytes", (Object)0x2000000);
    private static final String COMPONENT_CODE = "tables";
    private final long maxTailCachePreIndexLength;
    private final int maxTailCachePreIndexBatchLength;
    private final int maxUnindexedLength;
    private final int maxCompactionSize;
    private final Duration compactionFrequency;
    private final long defaultMinUtilization;
    private final long defaultRolloverSize;
    @VisibleForTesting
    private final int maxBatchSize;
    private final Duration recoveryTimeout;

    private TableExtensionConfig(TypedProperties properties) throws ConfigurationException {
        this.maxTailCachePreIndexLength = properties.getPositiveLong(MAX_TAIL_CACHE_PREINDEX_LENGTH);
        this.maxTailCachePreIndexBatchLength = properties.getPositiveInt(MAX_TAIL_CACHE_PREINDEX_BATCH_SIZE);
        this.maxUnindexedLength = properties.getPositiveInt(MAX_UNINDEXED_LENGTH);
        this.maxCompactionSize = properties.getPositiveInt(MAX_COMPACTION_SIZE);
        this.compactionFrequency = properties.getDuration(COMPACTION_FREQUENCY, (TemporalUnit)ChronoUnit.MILLIS);
        this.defaultMinUtilization = properties.getNonNegativeInt(DEFAULT_MIN_UTILIZATION);
        if (this.defaultMinUtilization > 100L) {
            throw new ConfigurationException(String.format("Property '%s' must be a value within [0, 100].", DEFAULT_MIN_UTILIZATION));
        }
        this.defaultRolloverSize = properties.getPositiveLong(DEFAULT_ROLLOVER_SIZE);
        this.maxBatchSize = properties.getPositiveInt(MAX_BATCH_SIZE);
        if (this.maxBatchSize > 0x2000000) {
            throw new ConfigurationException(String.format("Property '%s' must be a value within [0, %s].", DEFAULT_MIN_UTILIZATION, 0x2000000));
        }
        this.recoveryTimeout = properties.getDuration(RECOVERY_TIMEOUT, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public static ConfigBuilder<TableExtensionConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, TableExtensionConfig::new);
    }

    public Map<AttributeId, Long> getDefaultCompactionAttributes() {
        return ImmutableMap.of((Object)TableAttributes.MIN_UTILIZATION, (Object)this.getDefaultMinUtilization(), (Object)Attributes.ROLLOVER_SIZE, (Object)this.getDefaultRolloverSize());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMaxTailCachePreIndexLength() {
        return this.maxTailCachePreIndexLength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxTailCachePreIndexBatchLength() {
        return this.maxTailCachePreIndexBatchLength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxUnindexedLength() {
        return this.maxUnindexedLength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxCompactionSize() {
        return this.maxCompactionSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getCompactionFrequency() {
        return this.compactionFrequency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getDefaultMinUtilization() {
        return this.defaultMinUtilization;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getDefaultRolloverSize() {
        return this.defaultRolloverSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getRecoveryTimeout() {
        return this.recoveryTimeout;
    }
}

