/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.tables.IteratorArgs;
import io.pravega.segmentstore.contracts.tables.IteratorItem;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableSegmentConfig;
import io.pravega.segmentstore.contracts.tables.TableSegmentInfo;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.logs.operations.OperationPriority;
import io.pravega.segmentstore.server.tables.EntrySerializer;
import io.pravega.segmentstore.server.tables.TableExtensionConfig;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TableSegmentLayout
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableSegmentLayout.class);
    protected static final long NO_OFFSET = -1L;
    protected final Connector connector;
    protected final ScheduledExecutorService executor;
    protected final EntrySerializer serializer;
    protected final TableExtensionConfig config;
    protected final String traceObjectId;

    protected TableSegmentLayout(@NonNull Connector connector, @NonNull TableExtensionConfig config, @NonNull ScheduledExecutorService executor) {
        if (connector == null) {
            throw new NullPointerException("connector is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.connector = connector;
        this.config = config;
        this.executor = executor;
        this.serializer = new EntrySerializer();
        this.traceObjectId = String.format("TableExtension[%s]", connector.getContainerId());
    }

    @Override
    public abstract void close();

    abstract Collection<WriterSegmentProcessor> createWriterSegmentProcessors(UpdateableSegmentMetadata var1);

    abstract Map<AttributeId, Long> getNewSegmentAttributes(@NonNull TableSegmentConfig var1);

    abstract CompletableFuture<Void> deleteSegment(@NonNull String var1, boolean var2, Duration var3);

    abstract CompletableFuture<List<Long>> put(@NonNull DirectSegmentAccess var1, @NonNull List<TableEntry> var2, long var3, TimeoutTimer var5);

    abstract CompletableFuture<Void> remove(@NonNull DirectSegmentAccess var1, @NonNull Collection<TableKey> var2, long var3, TimeoutTimer var5);

    abstract CompletableFuture<List<TableEntry>> get(@NonNull DirectSegmentAccess var1, @NonNull List<BufferView> var2, TimeoutTimer var3);

    abstract CompletableFuture<AsyncIterator<IteratorItem<TableKey>>> keyIterator(@NonNull DirectSegmentAccess var1, IteratorArgs var2);

    abstract CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryIterator(@NonNull DirectSegmentAccess var1, IteratorArgs var2);

    abstract AsyncIterator<IteratorItem<TableEntry>> entryDeltaIterator(@NonNull DirectSegmentAccess var1, long var2, Duration var4);

    abstract CompletableFuture<TableSegmentInfo> getInfo(@NonNull DirectSegmentAccess var1, Duration var2);

    protected TableEntry maybeDeleted(TableEntry e) {
        return e == null || e.getValue() == null ? null : e;
    }

    protected void logRequest(String requestName, Object ... args) {
        log.debug("{}: {} {}", new Object[]{this.traceObjectId, requestName, args});
    }

    public static class UpdateBatchTooLargeException
    extends IllegalArgumentException {
        UpdateBatchTooLargeException(int length, int maxLength) {
            super(String.format("Update Batch length %s exceeds the maximum limit %s.", length, maxLength));
        }
    }

    public static final class Connector {
        private final int containerId;
        @NonNull
        private final GetSegment getSegment;
        @NonNull
        private final BiFunction<String, Duration, CompletableFuture<Void>> deleteSegment;

        protected CompletableFuture<DirectSegmentAccess> getSegment(String name, Duration timeout) {
            return this.getSegment(name, OperationPriority.Normal, timeout);
        }

        protected CompletableFuture<DirectSegmentAccess> getSegment(String name, OperationPriority priority, Duration timeout) {
            return this.getSegment.apply(name, priority, timeout);
        }

        protected CompletableFuture<Void> deleteSegment(String name, Duration timeout) {
            return this.deleteSegment.apply(name, timeout);
        }

        @ConstructorProperties(value={"containerId", "getSegment", "deleteSegment"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Connector(int containerId, @NonNull GetSegment getSegment, @NonNull BiFunction<String, Duration, CompletableFuture<Void>> deleteSegment) {
            if (getSegment == null) {
                throw new NullPointerException("getSegment is marked non-null but is null");
            }
            if (deleteSegment == null) {
                throw new NullPointerException("deleteSegment is marked non-null but is null");
            }
            this.containerId = containerId;
            this.getSegment = getSegment;
            this.deleteSegment = deleteSegment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getContainerId() {
            return this.containerId;
        }

        @FunctionalInterface
        public static interface GetSegment {
            public CompletableFuture<DirectSegmentAccess> apply(String var1, OperationPriority var2, Duration var3);
        }
    }

    protected static class IteratorItemImpl<T>
    implements IteratorItem<T> {
        private final BufferView state;
        private final Collection<T> entries;

        @ConstructorProperties(value={"state", "entries"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public IteratorItemImpl(BufferView state, Collection<T> entries) {
            this.state = state;
            this.entries = entries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BufferView getState() {
            return this.state;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Collection<T> getEntries() {
            return this.entries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IteratorItemImpl)) {
                return false;
            }
            IteratorItemImpl other = (IteratorItemImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BufferView this$state = this.getState();
            BufferView other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            Collection<T> this$entries = this.getEntries();
            Collection<T> other$entries = other.getEntries();
            return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IteratorItemImpl;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BufferView $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            Collection<T> $entries = this.getEntries();
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TableSegmentLayout.IteratorItemImpl(state=" + this.getState() + ", entries=" + this.getEntries() + ")";
        }
    }
}

