/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.Beta;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.tables.IteratorArgs;
import io.pravega.segmentstore.contracts.tables.IteratorItem;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableSegmentConfig;
import io.pravega.segmentstore.contracts.tables.TableSegmentInfo;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import io.pravega.segmentstore.server.store.SegmentContainerCollection;
import io.pravega.segmentstore.server.tables.ContainerTableExtension;
import io.pravega.shared.segment.SegmentToContainerMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@Beta
public class TableService
extends SegmentContainerCollection
implements TableStore {
    public TableService(SegmentContainerRegistry segmentContainerRegistry, SegmentToContainerMapper segmentToContainerMapper) {
        super(segmentContainerRegistry, segmentToContainerMapper);
    }

    public CompletableFuture<Void> createSegment(String segmentName, SegmentType segmentType, TableSegmentConfig config, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.createSegment(segmentName, segmentType, config, timeout), "createSegment", segmentName, segmentType, config);
    }

    public CompletableFuture<Void> deleteSegment(String segmentName, boolean mustBeEmpty, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.deleteSegment(segmentName, mustBeEmpty, timeout), "deleteSegment", segmentName, mustBeEmpty);
    }

    public CompletableFuture<List<Long>> put(String segmentName, List<TableEntry> entries, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.put(segmentName, entries, timeout), "put", segmentName, entries.size());
    }

    public CompletableFuture<List<Long>> put(String segmentName, List<TableEntry> entries, long tableSegmentOffset, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.put(segmentName, entries, tableSegmentOffset, timeout), "put", segmentName, entries.size());
    }

    public CompletableFuture<Void> remove(String segmentName, Collection<TableKey> keys, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.remove(segmentName, keys, timeout), "remove", segmentName, keys.size());
    }

    public CompletableFuture<Void> remove(String segmentName, Collection<TableKey> keys, long tableSegmentOffset, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.remove(segmentName, keys, tableSegmentOffset, timeout), "remove", segmentName, keys.size());
    }

    public CompletableFuture<List<TableEntry>> get(String segmentName, List<BufferView> keys, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.get(segmentName, keys, timeout), "get", segmentName, keys.size());
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableKey>>> keyIterator(String segmentName, IteratorArgs args) {
        return this.invokeExtension(segmentName, e -> e.keyIterator(segmentName, args), "get", segmentName, args);
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryIterator(String segmentName, IteratorArgs args) {
        return this.invokeExtension(segmentName, e -> e.entryIterator(segmentName, args), "get", segmentName, args);
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryDeltaIterator(String segmentName, long fromPosition, Duration fetchTimeout) {
        return this.invokeExtension(segmentName, e -> e.entryDeltaIterator(segmentName, fromPosition, fetchTimeout), "entryDeltaIterator", segmentName, fromPosition, fetchTimeout);
    }

    public CompletableFuture<TableSegmentInfo> getInfo(String segmentName, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.getInfo(segmentName, timeout), "getInfo", segmentName, timeout);
    }

    private <T> CompletableFuture<T> invokeExtension(String streamSegmentName, Function<ContainerTableExtension, CompletableFuture<T>> toInvoke, String methodName, Object ... logArgs) {
        return super.invoke(streamSegmentName, (SegmentContainer segmentContainer) -> (CompletableFuture)toInvoke.apply(segmentContainer.getExtension(ContainerTableExtension.class)), methodName, logArgs);
    }
}

