/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.io.SerializationException;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.BufferViewBuilder;
import io.pravega.segmentstore.contracts.BadAttributeUpdateException;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.WriterFlushResult;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.logs.operations.CachedStreamSegmentAppendOperation;
import io.pravega.segmentstore.server.tables.AsyncTableEntryReader;
import io.pravega.segmentstore.server.tables.BucketUpdate;
import io.pravega.segmentstore.server.tables.HashTableCompactor;
import io.pravega.segmentstore.server.tables.IndexReader;
import io.pravega.segmentstore.server.tables.IndexWriter;
import io.pravega.segmentstore.server.tables.KeyUpdateCollection;
import io.pravega.segmentstore.server.tables.TableBucketReader;
import io.pravega.segmentstore.server.tables.TableCompactor;
import io.pravega.segmentstore.server.tables.TableWriterConnector;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterTableProcessor
implements WriterSegmentProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WriterTableProcessor.class);
    private final TableWriterConnector connector;
    private final IndexWriter indexWriter;
    private final ScheduledExecutorService executor;
    private final OperationAggregator aggregator;
    private final AtomicLong lastAddedOffset;
    private final AtomicBoolean closed;
    private final String traceObjectId;
    private final TableCompactor.Config tableCompactorConfig;

    WriterTableProcessor(@NonNull TableWriterConnector connector, @NonNull ScheduledExecutorService executor) {
        if (connector == null) {
            throw new NullPointerException("connector is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.connector = connector;
        this.executor = executor;
        this.indexWriter = new IndexWriter(connector.getKeyHasher(), executor);
        this.aggregator = new OperationAggregator(IndexReader.getLastIndexedOffset(this.connector.getMetadata()));
        this.lastAddedOffset = new AtomicLong(-1L);
        this.closed = new AtomicBoolean();
        this.traceObjectId = String.format("TableProcessor[%d-%d]", this.connector.getMetadata().getContainerId(), this.connector.getMetadata().getId());
        this.tableCompactorConfig = new TableCompactor.Config(this.connector.getMaxCompactionSize());
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.connector.close();
            log.info("{}: Closed.", (Object)this.traceObjectId);
        }
    }

    @Override
    public void add(SegmentOperation operation) throws DataCorruptionException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkArgument((operation.getStreamSegmentId() == this.connector.getMetadata().getId() ? 1 : 0) != 0, (String)"Operation '%s' refers to a different Segment than this one (%s).", (Object)operation, (long)this.connector.getMetadata().getId());
        Preconditions.checkArgument((operation.getSequenceNumber() != Long.MIN_VALUE ? 1 : 0) != 0, (String)"Operation '%s' does not have a Sequence Number assigned.", (Object)operation);
        if (this.connector.getMetadata().isDeleted() || !(operation instanceof CachedStreamSegmentAppendOperation)) {
            return;
        }
        CachedStreamSegmentAppendOperation append = (CachedStreamSegmentAppendOperation)operation;
        if (this.lastAddedOffset.get() >= 0L) {
            if (this.lastAddedOffset.get() != append.getStreamSegmentOffset()) {
                throw new DataCorruptionException(String.format("Wrong offset for Operation '%s'. Expected: %s, actual: %d.", operation, this.lastAddedOffset, append.getStreamSegmentOffset()), new Object[0]);
            }
        } else if (this.aggregator.getLastIndexedOffset() < append.getStreamSegmentOffset()) {
            throw new DataCorruptionException(String.format("Operation '%s' begins after TABLE_INDEXED_OFFSET. Expected: %s, actual: %d.", operation, this.aggregator.getLastIndexedOffset(), append.getStreamSegmentOffset()), new Object[0]);
        }
        if (append.getStreamSegmentOffset() >= this.aggregator.getLastIndexedOffset()) {
            this.aggregator.add(append);
            this.lastAddedOffset.set(append.getLastStreamSegmentOffset());
            log.debug("{}: Add {} (State={}).", new Object[]{this.traceObjectId, operation, this.aggregator});
        } else {
            log.debug("{}: Skipped {} (State={}).", new Object[]{this.traceObjectId, operation, this.aggregator});
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public long getLowestUncommittedSequenceNumber() {
        return this.aggregator.getFirstSequenceNumber();
    }

    @Override
    public boolean mustFlush() {
        if (this.connector.getMetadata().isDeleted()) {
            return false;
        }
        return !this.aggregator.isEmpty();
    }

    @Override
    public CompletableFuture<WriterFlushResult> flush(boolean force, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        if (!force && !this.mustFlush()) {
            return CompletableFuture.completedFuture(new WriterFlushResult());
        }
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.connector.getSegment(timer.getRemaining()).thenComposeAsync(segment -> this.flushWithSingleRetry((DirectSegmentAccess)segment, timer).thenComposeAsync(flushResult -> {
            this.flushComplete((TableWriterFlushResult)flushResult);
            return this.compactIfNeeded((DirectSegmentAccess)segment, flushResult.highestCopiedOffset, timer).thenApply(v -> flushResult);
        }, (Executor)this.executor), (Executor)this.executor);
    }

    public String toString() {
        return String.format("[%d: %s] Count = %d, LastOffset = %s, LUSN = %d", this.connector.getMetadata().getId(), this.connector.getMetadata().getName(), this.aggregator.size(), this.lastAddedOffset, this.getLowestUncommittedSequenceNumber());
    }

    private CompletableFuture<Void> compactIfNeeded(DirectSegmentAccess segment, long highestCopiedOffset, TimeoutTimer timer) {
        HashTableCompactor compactor = new HashTableCompactor(segment, this.tableCompactorConfig, this.indexWriter, this.connector.getKeyHasher(), this.executor);
        return ((CompletableFuture)((CompletableFuture)compactor.isCompactionRequired().thenComposeAsync(isRequired -> {
            if (isRequired.booleanValue()) {
                return compactor.compact(timer);
            }
            log.debug("{}: No compaction required at this time.", (Object)this.traceObjectId);
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.executor)).thenComposeAsync(v -> {
            long truncateOffset = compactor.calculateTruncationOffset(highestCopiedOffset);
            if (truncateOffset > 0L) {
                log.debug("{}: Truncating segment at offset {}.", (Object)this.traceObjectId, (Object)truncateOffset);
                return segment.truncate(truncateOffset, timer.getRemaining());
            }
            log.debug("{}: No segment truncation possible now.", (Object)this.traceObjectId);
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.executor)).exceptionally(ex -> {
            log.error("{}: Compaction failed.", (Object)this.traceObjectId, ex);
            return null;
        });
    }

    private CompletableFuture<TableWriterFlushResult> flushWithSingleRetry(DirectSegmentAccess segment, TimeoutTimer timer) {
        return Futures.exceptionallyComposeExpecting(this.flushOnce(segment, timer), this::canRetryFlushException, () -> {
            this.reconcileTableIndexOffset();
            return this.flushOnce(segment, timer);
        });
    }

    private void flushComplete(TableWriterFlushResult flushResult) {
        log.debug("{}: FlushComplete (State={}).", (Object)this.traceObjectId, (Object)this.aggregator);
        this.aggregator.setLastIndexedOffset(flushResult.lastIndexedOffset);
        this.connector.notifyIndexOffsetChanged(this.aggregator.getLastIndexedOffset(), flushResult.processedBytes);
    }

    private CompletableFuture<TableWriterFlushResult> flushOnce(DirectSegmentAccess segment, TimeoutTimer timer) {
        long lastOffset = this.aggregator.getLastIndexToProcessAtOnce(this.connector.getMaxFlushSize());
        assert (lastOffset - this.aggregator.getFirstOffset() <= (long)this.connector.getMaxFlushSize());
        if (lastOffset < this.aggregator.getLastOffset()) {
            log.info("{}: Partial flush initiated up to offset {}. State: {}.", new Object[]{this.traceObjectId, lastOffset, this.aggregator});
        }
        KeyUpdateCollection keyUpdates = this.readKeysFromSegment(segment, this.aggregator.getFirstOffset(), lastOffset, timer);
        log.debug("{}: Flush.ReadFromSegment KeyCount={}, UpdateCount={}, HighestCopiedOffset={}, LastIndexedOffset={}.", new Object[]{this.traceObjectId, keyUpdates.getUpdates().size(), keyUpdates.getTotalUpdateCount(), keyUpdates.getHighestCopiedOffset(), keyUpdates.getLastIndexedOffset()});
        return ((CompletableFuture)this.indexWriter.groupByBucket(segment, keyUpdates.getUpdates(), timer).thenComposeAsync(builders -> this.fetchExistingKeys((Collection<BucketUpdate.Builder>)builders, segment, timer).thenComposeAsync(v -> {
            List<BucketUpdate> bucketUpdates = builders.stream().map(BucketUpdate.Builder::build).collect(Collectors.toList());
            this.logBucketUpdates(bucketUpdates);
            return this.indexWriter.updateBuckets(segment, bucketUpdates, this.aggregator.getLastIndexedOffset(), keyUpdates.getLastIndexedOffset(), keyUpdates.getTotalUpdateCount(), timer.getRemaining());
        }, (Executor)this.executor), (Executor)this.executor)).thenApply(updateCount -> new TableWriterFlushResult(keyUpdates, (int)updateCount));
    }

    private void reconcileTableIndexOffset() {
        long tableIndexOffset = IndexReader.getLastIndexedOffset(this.connector.getMetadata());
        if (tableIndexOffset < this.aggregator.getLastIndexedOffset()) {
            throw new DataCorruptionException(String.format("Cannot reconcile INDEX_OFFSET attribute (%s) for Segment '%s'. It is lower than our known value (%s).", tableIndexOffset, this.connector.getMetadata().getId(), this.aggregator.getLastIndexedOffset()), new Object[0]);
        }
        if (!this.aggregator.setLastIndexedOffset(tableIndexOffset)) {
            throw new DataCorruptionException(String.format("Cannot reconcile INDEX_OFFSET attribute (%s) for Segment '%s'. Most likely it does not conform to an append boundary.  Existing value: %s.", tableIndexOffset, this.connector.getMetadata().getId(), this.aggregator.getLastIndexedOffset()), new Object[0]);
        }
        log.info("{}: ReconcileTableIndexOffset (State={}).", (Object)this.traceObjectId, (Object)this.aggregator);
    }

    private boolean canRetryFlushException(Throwable ex) {
        if (ex instanceof BadAttributeUpdateException) {
            BadAttributeUpdateException bau = (BadAttributeUpdateException)ex;
            return bau.getAttributeId() != null && bau.getAttributeId().equals((Object)TableAttributes.INDEX_OFFSET);
        }
        return false;
    }

    private KeyUpdateCollection readKeysFromSegment(DirectSegmentAccess segment, long firstOffset, long lastOffset, TimeoutTimer timer) {
        KeyUpdateCollection keyUpdates = new KeyUpdateCollection((int)(lastOffset - firstOffset));
        BufferView.Reader memoryRead = this.readFromInMemorySegment(segment, firstOffset, lastOffset, timer).getBufferViewReader();
        for (long segmentOffset = firstOffset; segmentOffset < lastOffset; segmentOffset += (long)this.indexSingleKey(memoryRead, segmentOffset, keyUpdates)) {
        }
        return keyUpdates;
    }

    private int indexSingleKey(BufferView.Reader input, long entryOffset, KeyUpdateCollection keyUpdateCollection) throws SerializationException {
        AsyncTableEntryReader.DeserializedEntry e = AsyncTableEntryReader.readEntryComponents(input, entryOffset, this.connector.getSerializer());
        BucketUpdate.KeyUpdate update = new BucketUpdate.KeyUpdate(e.getKey(), entryOffset, e.getVersion(), e.getHeader().isDeletion());
        keyUpdateCollection.add(update, e.getHeader().getTotalLength(), e.getHeader().getEntryVersion());
        return e.getHeader().getTotalLength();
    }

    private BufferView readFromInMemorySegment(DirectSegmentAccess segment, long startOffset, long endOffset, TimeoutTimer timer) {
        long readOffset = startOffset;
        long remainingLength = endOffset - startOffset;
        BufferViewBuilder builder = BufferView.builder();
        while (remainingLength > 0L) {
            int readLength = (int)Math.min(remainingLength, Integer.MAX_VALUE);
            ReadResult readResult = segment.read(readOffset, readLength, timer.getRemaining());
            try {
                readResult.readRemaining(readLength, timer.getRemaining()).forEach(arg_0 -> ((BufferViewBuilder)builder).add(arg_0));
                assert (readResult.getConsumedLength() == readLength) : "Expecting a full read (from memory).";
                remainingLength -= (long)readResult.getConsumedLength();
                readOffset += (long)readResult.getConsumedLength();
            }
            finally {
                if (readResult == null) continue;
                readResult.close();
            }
        }
        return builder.build();
    }

    private CompletableFuture<Void> fetchExistingKeys(Collection<BucketUpdate.Builder> builders, DirectSegmentAccess segment, TimeoutTimer timer) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return Futures.loop(builders, bucketUpdate -> this.fetchExistingKeys((BucketUpdate.Builder)bucketUpdate, segment, timer).thenApply(v -> true), (Executor)this.executor);
    }

    private CompletableFuture<Void> fetchExistingKeys(BucketUpdate.Builder builder, DirectSegmentAccess segment, TimeoutTimer timer) {
        return TableBucketReader.key(segment, this.indexWriter::getBackpointerOffset, this.executor).findAll(builder.getBucket().getSegmentOffset(), (key, offset) -> builder.withExistingKey(new BucketUpdate.KeyInfo(key.getKey(), (long)offset, key.getVersion())), timer);
    }

    private void logBucketUpdates(Collection<BucketUpdate> bucketUpdates) {
        if (!log.isTraceEnabled()) {
            return;
        }
        log.trace("{}: Updating {} TableBucket(s).", (Object)this.traceObjectId, (Object)bucketUpdates.size());
        bucketUpdates.forEach(bu -> log.trace("{}: TableBucket [Offset={}, {}]: ExistingKeys=[{}], Updates=[{}].", new Object[]{this.traceObjectId, bu.getBucketOffset(), bu.getBucket(), bu.getExistingKeys().stream().map(Object::toString).collect(Collectors.joining("; ")), bu.getKeyUpdates().stream().map(Object::toString).collect(Collectors.joining("; "))}));
    }

    private static class TableWriterFlushResult
    extends WriterFlushResult {
        final long lastIndexedOffset;
        final long highestCopiedOffset;
        final int processedBytes;

        TableWriterFlushResult(KeyUpdateCollection keyUpdates, int attributeUpdateCount) {
            this.lastIndexedOffset = keyUpdates.getLastIndexedOffset();
            this.highestCopiedOffset = keyUpdates.getHighestCopiedOffset();
            this.processedBytes = keyUpdates.getLength();
            this.withFlushedAttributes(attributeUpdateCount);
        }
    }

    @ThreadSafe
    @VisibleForTesting
    static class OperationAggregator {
        @GuardedBy(value="this")
        private long lastIndexedOffset;
        @GuardedBy(value="this")
        private final ArrayDeque<CachedStreamSegmentAppendOperation> appends = new ArrayDeque();

        OperationAggregator(long lastIndexedOffset) {
            this.lastIndexedOffset = lastIndexedOffset;
        }

        synchronized void add(CachedStreamSegmentAppendOperation op) {
            this.appends.add(op);
        }

        synchronized boolean isEmpty() {
            return this.appends.isEmpty();
        }

        synchronized long getFirstSequenceNumber() {
            return this.appends.isEmpty() ? Long.MIN_VALUE : this.appends.peekFirst().getSequenceNumber();
        }

        synchronized long getFirstOffset() {
            return this.appends.isEmpty() ? -1L : this.appends.peekFirst().getStreamSegmentOffset();
        }

        synchronized long getLastOffset() {
            return this.appends.isEmpty() ? -1L : this.appends.peekLast().getLastStreamSegmentOffset();
        }

        synchronized long getLastIndexedOffset() {
            return this.lastIndexedOffset;
        }

        synchronized boolean setLastIndexedOffset(long value) {
            if (!this.appends.isEmpty()) {
                if (value >= this.getLastOffset()) {
                    this.appends.clear();
                } else {
                    while (!this.appends.isEmpty() && this.appends.peekFirst().getLastStreamSegmentOffset() <= value) {
                        this.appends.removeFirst();
                    }
                    if (!this.appends.isEmpty() && this.appends.peekFirst().getStreamSegmentOffset() != value) {
                        return false;
                    }
                }
            }
            if (value >= 0L) {
                this.lastIndexedOffset = value;
            }
            return true;
        }

        synchronized long getLastIndexToProcessAtOnce(int maxLength) {
            CachedStreamSegmentAppendOperation first = this.appends.peekFirst();
            if (first == null) {
                return -1L;
            }
            long maxOffset = first.getStreamSegmentOffset() + (long)maxLength;
            Iterator<CachedStreamSegmentAppendOperation> i = this.appends.descendingIterator();
            while (i.hasNext()) {
                long lastOffset = i.next().getLastStreamSegmentOffset();
                if (lastOffset > maxOffset) continue;
                return lastOffset;
            }
            return first.getLastStreamSegmentOffset();
        }

        synchronized int size() {
            return this.appends.size();
        }

        public synchronized String toString() {
            return String.format("Count = %d, FirstSN = %d, FirstOffset = %d, LastOffset = %d, LIdx = %s", this.appends.size(), this.getFirstSequenceNumber(), this.getFirstOffset(), this.getLastOffset(), this.getLastIndexedOffset());
        }
    }
}

