/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.writer;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.AbstractTimer;
import io.pravega.common.Exceptions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.StreamSegmentMergedException;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.WriterFlushResult;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.logs.operations.AttributeUpdaterOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentSealOperation;
import io.pravega.segmentstore.server.writer.WriterConfig;
import io.pravega.segmentstore.server.writer.WriterDataSource;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AttributeAggregator
implements WriterSegmentProcessor,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttributeAggregator.class);
    private final UpdateableSegmentMetadata metadata;
    private final WriterConfig config;
    private final AbstractTimer timer;
    private final Executor executor;
    private final String traceObjectId;
    private final WriterDataSource dataSource;
    private final AtomicReference<Duration> lastFlush;
    private final State state;
    private final AtomicBoolean closed;
    private final AtomicReference<RootPointerInfo> lastRootPointer;

    AttributeAggregator(@NonNull UpdateableSegmentMetadata segmentMetadata, @NonNull WriterDataSource dataSource, @NonNull WriterConfig config, @NonNull AbstractTimer timer, @NonNull Executor executor) {
        if (segmentMetadata == null) {
            throw new NullPointerException("segmentMetadata is marked non-null but is null");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (timer == null) {
            throw new NullPointerException("timer is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.metadata = segmentMetadata;
        this.config = config;
        this.dataSource = dataSource;
        this.timer = timer;
        this.executor = executor;
        this.lastFlush = new AtomicReference<Duration>(timer.getElapsed());
        Preconditions.checkArgument((this.metadata.getContainerId() == dataSource.getId() ? 1 : 0) != 0, (Object)"SegmentMetadata.ContainerId is different from WriterDataSource.Id");
        this.traceObjectId = String.format("AttributeAggregator[%d-%d]", this.metadata.getContainerId(), this.metadata.getId());
        this.state = new State(segmentMetadata.getAttributes().getOrDefault(Attributes.ATTRIBUTE_SEGMENT_PERSIST_SEQ_NO, Long.MIN_VALUE));
        this.closed = new AtomicBoolean();
        this.lastRootPointer = new AtomicReference();
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    @Override
    public long getLowestUncommittedSequenceNumber() {
        if (this.lastRootPointer.get() == null) {
            return this.state.getFirstSequenceNumber();
        }
        long lpsn = this.state.getLastPersistedSequenceNumber();
        return lpsn == Long.MIN_VALUE ? this.state.getFirstSequenceNumber() : lpsn + 1L;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    public String toString() {
        return String.format("[%d: %s] Count = %d, LUSN = %d, LastSeqNo = %d, LastFlush = %ds", this.metadata.getId(), this.metadata.getName(), this.state.size(), this.getLowestUncommittedSequenceNumber(), this.state.getLastSequenceNumber(), this.getElapsedSinceLastFlush().toMillis() / 1000L);
    }

    @Override
    public void add(SegmentOperation operation) throws DataCorruptionException {
        Exceptions.checkNotClosed((boolean)this.isClosed(), (Object)this);
        Preconditions.checkArgument((operation.getStreamSegmentId() == this.metadata.getId() ? 1 : 0) != 0, (String)"Operation '%s' refers to a different Segment than this one (%s).", (Object)operation, (long)this.metadata.getId());
        if (this.isSegmentDeleted()) {
            return;
        }
        boolean processed = false;
        if (operation instanceof StreamSegmentSealOperation) {
            this.state.seal();
            processed = true;
        } else if (operation instanceof AttributeUpdaterOperation) {
            AttributeUpdaterOperation op = (AttributeUpdaterOperation)operation;
            if (this.state.hasSeal()) {
                if (op.isInternal() && op.hasOnlyCoreAttributes()) {
                    log.debug("{}: Ignored internal operation on sealed segment {}.", (Object)this.traceObjectId, (Object)operation);
                    return;
                }
                throw new DataCorruptionException(String.format("Illegal operation for a sealed Segment; received '%s'.", operation), new Object[0]);
            }
            processed = this.state.include(op);
        }
        if (processed) {
            log.debug("{}: Add {}; OpCount={}.", new Object[]{this.traceObjectId, operation, this.state.size()});
        }
    }

    @Override
    public boolean mustFlush() {
        if (this.isSegmentDeleted()) {
            return false;
        }
        return this.state.hasSeal() || this.state.size() >= this.config.getFlushAttributesThreshold() || this.state.size() > 0 && this.getElapsedSinceLastFlush().compareTo(this.config.getFlushThresholdTime()) >= 0;
    }

    @Override
    public CompletableFuture<WriterFlushResult> flush(boolean force, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.isClosed(), (Object)this);
        if (!force && !this.mustFlush()) {
            return CompletableFuture.completedFuture(new WriterFlushResult());
        }
        TimeoutTimer timer = new TimeoutTimer(timeout);
        CompletionStage<Void> result = this.handleAttributeException(this.persistPendingAttributes(this.state.getAttributes(), this.state.getLastSequenceNumber(), timer));
        if (this.state.hasSeal()) {
            result = result.thenComposeAsync(v -> this.handleAttributeException(this.sealAttributes(timer)), this.executor);
        }
        return result.thenApply(v -> {
            if (this.state.size() > 0) {
                log.debug("{}: Flushed. Count={}, SeqNo={}-{}, Forced={}.", new Object[]{this.traceObjectId, this.state.size(), this.state.getFirstSequenceNumber(), this.state.getLastSequenceNumber(), force});
            }
            WriterFlushResult r = new WriterFlushResult();
            r.withFlushedAttributes(this.state.size());
            this.state.acceptChanges();
            this.lastFlush.set(this.timer.getElapsed());
            return r;
        });
    }

    private CompletableFuture<Void> persistPendingAttributes(Map<AttributeId, Long> attributes, long lastSeqNo, TimeoutTimer timer) {
        if (attributes.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.dataSource.persistAttributes(this.metadata.getId(), attributes, timer.getRemaining()).thenAcceptAsync(rootPointer -> this.queueRootPointerUpdate((long)rootPointer, lastSeqNo), this.executor);
    }

    private CompletableFuture<Void> sealAttributes(TimeoutTimer timer) {
        log.debug("{}: Sealing Attribute Index.", (Object)this.traceObjectId);
        return this.dataSource.sealAttributes(this.metadata.getId(), timer.getRemaining());
    }

    private void queueRootPointerUpdate(long newRootPointer, long lastSeqNo) {
        if (this.lastRootPointer.getAndSet(new RootPointerInfo(newRootPointer, lastSeqNo)) == null) {
            AtomicBoolean canContinue = new AtomicBoolean(this.lastRootPointer.get() != null);
            Futures.loop(canContinue::get, () -> {
                RootPointerInfo rpi = this.lastRootPointer.get();
                log.debug("{}: Updating Root Pointer info to {}.", (Object)this.traceObjectId, (Object)rpi);
                return this.dataSource.notifyAttributesPersisted(this.metadata.getId(), this.metadata.getType(), rpi.getRootPointer(), rpi.getLastSequenceNumber(), this.config.getFlushTimeout()).whenCompleteAsync((r, ex) -> {
                    if (ex != null) {
                        this.logAttributesPersistedError((Throwable)ex, rpi);
                    } else {
                        this.state.setLastPersistedSequenceNumber(rpi.getLastSequenceNumber());
                    }
                    if (this.lastRootPointer.compareAndSet(rpi, null)) {
                        canContinue.set(false);
                    }
                }, this.executor);
            }, (Executor)this.executor);
        }
    }

    private void logAttributesPersistedError(Throwable ex, RootPointerInfo rpi) {
        if ((ex = Exceptions.unwrap((Throwable)ex)) instanceof StreamSegmentMergedException || ex instanceof StreamSegmentNotExistsException) {
            log.info("{}: Unable to persist root pointer {} due to segment being merged or deleted.", (Object)this.traceObjectId, (Object)rpi);
        } else {
            log.error("{}: Unable to persist root pointer {}.", new Object[]{this.traceObjectId, rpi, ex});
        }
    }

    private <T> CompletableFuture<T> handleAttributeException(CompletableFuture<T> future) {
        return Futures.exceptionallyExpecting(future, ex -> ex instanceof StreamSegmentSealedException && this.metadata.isSealed() || (ex instanceof StreamSegmentNotExistsException || ex instanceof StreamSegmentMergedException) && (this.metadata.isMerged() || this.metadata.isDeleted()), null);
    }

    private boolean isSegmentDeleted() {
        return this.metadata.isDeleted() || this.metadata.isMerged();
    }

    private Duration getElapsedSinceLastFlush() {
        return this.timer.getElapsed().minus(this.lastFlush.get());
    }

    @ThreadSafe
    private static class State {
        private final Map<AttributeId, Long> attributes = Collections.synchronizedMap(new HashMap());
        private final AtomicLong lastPersistedSequenceNumber;
        private final AtomicLong firstSequenceNumber = new AtomicLong(Long.MIN_VALUE);
        private final AtomicLong lastSequenceNumber = new AtomicLong(Long.MIN_VALUE);
        private final AtomicBoolean sealed;

        State(long lastPersistedSequenceNumber) {
            this.lastPersistedSequenceNumber = new AtomicLong(lastPersistedSequenceNumber);
            this.sealed = new AtomicBoolean(false);
        }

        void seal() {
            this.sealed.set(true);
        }

        boolean hasSeal() {
            return this.sealed.get();
        }

        boolean include(AttributeUpdaterOperation operation) {
            Preconditions.checkState((!this.sealed.get() ? 1 : 0) != 0, (Object)"Cannot accept more operations after sealing.");
            if (operation.getSequenceNumber() <= this.lastPersistedSequenceNumber.get()) {
                return false;
            }
            boolean anyUpdates = false;
            if (operation.getAttributeUpdates() != null) {
                for (AttributeUpdate au : operation.getAttributeUpdates()) {
                    if (Attributes.isCoreAttribute((AttributeId)au.getAttributeId())) continue;
                    this.attributes.put(au.getAttributeId(), au.getValue());
                    anyUpdates = true;
                }
            }
            if (anyUpdates) {
                this.firstSequenceNumber.compareAndSet(Long.MIN_VALUE, operation.getSequenceNumber());
                this.lastPersistedSequenceNumber.compareAndSet(Long.MIN_VALUE, operation.getSequenceNumber() - 1L);
                this.lastSequenceNumber.set(operation.getSequenceNumber());
            }
            return anyUpdates;
        }

        long getFirstSequenceNumber() {
            return this.firstSequenceNumber.get();
        }

        long getLastSequenceNumber() {
            return this.lastSequenceNumber.get();
        }

        void setLastPersistedSequenceNumber(long value) {
            this.lastPersistedSequenceNumber.set(value);
        }

        long getLastPersistedSequenceNumber() {
            return this.lastPersistedSequenceNumber.get();
        }

        int size() {
            return this.attributes.size();
        }

        Map<AttributeId, Long> getAttributes() {
            return this.attributes;
        }

        void acceptChanges() {
            this.attributes.clear();
            this.firstSequenceNumber.set(Long.MIN_VALUE);
            this.lastSequenceNumber.set(Long.MIN_VALUE);
            this.sealed.set(false);
        }
    }

    private static class RootPointerInfo {
        private final long rootPointer;
        private final long lastSequenceNumber;

        public String toString() {
            return String.format("RootPointer=%s, LastSeqNo=%s", this.rootPointer, this.lastSequenceNumber);
        }

        @ConstructorProperties(value={"rootPointer", "lastSequenceNumber"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RootPointerInfo(long rootPointer, long lastSequenceNumber) {
            this.rootPointer = rootPointer;
            this.lastSequenceNumber = lastSequenceNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRootPointer() {
            return this.rootPointer;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLastSequenceNumber() {
            return this.lastSequenceNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RootPointerInfo)) {
                return false;
            }
            RootPointerInfo other = (RootPointerInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRootPointer() != other.getRootPointer()) {
                return false;
            }
            return this.getLastSequenceNumber() == other.getLastSequenceNumber();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RootPointerInfo;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $rootPointer = this.getRootPointer();
            result = result * 59 + (int)($rootPointer >>> 32 ^ $rootPointer);
            long $lastSequenceNumber = this.getLastSequenceNumber();
            result = result * 59 + (int)($lastSequenceNumber >>> 32 ^ $lastSequenceNumber);
            return result;
        }
    }
}

