/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.AbstractTimer;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.MathHelpers;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.AbstractThreadPoolService;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.SequentialProcessor;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.SegmentStoreMetrics;
import io.pravega.segmentstore.server.ServiceHaltException;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.Writer;
import io.pravega.segmentstore.server.WriterFactory;
import io.pravega.segmentstore.server.WriterFlushResult;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.logs.operations.MetadataCheckpointOperation;
import io.pravega.segmentstore.server.logs.operations.MetadataOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import io.pravega.segmentstore.server.writer.AckCalculator;
import io.pravega.segmentstore.server.writer.AttributeAggregator;
import io.pravega.segmentstore.server.writer.SegmentAggregator;
import io.pravega.segmentstore.server.writer.WriterConfig;
import io.pravega.segmentstore.server.writer.WriterDataSource;
import io.pravega.segmentstore.server.writer.WriterState;
import io.pravega.segmentstore.storage.DataLogWriterNotPrimaryException;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageNotPrimaryException;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StorageWriter
extends AbstractThreadPoolService
implements Writer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageWriter.class);
    private final WriterConfig config;
    private final WriterDataSource dataSource;
    private final Storage storage;
    private final HashMap<Long, ProcessorCollection> processors;
    private final WriterState state;
    private final Timer timer;
    private final AckCalculator ackCalculator;
    private final WriterFactory.CreateProcessors createProcessors;
    private final SequentialProcessor ackProcessor;
    private final SegmentStoreMetrics.StorageWriter metrics;

    StorageWriter(WriterConfig config, WriterDataSource dataSource, Storage storage, WriterFactory.CreateProcessors createProcessors, ScheduledExecutorService executor) {
        super(String.format("StorageWriter[%d]", dataSource.getId()), executor);
        this.config = (WriterConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.dataSource = dataSource;
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage, (Object)"storage");
        this.createProcessors = (WriterFactory.CreateProcessors)Preconditions.checkNotNull((Object)createProcessors, (Object)"createProcessors");
        this.processors = new HashMap();
        this.state = new WriterState();
        this.timer = new Timer();
        this.ackCalculator = new AckCalculator(this.state);
        this.ackProcessor = new SequentialProcessor((Executor)this.executor);
        this.metrics = new SegmentStoreMetrics.StorageWriter(dataSource.getId());
    }

    protected Duration getShutdownTimeout() {
        return this.config.getShutdownTimeout();
    }

    protected CompletableFuture<Void> doRun() {
        return Futures.loop(this::canRun, () -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)Futures.delayedFuture((Duration)this.getIterationStartDelay(), (ScheduledExecutorService)this.executor).thenRun(this::beginIteration)).thenComposeAsync(this::readData, (Executor)this.executor)).thenComposeAsync(this::processReadResult, (Executor)this.executor)).thenComposeAsync(this::flush, (Executor)this.executor)).thenRunAsync(this::triggerAcknowledge, this.executor)).exceptionally(this::iterationErrorHandler)).thenRunAsync(this::endIteration, this.executor), (Executor)this.executor).thenRun(this::closeProcessors);
    }

    private boolean canRun() {
        return this.isRunning() && this.getStopException() == null;
    }

    private void beginIteration() {
        this.state.recordIterationStarted((AbstractTimer)this.timer);
        this.logStageEvent("Start", null);
    }

    private void endIteration() {
        this.cleanup();
        Duration elapsed = this.state.getElapsedSinceIterationStart((AbstractTimer)this.timer);
        this.metrics.iterationComplete(elapsed);
        this.logStageEvent("Finish", "Elapsed " + elapsed.toMillis() + "ms");
    }

    private Void iterationErrorHandler(Throwable ex) {
        if (this.isShutdownException(ex) && !this.canRun()) {
            log.info("{}: StorageWriter intercepted {} while shutting down.", (Object)this.traceObjectId, (Object)Exceptions.unwrap((Throwable)ex).getClass().getSimpleName());
            return null;
        }
        boolean critical = this.isCriticalError(ex);
        this.logError(ex, critical);
        if (critical) {
            super.errorHandler(ex);
            this.stopAsync();
        } else {
            this.state.recordIterationError();
        }
        return null;
    }

    private void closeProcessors() {
        this.processors.values().forEach(ProcessorCollection::close);
        this.processors.clear();
        this.ackProcessor.close();
        this.metrics.close();
    }

    private CompletableFuture<Queue<Operation>> readData(Void ignored) {
        Queue<Operation> lastRead = this.state.getLastRead();
        if (lastRead != null && !lastRead.isEmpty()) {
            log.info("{}: Iteration[{}] Not performing a new read because there are still {} items unprocessed from the previous iteration.", new Object[]{this.traceObjectId, this.state.getIterationId(), lastRead.size()});
            return CompletableFuture.completedFuture(lastRead);
        }
        try {
            Duration readTimeout = this.getReadTimeout();
            return ((CompletableFuture)this.dataSource.read(this.config.getMaxItemsToReadAtOnce(), readTimeout).thenApply(this.state::setLastRead)).exceptionally(ex -> {
                if ((ex = Exceptions.unwrap((Throwable)ex)) instanceof TimeoutException) {
                    log.debug("{}: Iteration[{}] No items were read during allotted timeout of {}ms", new Object[]{this.traceObjectId, this.state.getIterationId(), readTimeout.toMillis()});
                    return null;
                }
                throw new CompletionException((Throwable)ex);
            });
        }
        catch (Throwable ex2) {
            Throwable realEx = Exceptions.unwrap((Throwable)ex2);
            if (realEx instanceof TimeoutException) {
                this.logErrorHandled(realEx);
                return CompletableFuture.completedFuture(null);
            }
            return Futures.failedFuture((Throwable)ex2);
        }
    }

    private CompletableFuture<Void> processReadResult(Queue<Operation> readResult) {
        InputReadStageResult result = new InputReadStageResult(this.state);
        if (readResult == null) {
            this.state.recordReadComplete();
            this.metrics.readComplete(0);
            this.logStageEvent("InputRead", result);
            return CompletableFuture.completedFuture(null);
        }
        return Futures.loop(() -> this.canRun() && !readResult.isEmpty(), () -> {
            Operation op = (Operation)readResult.peek();
            return this.processOperation(op).thenRun(() -> {
                this.state.setLastReadSequenceNumber(op.getSequenceNumber());
                readResult.poll();
                result.operationProcessed(op);
            });
        }, (Executor)this.executor).thenRun(() -> {
            Preconditions.checkState((boolean)readResult.isEmpty(), (String)"processReadResult exited normally but there are still {} items to process.", (int)readResult.size());
            this.state.setLastRead(null);
            this.logStageEvent("InputRead", result);
        });
    }

    private CompletableFuture<Void> processOperation(Operation op) {
        if (op.getSequenceNumber() <= this.state.getLastReadSequenceNumber()) {
            return Futures.failedFuture((Throwable)((Object)new DataCorruptionException(String.format("Operation '%s' has a sequence number that is lower than the previous one (%d).", op, this.state.getLastReadSequenceNumber()), new Object[0])));
        }
        if (op instanceof SegmentOperation) {
            return this.processSegmentOperation((SegmentOperation)((Object)op));
        }
        if (op instanceof MetadataOperation) {
            return this.processMetadataOperation((MetadataOperation)op);
        }
        return Futures.failedFuture((Throwable)((Object)new ServiceHaltException(String.format("Unsupported operation %s.", op), new Object[0])));
    }

    private CompletableFuture<Void> processMetadataOperation(MetadataOperation op) {
        if (op instanceof MetadataCheckpointOperation && !this.dataSource.isValidTruncationPoint(op.getSequenceNumber())) {
            return Futures.failedFuture((Throwable)((Object)new DataCorruptionException(String.format("Operation '%s' does not correspond to a valid Truncation Point in the metadata.", op), new Object[0])));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> processSegmentOperation(SegmentOperation op) {
        return this.getProcessor(op.getStreamSegmentId()).thenAccept(aggregator -> {
            try {
                aggregator.add(op);
            }
            catch (ServiceHaltException ex) {
                throw new CompletionException((Throwable)((Object)ex));
            }
            catch (Exception ex) {
                throw new CompletionException((Throwable)((Object)new ServiceHaltException("Unable to process operation " + op, ex, new Object[0])));
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> forceFlush(long upToSequenceNumber, Duration timeout) {
        return this.state.setForceFlush(upToSequenceNumber);
    }

    private CompletableFuture<Void> flush(Void ignored) {
        this.checkRunning();
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"flush", (Object[])new Object[0]);
        Timer timer = new Timer();
        boolean forceFlush = this.state.isForceFlush();
        List flushFutures = this.processors.values().stream().filter(pc -> forceFlush || pc.mustFlush()).map(a -> a.flush(forceFlush, this.config.getFlushTimeout())).collect(Collectors.toList());
        return Futures.allOfWithResults(flushFutures).thenAcceptAsync(flushResults -> {
            FlushStageResult result = new FlushStageResult();
            flushResults.forEach(result::withFlushResult);
            if (result.getFlushedBytes() + result.getMergedBytes() + (long)result.getFlushedAttributes() > 0L) {
                this.logStageEvent("Flush", result);
            }
            this.metrics.flushComplete(result.getFlushedBytes(), result.getMergedBytes(), result.getFlushedAttributes(), timer.getElapsed());
            this.state.recordFlushComplete(result);
            LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"flush", (long)traceId, (Object[])new Object[0]);
        }, (Executor)this.executor);
    }

    private void cleanup() {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"cleanup", (Object[])new Object[0]);
        List<Long> toRemove = this.processors.values().stream().map(this::closeIfNecessary).filter(ProcessorCollection::isClosed).map(ProcessorCollection::getId).collect(Collectors.toList());
        toRemove.forEach(this.processors::remove);
        LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"cleanup", (long)traceId, (Object[])new Object[]{toRemove.size()});
    }

    private ProcessorCollection closeIfNecessary(ProcessorCollection processorCollection) {
        if (processorCollection.shouldClose()) {
            processorCollection.close();
        }
        return processorCollection;
    }

    private void triggerAcknowledge() {
        this.checkRunning();
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"acknowledge", (Object[])new Object[0]);
        long highestCommittedSeqNo = this.ackCalculator.getHighestCommittedSequenceNumber(this.processors.values());
        long ackSequenceNumber = this.dataSource.getClosestValidTruncationPoint(highestCommittedSeqNo);
        if (ackSequenceNumber > this.state.getLastTruncatedSequenceNumber()) {
            this.ackProcessor.add(() -> {
                if (ackSequenceNumber <= this.state.getLastTruncatedSequenceNumber()) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.dataSource.acknowledge(ackSequenceNumber, this.config.getAckTimeout()).thenRun(() -> {
                    this.state.setLastTruncatedSequenceNumber(ackSequenceNumber);
                    this.logStageEvent("Acknowledged", "SeqNo=" + ackSequenceNumber);
                    LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"acknowledge", (long)traceId, (Object[])new Object[]{ackSequenceNumber});
                });
            }).exceptionally(this::iterationErrorHandler);
        } else {
            LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"acknowledge", (long)traceId, (Object[])new Object[]{Long.MIN_VALUE});
        }
    }

    private CompletableFuture<ProcessorCollection> getProcessor(long streamSegmentId) {
        UpdateableSegmentMetadata segmentMetadata;
        ProcessorCollection existingProcessor = this.processors.getOrDefault(streamSegmentId, null);
        if (existingProcessor != null) {
            if (this.closeIfNecessary(existingProcessor).isClosed()) {
                this.processors.remove(streamSegmentId);
            } else {
                return CompletableFuture.completedFuture(existingProcessor);
            }
        }
        if ((segmentMetadata = this.dataSource.getStreamSegmentMetadata(streamSegmentId)) == null) {
            return Futures.failedFuture((Throwable)((Object)new DataCorruptionException(String.format("No StreamSegment with id '%d' is registered in the metadata.", streamSegmentId), new Object[0])));
        }
        SegmentAggregator segmentAggregator = new SegmentAggregator(segmentMetadata, this.dataSource, this.storage, this.config, (AbstractTimer)this.timer, this.executor);
        AttributeAggregator attributeAggregator = new AttributeAggregator(segmentMetadata, this.dataSource, this.config, (AbstractTimer)this.timer, this.executor);
        ProcessorCollection pc = new ProcessorCollection(segmentAggregator, attributeAggregator, this.createProcessors.apply(segmentMetadata));
        try {
            CompletableFuture<Void> init = segmentAggregator.initialize(this.config.getFlushTimeout());
            Futures.exceptionListener(init, ex -> segmentAggregator.close());
            return init.thenApply(ignored -> {
                this.processors.put(streamSegmentId, pc);
                return pc;
            });
        }
        catch (Exception ex2) {
            pc.close();
            throw ex2;
        }
    }

    private boolean isCriticalError(Throwable ex) {
        return Exceptions.mustRethrow((Throwable)(ex = Exceptions.unwrap((Throwable)ex))) || ex instanceof ServiceHaltException || ex instanceof StorageNotPrimaryException || ex instanceof DataLogWriterNotPrimaryException;
    }

    private boolean isShutdownException(Throwable ex) {
        return (ex = Exceptions.unwrap((Throwable)ex)) instanceof ObjectClosedException || ex instanceof CancellationException;
    }

    private Duration getReadTimeout() {
        long maxTimeMillis = this.config.getMaxReadTimeout().toMillis();
        long minTimeMillis = this.config.getMinReadTimeout().toMillis();
        long timeMillis = maxTimeMillis;
        for (ProcessorCollection a : this.processors.values()) {
            if (a.mustFlush()) {
                timeMillis = 0L;
                break;
            }
            timeMillis = MathHelpers.minMax((long)this.config.getFlushThresholdTime().minus(a.getElapsedSinceLastFlush()).toMillis(), (long)minTimeMillis, (long)timeMillis);
        }
        return Duration.ofMillis(timeMillis);
    }

    private Duration getIterationStartDelay() {
        if (this.state.getLastIterationError()) {
            return this.config.getErrorSleepDuration();
        }
        return Duration.ZERO;
    }

    private void logStageEvent(String stageName, Object result) {
        if (result == null) {
            log.debug("{}: Iteration[{}].{}.", new Object[]{this.traceObjectId, this.state.getIterationId(), stageName});
        } else {
            log.debug("{}: Iteration[{}].{} ({}).", new Object[]{this.traceObjectId, this.state.getIterationId(), stageName, result});
        }
    }

    private void logError(Throwable ex, boolean critical) {
        ex = Exceptions.unwrap((Throwable)ex);
        if (critical) {
            log.error("{}: Iteration[{}].CriticalError.", new Object[]{this.traceObjectId, this.state.getIterationId(), ex});
        } else {
            log.error("{}: Iteration[{}].Error.", new Object[]{this.traceObjectId, this.state.getIterationId(), ex});
        }
    }

    private void logErrorHandled(Throwable ex) {
        ex = Exceptions.unwrap((Throwable)ex);
        log.warn("{}: Iteration[{}].HandledError {}", new Object[]{this.traceObjectId, this.state.getIterationId(), ex.toString()});
    }

    private void checkRunning() {
        if (!this.canRun()) {
            throw new CancellationException("StorageWriter has been stopped.");
        }
    }

    private class ProcessorCollection
    implements WriterSegmentProcessor {
        private final SegmentAggregator aggregator;
        private final List<WriterSegmentProcessor> processors;

        ProcessorCollection(SegmentAggregator aggregator, AttributeAggregator attributeAggregator, Collection<WriterSegmentProcessor> processors) {
            this.aggregator = aggregator;
            this.processors = ImmutableList.builder().add((Object)aggregator).add((Object)attributeAggregator).addAll(processors).build();
        }

        Duration getElapsedSinceLastFlush() {
            return this.aggregator.getElapsedSinceLastFlush();
        }

        long getId() {
            return this.aggregator.getMetadata().getId();
        }

        boolean shouldClose() {
            return this.aggregator.getMetadata().isDeletedInStorage() || !this.aggregator.getMetadata().isActive();
        }

        @Override
        public void close() {
            this.processors.forEach(WriterSegmentProcessor::close);
        }

        @Override
        public boolean isClosed() {
            return this.processors.stream().allMatch(WriterSegmentProcessor::isClosed);
        }

        @Override
        public long getLowestUncommittedSequenceNumber() {
            return StorageWriter.this.ackCalculator.getLowestUncommittedSequenceNumber(this.processors);
        }

        @Override
        public boolean mustFlush() {
            return this.processors.stream().anyMatch(WriterSegmentProcessor::mustFlush);
        }

        @Override
        public void add(SegmentOperation operation) throws ServiceHaltException {
            for (WriterSegmentProcessor wsp : this.processors) {
                wsp.add(operation);
            }
        }

        @Override
        public CompletableFuture<WriterFlushResult> flush(boolean force, Duration timeout) {
            return Futures.allOfWithResults(this.processors.stream().map(wsp -> wsp.flush(force, timeout)).collect(Collectors.toList())).thenApply(results -> {
                WriterFlushResult r = (WriterFlushResult)results.get(0);
                for (int i = 1; i < results.size(); ++i) {
                    r.withFlushResult((WriterFlushResult)results.get(i));
                }
                return r;
            });
        }
    }

    private static class InputReadStageResult {
        int count;
        long bytes;
        private final WriterState state;

        InputReadStageResult(WriterState state) {
            this.state = state;
        }

        void operationProcessed(Operation op) {
            ++this.count;
            if (op instanceof StorageOperation) {
                this.bytes += ((StorageOperation)op).getLength();
            }
        }

        public String toString() {
            return String.format("Count=%d, Bytes=%d, LastReadSN=%d", this.count, this.bytes, this.state.getLastReadSequenceNumber());
        }
    }

    private static class FlushStageResult
    extends WriterFlushResult {
        int count;

        private FlushStageResult() {
        }

        @Override
        public FlushStageResult withFlushResult(WriterFlushResult flushResult) {
            ++this.count;
            return (FlushStageResult)super.withFlushResult(flushResult);
        }

        @Override
        public String toString() {
            return String.format("Count=%d, %s", this.count, super.toString());
        }
    }
}

