/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.writer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;
import java.time.Duration;
import lombok.Generated;

public class WriterConfig {
    public static final Property<Integer> FLUSH_THRESHOLD_BYTES = Property.named((String)"flush.threshold.bytes", (Object)0x400000, (String)"flushThresholdBytes");
    public static final Property<Long> FLUSH_THRESHOLD_MILLIS = Property.named((String)"flush.threshold.milliseconds", (Object)30000L, (String)"flushThresholdMillis");
    public static final Property<Integer> FLUSH_ATTRIBUTES_THRESHOLD = Property.named((String)"flush.attributes.threshold", (Object)200, (String)"flushAttributesThreshold");
    public static final Property<Integer> MAX_FLUSH_SIZE_BYTES = Property.named((String)"flush.size.bytes.max", (Object)((Integer)FLUSH_THRESHOLD_BYTES.getDefaultValue()), (String)"maxFlushSizeBytes");
    public static final Property<Integer> MAX_ITEMS_TO_READ_AT_ONCE = Property.named((String)"itemsToReadAtOnce.max", (Object)1000, (String)"maxItemsToReadAtOnce");
    public static final Property<Long> MIN_READ_TIMEOUT_MILLIS = Property.named((String)"read.timeout.milliseconds.min", (Object)2000L, (String)"minReadTimeoutMillis");
    public static final Property<Long> MAX_READ_TIMEOUT_MILLIS = Property.named((String)"read.timeout.milliseconds.max", (Object)1800000L, (String)"maxReadTimeoutMillis");
    public static final Property<Long> ERROR_SLEEP_MILLIS = Property.named((String)"error.sleep.milliseconds", (Object)1000L, (String)"errorSleepMillis");
    public static final Property<Long> FLUSH_TIMEOUT_MILLIS = Property.named((String)"flush.timeout.milliseconds", (Object)60000L, (String)"flushTimeoutMillis");
    public static final Property<Long> ACK_TIMEOUT_MILLIS = Property.named((String)"ack.timeout.milliseconds", (Object)15000L, (String)"ackTimeoutMillis");
    public static final Property<Long> SHUTDOWN_TIMEOUT_MILLIS = Property.named((String)"shutDown.timeout.milliseconds", (Object)10000L, (String)"shutdownTimeoutMillis");
    public static final Property<Long> MAX_ROLLOVER_SIZE = Property.named((String)"rollover.size.bytes.max", (Object)SegmentRollingPolicy.NO_ROLLING.getMaxLength(), (String)"maxRolloverSizeBytes");
    private static final String COMPONENT_CODE = "writer";
    private final int flushThresholdBytes;
    private final Duration flushThresholdTime;
    private final int flushAttributesThreshold;
    private final int maxFlushSizeBytes;
    private final int maxItemsToReadAtOnce;
    private final Duration minReadTimeout;
    private final Duration maxReadTimeout;
    private final Duration errorSleepDuration;
    private final Duration flushTimeout;
    private final Duration ackTimeout;
    private final Duration shutdownTimeout;
    private final long maxRolloverSize;

    private WriterConfig(TypedProperties properties) throws ConfigurationException {
        this.flushThresholdBytes = properties.getInt(FLUSH_THRESHOLD_BYTES);
        if (this.flushThresholdBytes < 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a non-negative integer.", FLUSH_THRESHOLD_BYTES));
        }
        this.flushThresholdTime = Duration.ofMillis(properties.getLong(FLUSH_THRESHOLD_MILLIS));
        this.flushAttributesThreshold = properties.getInt(FLUSH_ATTRIBUTES_THRESHOLD);
        if (this.flushAttributesThreshold < 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a non-negative integer.", FLUSH_THRESHOLD_BYTES));
        }
        this.maxFlushSizeBytes = properties.getInt(MAX_FLUSH_SIZE_BYTES);
        this.maxItemsToReadAtOnce = properties.getInt(MAX_ITEMS_TO_READ_AT_ONCE);
        if (this.maxItemsToReadAtOnce <= 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer.", MAX_ITEMS_TO_READ_AT_ONCE));
        }
        long minReadTimeoutMillis = properties.getLong(MIN_READ_TIMEOUT_MILLIS);
        long maxReadTimeoutMillis = properties.getLong(MAX_READ_TIMEOUT_MILLIS);
        if (minReadTimeoutMillis < 0L) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer.", MIN_READ_TIMEOUT_MILLIS));
        }
        if (minReadTimeoutMillis > maxReadTimeoutMillis) {
            throw new ConfigurationException(String.format("Property '%s' must be smaller than or equal to '%s'.", MIN_READ_TIMEOUT_MILLIS, MAX_READ_TIMEOUT_MILLIS));
        }
        this.minReadTimeout = Duration.ofMillis(minReadTimeoutMillis);
        this.maxReadTimeout = Duration.ofMillis(maxReadTimeoutMillis);
        this.errorSleepDuration = Duration.ofMillis(properties.getLong(ERROR_SLEEP_MILLIS));
        this.flushTimeout = Duration.ofMillis(properties.getLong(FLUSH_TIMEOUT_MILLIS));
        this.ackTimeout = Duration.ofMillis(properties.getLong(ACK_TIMEOUT_MILLIS));
        this.shutdownTimeout = Duration.ofMillis(properties.getLong(SHUTDOWN_TIMEOUT_MILLIS));
        this.maxRolloverSize = Math.max(0L, properties.getLong(MAX_ROLLOVER_SIZE));
    }

    public static ConfigBuilder<WriterConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, WriterConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getFlushThresholdBytes() {
        return this.flushThresholdBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getFlushThresholdTime() {
        return this.flushThresholdTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getFlushAttributesThreshold() {
        return this.flushAttributesThreshold;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxFlushSizeBytes() {
        return this.maxFlushSizeBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxItemsToReadAtOnce() {
        return this.maxItemsToReadAtOnce;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getMinReadTimeout() {
        return this.minReadTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getMaxReadTimeout() {
        return this.maxReadTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getErrorSleepDuration() {
        return this.errorSleepDuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getFlushTimeout() {
        return this.flushTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getAckTimeout() {
        return this.ackTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMaxRolloverSize() {
        return this.maxRolloverSize;
    }
}

