/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.writer;

import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.logs.operations.Operation;
import java.time.Duration;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;

interface WriterDataSource {
    public int getId();

    public CompletableFuture<Void> acknowledge(long var1, Duration var3);

    public CompletableFuture<Long> persistAttributes(long var1, Map<AttributeId, Long> var3, Duration var4);

    public CompletableFuture<Void> notifyAttributesPersisted(long var1, SegmentType var3, long var4, long var6, Duration var8);

    public CompletableFuture<Void> sealAttributes(long var1, Duration var3);

    public CompletableFuture<Void> deleteAllAttributes(SegmentMetadata var1, Duration var2);

    public CompletableFuture<Queue<Operation>> read(int var1, Duration var2);

    public void completeMerge(long var1, long var3) throws StreamSegmentNotExistsException;

    public BufferView getAppendData(long var1, long var3, int var5);

    public boolean isValidTruncationPoint(long var1);

    public long getClosestValidTruncationPoint(long var1);

    public UpdateableSegmentMetadata getStreamSegmentMetadata(long var1);
}

