/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.writer;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.AbstractTimer;
import io.pravega.segmentstore.server.WriterFlushResult;
import io.pravega.segmentstore.server.logs.operations.Operation;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;

class WriterState {
    private final AtomicLong lastReadSequenceNumber = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong lastTruncatedSequenceNumber = new AtomicLong(Long.MIN_VALUE);
    private final AtomicBoolean lastIterationError = new AtomicBoolean(false);
    private final AtomicReference<Duration> currentIterationStartTime = new AtomicReference();
    private final AtomicLong iterationId;
    private final AtomicReference<ForceFlushContext> forceFlushContext = new AtomicReference();
    private final AtomicReference<Queue<Operation>> lastRead;

    WriterState() {
        this.iterationId = new AtomicLong();
        this.lastRead = new AtomicReference<Object>(null);
    }

    void recordIterationStarted(AbstractTimer timer) {
        this.iterationId.incrementAndGet();
        this.currentIterationStartTime.set(timer.getElapsed());
        this.lastIterationError.set(false);
    }

    Duration getElapsedSinceIterationStart(AbstractTimer timer) {
        return timer.getElapsed().minus(this.currentIterationStartTime.get());
    }

    long getIterationId() {
        return this.iterationId.get();
    }

    boolean getLastIterationError() {
        return this.lastIterationError.get();
    }

    void recordIterationError() {
        this.lastIterationError.set(true);
    }

    long getLastTruncatedSequenceNumber() {
        return this.lastTruncatedSequenceNumber.get();
    }

    void setLastTruncatedSequenceNumber(long value) {
        Preconditions.checkArgument((value >= this.lastTruncatedSequenceNumber.get() ? 1 : 0) != 0, (Object)"New LastTruncatedSequenceNumber cannot be smaller than the previous one.");
        this.lastTruncatedSequenceNumber.set(value);
    }

    long getLastReadSequenceNumber() {
        return this.lastReadSequenceNumber.get();
    }

    void setLastReadSequenceNumber(long value) {
        Preconditions.checkArgument((value >= this.lastReadSequenceNumber.get() ? 1 : 0) != 0, (Object)"New LastReadSequenceNumber cannot be smaller than the previous one.");
        this.lastReadSequenceNumber.set(value);
        this.recordReadComplete();
    }

    void recordReadComplete() {
        ForceFlushContext ffc = this.forceFlushContext.get();
        if (ffc != null) {
            ffc.setLastReadSequenceNumber(this.lastReadSequenceNumber.get());
        }
    }

    void recordFlushComplete(WriterFlushResult result) {
        ForceFlushContext ffc = this.forceFlushContext.get();
        if (ffc != null && ffc.flushComplete(result)) {
            this.forceFlushContext.set(null);
            ffc.getCompletion().complete(ffc.isAnythingFlushed());
        }
    }

    CompletableFuture<Boolean> setForceFlush(long upToSequenceNumber) {
        if (upToSequenceNumber <= this.getLastTruncatedSequenceNumber()) {
            return CompletableFuture.completedFuture(false);
        }
        ForceFlushContext context = new ForceFlushContext(upToSequenceNumber);
        Preconditions.checkState((boolean)this.forceFlushContext.compareAndSet(null, context), (Object)"Another force-flush is in progress.");
        return context.getCompletion();
    }

    boolean isForceFlush() {
        return this.forceFlushContext.get() != null;
    }

    Queue<Operation> getLastRead() {
        Queue<Operation> result = this.lastRead.get();
        if (result != null && result.isEmpty()) {
            this.lastRead.compareAndSet(result, null);
            return null;
        }
        return result;
    }

    Queue<Operation> setLastRead(Queue<Operation> lastRead) {
        this.lastRead.set(lastRead);
        return lastRead;
    }

    public String toString() {
        return String.format("LastRead=%s, LastTruncate=%s, Error=%s", this.lastReadSequenceNumber, this.lastTruncatedSequenceNumber, this.lastIterationError);
    }

    private static class ForceFlushContext {
        private final long upToSequenceNumber;
        @GuardedBy(value="this")
        private long lastReadSequenceNumber = Long.MIN_VALUE;
        @GuardedBy(value="this")
        private boolean anythingFlushed = false;
        private final CompletableFuture<Boolean> completion = new CompletableFuture();

        synchronized void setLastReadSequenceNumber(long lastReadSequenceNumber) {
            this.lastReadSequenceNumber = lastReadSequenceNumber;
        }

        synchronized boolean isAnythingFlushed() {
            return this.anythingFlushed;
        }

        synchronized boolean flushComplete(WriterFlushResult result) {
            if (this.lastReadSequenceNumber != Long.MIN_VALUE && result.isAnythingFlushed()) {
                this.anythingFlushed = true;
            }
            return this.lastReadSequenceNumber >= this.upToSequenceNumber;
        }

        @ConstructorProperties(value={"upToSequenceNumber"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ForceFlushContext(long upToSequenceNumber) {
            this.upToSequenceNumber = upToSequenceNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CompletableFuture<Boolean> getCompletion() {
            return this.completion;
        }
    }
}

