/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.extendeds3;

import com.emc.object.Range;
import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3Exception;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.CopyPartResult;
import com.emc.object.s3.bean.MultipartPartETag;
import com.emc.object.s3.bean.Permission;
import com.emc.object.s3.request.AbortMultipartUploadRequest;
import com.emc.object.s3.request.CompleteMultipartUploadRequest;
import com.emc.object.s3.request.CopyPartRequest;
import com.emc.object.s3.request.PutObjectRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.StreamHelpers;
import io.pravega.segmentstore.storage.chunklayer.BaseChunkStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkAlreadyExistsException;
import io.pravega.segmentstore.storage.chunklayer.ChunkHandle;
import io.pravega.segmentstore.storage.chunklayer.ChunkInfo;
import io.pravega.segmentstore.storage.chunklayer.ChunkNotFoundException;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageException;
import io.pravega.segmentstore.storage.chunklayer.ConcatArgument;
import io.pravega.segmentstore.storage.chunklayer.InvalidOffsetException;
import io.pravega.storage.extendeds3.ExtendedS3StorageConfig;
import java.io.InputStream;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedS3ChunkStorage
extends BaseChunkStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtendedS3ChunkStorage.class);
    private final ExtendedS3StorageConfig config;
    private final S3Client client;
    private final boolean shouldClose;
    private final AtomicBoolean closed;
    private final boolean supportsAppend;

    public ExtendedS3ChunkStorage(S3Client client, ExtendedS3StorageConfig config, Executor executor, boolean supportsAppend, boolean shouldClose) {
        super(executor);
        this.config = (ExtendedS3StorageConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.client = (S3Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.closed = new AtomicBoolean(false);
        this.shouldClose = shouldClose;
        this.supportsAppend = supportsAppend;
    }

    public boolean supportsConcat() {
        return true;
    }

    public boolean supportsAppend() {
        return this.supportsAppend;
    }

    public boolean supportsTruncation() {
        return false;
    }

    protected ChunkHandle doOpenRead(String chunkName) throws ChunkStorageException {
        if (!this.checkExists(chunkName)) {
            throw new ChunkNotFoundException(chunkName, "doOpenRead");
        }
        return ChunkHandle.readHandle((String)chunkName);
    }

    protected ChunkHandle doOpenWrite(String chunkName) throws ChunkStorageException {
        if (!this.checkExists(chunkName)) {
            throw new ChunkNotFoundException(chunkName, "doOpenWrite");
        }
        return new ChunkHandle(chunkName, false);
    }

    protected int doRead(ChunkHandle handle, long fromOffset, int length, byte[] buffer, int bufferOffset) throws ChunkStorageException {
        int n;
        block9: {
            InputStream reader = this.client.readObjectStream(this.config.getBucket(), this.getObjectPath(handle.getChunkName()), Range.fromOffsetLength((long)fromOffset, (long)length));
            try {
                int bytesRead;
                if (reader == null) {
                    throw new ChunkNotFoundException(handle.getChunkName(), "doRead");
                }
                n = bytesRead = StreamHelpers.readAll((InputStream)reader, (byte[])buffer, (int)bufferOffset, (int)length);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.convertException(handle.getChunkName(), "doRead", e);
                }
            }
            reader.close();
        }
        return n;
    }

    protected int doWrite(ChunkHandle handle, long offset, int length, InputStream data) throws ChunkStorageException {
        Preconditions.checkState((boolean)this.supportsAppend, (Object)"supportsAppend is false.");
        try {
            String objectPath = this.getObjectPath(handle.getChunkName());
            S3ObjectMetadata metadata = this.client.getObjectMetadata(this.config.getBucket(), objectPath);
            if (metadata.getContentLength() != offset) {
                throw new InvalidOffsetException(handle.getChunkName(), metadata.getContentLength().longValue(), offset, "doWrite");
            }
            this.client.putObject(this.config.getBucket(), objectPath, Range.fromOffsetLength((long)offset, (long)length), (Object)data);
            return length;
        }
        catch (Exception e) {
            throw this.convertException(handle.getChunkName(), "doWrite", e);
        }
    }

    public int doConcat(ConcatArgument[] chunks) throws ChunkStorageException {
        int totalBytesConcatenated = 0;
        String targetPath = this.getObjectPath(chunks[0].getName());
        String uploadId = null;
        boolean isCompleted = false;
        try {
            int partNumber = 1;
            TreeSet<MultipartPartETag> partEtags = new TreeSet<MultipartPartETag>();
            uploadId = this.client.initiateMultipartUpload(this.config.getBucket(), targetPath);
            if (!this.checkExists(chunks[0].getName())) {
                throw new ChunkNotFoundException(chunks[0].getName(), "doConcat - Target segment does not exist");
            }
            for (int i = 0; i < chunks.length; ++i) {
                if (0L == chunks[i].getLength()) continue;
                ConcatArgument sourceHandle = chunks[i];
                S3ObjectMetadata metadataResult = this.client.getObjectMetadata(this.config.getBucket(), this.getObjectPath(sourceHandle.getName()));
                long objectSize = metadataResult.getContentLength();
                Preconditions.checkState((objectSize >= chunks[i].getLength() ? 1 : 0) != 0);
                CopyPartRequest copyRequest = new CopyPartRequest(this.config.getBucket(), this.getObjectPath(sourceHandle.getName()), this.config.getBucket(), targetPath, uploadId, partNumber++).withSourceRange(Range.fromOffsetLength((long)0L, (long)chunks[i].getLength()));
                CopyPartResult copyResult = this.client.copyPart(copyRequest);
                partEtags.add(new MultipartPartETag(copyResult.getPartNumber(), copyResult.getETag()));
                totalBytesConcatenated = (int)((long)totalBytesConcatenated + chunks[i].getLength());
            }
            this.client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.config.getBucket(), targetPath, uploadId).withParts(partEtags));
            isCompleted = true;
        }
        catch (RuntimeException e) {
            throw this.convertException(chunks[0].getName(), "doConcat", e);
        }
        catch (Exception e) {
            throw this.convertException(chunks[0].getName(), "doConcat", e);
        }
        finally {
            if (!isCompleted && null != uploadId) {
                this.client.abortMultipartUpload(new AbortMultipartUploadRequest(this.config.getBucket(), targetPath, uploadId));
            }
        }
        return totalBytesConcatenated;
    }

    protected void doSetReadOnly(ChunkHandle handle, boolean isReadOnly) throws ChunkStorageException {
        try {
            this.setPermission(handle, isReadOnly ? Permission.READ : Permission.FULL_CONTROL);
        }
        catch (Exception e) {
            throw this.convertException(handle.getChunkName(), "doSetReadOnly", e);
        }
    }

    private void setPermission(ChunkHandle handle, Permission permission) {
        throw new UnsupportedOperationException("ExtendedS3ChunkStorage does not support ACL");
    }

    protected ChunkInfo doGetInfo(String chunkName) throws ChunkStorageException {
        try {
            S3ObjectMetadata result = this.client.getObjectMetadata(this.config.getBucket(), this.getObjectPath(chunkName));
            ChunkInfo information = ChunkInfo.builder().name(chunkName).length(result.getContentLength().longValue()).build();
            return information;
        }
        catch (Exception e) {
            throw this.convertException(chunkName, "doGetInfo", e);
        }
    }

    protected ChunkHandle doCreate(String chunkName) throws ChunkStorageException {
        Preconditions.checkState((boolean)this.supportsAppend, (Object)"supportsAppend is false.");
        try {
            if (!this.client.listObjects(this.config.getBucket(), this.getObjectPath(chunkName)).getObjects().isEmpty()) {
                throw new ChunkAlreadyExistsException(chunkName, "Chunk already exists");
            }
            S3ObjectMetadata metadata = new S3ObjectMetadata();
            metadata.setContentLength(Long.valueOf(0L));
            PutObjectRequest request = new PutObjectRequest(this.config.getBucket(), this.getObjectPath(chunkName), null).withObjectMetadata(metadata);
            if (this.config.isUseNoneMatch()) {
                request.setIfNoneMatch("*");
            }
            this.client.putObject(request);
            return ChunkHandle.writeHandle((String)chunkName);
        }
        catch (Exception e) {
            throw this.convertException(chunkName, "doCreate", e);
        }
    }

    protected ChunkHandle doCreateWithContent(String chunkName, int length, InputStream data) throws ChunkStorageException {
        try {
            String objectPath = this.getObjectPath(chunkName);
            S3ObjectMetadata metadata = new S3ObjectMetadata().withContentType("application/octet-stream").withContentLength(length);
            PutObjectRequest request = new PutObjectRequest(this.config.getBucket(), objectPath, (Object)data).withObjectMetadata(metadata);
            this.client.putObject(request);
            return ChunkHandle.writeHandle((String)chunkName);
        }
        catch (Exception e) {
            throw this.convertException(chunkName, "doCreateWithContent", e);
        }
    }

    protected boolean checkExists(String chunkName) throws ChunkStorageException {
        try {
            this.client.getObjectMetadata(this.config.getBucket(), this.getObjectPath(chunkName));
            return true;
        }
        catch (S3Exception e) {
            if (e.getErrorCode().equals("NoSuchKey")) {
                return false;
            }
            throw this.convertException(chunkName, "checkExists", (Exception)((Object)e));
        }
    }

    protected void doDelete(ChunkHandle handle) throws ChunkStorageException {
        try {
            if (!this.checkExists(handle.getChunkName())) {
                throw new ChunkNotFoundException(handle.getChunkName(), "doDelete");
            }
            this.client.deleteObject(this.config.getBucket(), this.getObjectPath(handle.getChunkName()));
        }
        catch (Exception e) {
            throw this.convertException(handle.getChunkName(), "doDelete", e);
        }
    }

    public void close() {
        if (this.shouldClose && !this.closed.getAndSet(true)) {
            this.client.destroy();
        }
        super.close();
    }

    private ChunkStorageException convertException(String chunkName, String message, Exception e) {
        ChunkStorageException retValue = null;
        if (e instanceof ChunkStorageException) {
            return (ChunkStorageException)e;
        }
        if (e instanceof S3Exception) {
            S3Exception s3Exception = (S3Exception)((Object)e);
            String errorCode = Strings.nullToEmpty((String)s3Exception.getErrorCode());
            if (errorCode.equals("NoSuchKey")) {
                retValue = new ChunkNotFoundException(chunkName, message, (Throwable)e);
            }
            if (errorCode.equals("PreconditionFailed")) {
                retValue = new ChunkAlreadyExistsException(chunkName, message, (Throwable)e);
            }
            if (errorCode.equals("InvalidRange") || errorCode.equals("InvalidArgument") || errorCode.equals("MethodNotAllowed") || s3Exception.getHttpCode() == 416) {
                throw new IllegalArgumentException(chunkName, e);
            }
            if (errorCode.equals("AccessDenied")) {
                retValue = new ChunkStorageException(chunkName, String.format("Access denied for chunk %s - %s.", chunkName, message), (Throwable)e);
            }
        }
        if (retValue == null) {
            retValue = new ChunkStorageException(chunkName, message, (Throwable)e);
        }
        return retValue;
    }

    private String getObjectPath(String objectName) {
        return this.config.getPrefix() + objectName;
    }
}

