/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.extendeds3;

import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3Config;
import com.emc.object.s3.jersey.S3JerseyClient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.SimpleStorageFactory;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.segmentstore.storage.metadata.ChunkMetadataStore;
import io.pravega.storage.extendeds3.ExtendedS3ChunkStorage;
import io.pravega.storage.extendeds3.ExtendedS3StorageConfig;
import java.beans.ConstructorProperties;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import lombok.NonNull;

public class ExtendedS3SimpleStorageFactory
implements SimpleStorageFactory {
    @NonNull
    private final ChunkedSegmentStorageConfig chunkedSegmentStorageConfig;
    @NonNull
    private final ExtendedS3StorageConfig config;
    @NonNull
    private final ScheduledExecutorService executor;

    public Storage createStorageAdapter(int containerId, ChunkMetadataStore metadataStore) {
        ChunkedSegmentStorage chunkedSegmentStorage = new ChunkedSegmentStorage(containerId, (ChunkStorage)new ExtendedS3ChunkStorage(this.createS3Client(), this.config, this.executor, true, true), metadataStore, this.executor, this.chunkedSegmentStorageConfig);
        return chunkedSegmentStorage;
    }

    public Storage createStorageAdapter() {
        throw new UnsupportedOperationException("SimpleStorageFactory requires ChunkMetadataStore");
    }

    private S3Client createS3Client() {
        S3Config s3Config = new S3Config(this.config.getS3Config());
        S3JerseyClient client = new S3JerseyClient(s3Config);
        return client;
    }

    @ConstructorProperties(value={"chunkedSegmentStorageConfig", "config", "executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExtendedS3SimpleStorageFactory(@NonNull ChunkedSegmentStorageConfig chunkedSegmentStorageConfig, @NonNull ExtendedS3StorageConfig config, @NonNull ScheduledExecutorService executor) {
        if (chunkedSegmentStorageConfig == null) {
            throw new NullPointerException("chunkedSegmentStorageConfig is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.chunkedSegmentStorageConfig = chunkedSegmentStorageConfig;
        this.config = config;
        this.executor = executor;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkedSegmentStorageConfig getChunkedSegmentStorageConfig() {
        return this.chunkedSegmentStorageConfig;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }
}

