/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.extendeds3;

import com.emc.object.Range;
import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3Exception;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.AbstractGrantee;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.CanonicalUser;
import com.emc.object.s3.bean.CopyPartResult;
import com.emc.object.s3.bean.Grant;
import com.emc.object.s3.bean.ListObjectsResult;
import com.emc.object.s3.bean.MultipartPartETag;
import com.emc.object.s3.bean.Permission;
import com.emc.object.s3.bean.S3Object;
import com.emc.object.s3.request.CompleteMultipartUploadRequest;
import com.emc.object.s3.request.CopyPartRequest;
import com.emc.object.s3.request.PutObjectRequest;
import com.emc.object.s3.request.SetObjectAclRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.Timer;
import io.pravega.common.io.StreamHelpers;
import io.pravega.common.util.ImmutableDate;
import io.pravega.segmentstore.contracts.BadOffsetException;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.contracts.StreamSegmentExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentInformation;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.storage.extendeds3.ExtendedS3Metrics;
import io.pravega.storage.extendeds3.ExtendedS3SegmentHandle;
import io.pravega.storage.extendeds3.ExtendedS3StorageConfig;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedS3Storage
implements SyncStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtendedS3Storage.class);
    private static final Permission READ_ONLY_PERMISSION = Permission.READ;
    private static final Permission READ_WRITE_PERMISSION = Permission.FULL_CONTROL;
    private final ExtendedS3StorageConfig config;
    private final S3Client client;
    private final boolean shouldClose;
    private final AtomicBoolean closed;

    public ExtendedS3Storage(S3Client client, ExtendedS3StorageConfig config, boolean shouldClose) {
        this.config = (ExtendedS3StorageConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.client = (S3Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.closed = new AtomicBoolean(false);
        this.shouldClose = shouldClose;
    }

    public void initialize(long containerEpoch) {
    }

    public SegmentHandle openRead(String streamSegmentName) throws StreamSegmentException {
        return this.execute(streamSegmentName, () -> this.doOpenRead(streamSegmentName));
    }

    public int read(SegmentHandle handle, long offset, byte[] buffer, int bufferOffset, int length) throws StreamSegmentException {
        return this.execute(handle.getSegmentName(), () -> this.doRead(handle, offset, buffer, bufferOffset, length));
    }

    public SegmentProperties getStreamSegmentInfo(String streamSegmentName) throws StreamSegmentException {
        return (SegmentProperties)this.execute(streamSegmentName, () -> this.doGetStreamSegmentInfo(streamSegmentName));
    }

    public boolean exists(String streamSegmentName) {
        return this.execute(streamSegmentName, () -> this.doExists(streamSegmentName));
    }

    public SegmentHandle openWrite(String streamSegmentName) throws StreamSegmentException {
        return this.execute(streamSegmentName, () -> this.doOpenWrite(streamSegmentName));
    }

    public SegmentHandle create(String streamSegmentName) throws StreamSegmentException {
        return this.execute(streamSegmentName, () -> this.doCreate(streamSegmentName));
    }

    public void write(SegmentHandle handle, long offset, InputStream data, int length) throws StreamSegmentException {
        this.execute(handle.getSegmentName(), () -> this.doWrite(handle, offset, data, length));
    }

    public void seal(SegmentHandle handle) throws StreamSegmentException {
        this.execute(handle.getSegmentName(), () -> this.doSeal(handle));
    }

    public void unseal(SegmentHandle handle) throws StreamSegmentException {
        this.execute(handle.getSegmentName(), () -> this.doUnseal(handle));
    }

    public void concat(SegmentHandle targetHandle, long offset, String sourceSegment) throws StreamSegmentException {
        this.execute(targetHandle.getSegmentName(), () -> this.doConcat(targetHandle, offset, sourceSegment));
    }

    public void delete(SegmentHandle handle) throws StreamSegmentException {
        this.execute(handle.getSegmentName(), () -> this.doDelete(handle));
    }

    public void truncate(SegmentHandle handle, long offset) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support Segment truncation.");
    }

    public boolean supportsTruncation() {
        return false;
    }

    private SegmentHandle doOpenRead(String streamSegmentName) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"openRead", (Object[])new Object[]{streamSegmentName});
        this.doGetStreamSegmentInfo(streamSegmentName);
        ExtendedS3SegmentHandle retHandle = ExtendedS3SegmentHandle.getReadHandle(streamSegmentName);
        LoggerHelpers.traceLeave((Logger)log, (String)"openRead", (long)traceId, (Object[])new Object[]{streamSegmentName});
        return retHandle;
    }

    private SegmentHandle doOpenWrite(String streamSegmentName) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"openWrite", (Object[])new Object[]{streamSegmentName});
        StreamSegmentInformation info = this.doGetStreamSegmentInfo(streamSegmentName);
        ExtendedS3SegmentHandle retHandle = info.isSealed() ? ExtendedS3SegmentHandle.getReadHandle(streamSegmentName) : ExtendedS3SegmentHandle.getWriteHandle(streamSegmentName);
        LoggerHelpers.traceLeave((Logger)log, (String)"openWrite", (long)traceId, (Object[])new Object[0]);
        return retHandle;
    }

    private int doRead(SegmentHandle handle, long offset, byte[] buffer, int bufferOffset, int length) throws Exception {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"read", (Object[])new Object[]{handle.getSegmentName(), offset, bufferOffset, length});
        Timer timer = new Timer();
        if (offset < 0L || bufferOffset < 0 || length < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try (InputStream reader = this.client.readObjectStream(this.config.getBucket(), this.config.getPrefix() + handle.getSegmentName(), Range.fromOffsetLength((long)offset, (long)length));){
            if (reader == null) {
                throw new StreamSegmentNotExistsException(handle.getSegmentName());
            }
            int bytesRead = StreamHelpers.readAll((InputStream)reader, (byte[])buffer, (int)bufferOffset, (int)length);
            Duration elapsed = timer.getElapsed();
            ExtendedS3Metrics.READ_LATENCY.reportSuccessEvent(elapsed);
            ExtendedS3Metrics.READ_BYTES.add((long)length);
            log.debug("Read segment={} offset={} bytesWritten={} latency={}.", new Object[]{handle.getSegmentName(), offset, length, elapsed.toMillis()});
            LoggerHelpers.traceLeave((Logger)log, (String)"read", (long)traceId, (Object[])new Object[]{bytesRead});
            int n = bytesRead;
            return n;
        }
    }

    private StreamSegmentInformation doGetStreamSegmentInfo(String streamSegmentName) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getStreamSegmentInfo", (Object[])new Object[]{streamSegmentName});
        S3ObjectMetadata result = this.client.getObjectMetadata(this.config.getBucket(), this.config.getPrefix() + streamSegmentName);
        AccessControlList acls = this.client.getObjectAcl(this.config.getBucket(), this.config.getPrefix() + streamSegmentName);
        boolean canWrite = acls.getGrants().stream().anyMatch(grant -> grant.getPermission().compareTo((Enum)Permission.WRITE) >= 0);
        StreamSegmentInformation information = StreamSegmentInformation.builder().name(streamSegmentName).length(result.getContentLength().longValue()).sealed(!canWrite).lastModified(new ImmutableDate(result.getLastModified().toInstant().toEpochMilli())).build();
        LoggerHelpers.traceLeave((Logger)log, (String)"getStreamSegmentInfo", (long)traceId, (Object[])new Object[]{streamSegmentName});
        return information;
    }

    private boolean doExists(String streamSegmentName) {
        try {
            this.client.getObjectMetadata(this.config.getBucket(), this.config.getPrefix() + streamSegmentName);
            return true;
        }
        catch (S3Exception e) {
            if (e.getErrorCode().equals("NoSuchKey")) {
                return false;
            }
            throw e;
        }
    }

    private SegmentHandle doCreate(String streamSegmentName) throws StreamSegmentExistsException {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"create", (Object[])new Object[]{streamSegmentName});
        Timer timer = new Timer();
        if (!this.client.listObjects(this.config.getBucket(), this.config.getPrefix() + streamSegmentName).getObjects().isEmpty()) {
            throw new StreamSegmentExistsException(streamSegmentName);
        }
        S3ObjectMetadata metadata = new S3ObjectMetadata();
        metadata.setContentLength(Long.valueOf(0L));
        PutObjectRequest request = new PutObjectRequest(this.config.getBucket(), this.config.getPrefix() + streamSegmentName, null);
        AccessControlList acl = new AccessControlList();
        acl.addGrants(new Grant[]{new Grant((AbstractGrantee)new CanonicalUser(this.config.getAccessKey(), this.config.getAccessKey()), READ_WRITE_PERMISSION)});
        request.setAcl(acl);
        if (this.config.isUseNoneMatch()) {
            request.setIfNoneMatch("*");
        }
        this.client.putObject(request);
        Duration elapsed = timer.getElapsed();
        ExtendedS3Metrics.CREATE_LATENCY.reportSuccessEvent(elapsed);
        ExtendedS3Metrics.CREATE_COUNT.inc();
        log.debug("Create segment={} latency={}.", (Object)streamSegmentName, (Object)elapsed.toMillis());
        LoggerHelpers.traceLeave((Logger)log, (String)"create", (long)traceId, (Object[])new Object[0]);
        return ExtendedS3SegmentHandle.getWriteHandle(streamSegmentName);
    }

    private Void doWrite(SegmentHandle handle, long offset, InputStream data, int length) throws StreamSegmentException {
        Preconditions.checkArgument((!handle.isReadOnly() ? 1 : 0) != 0, (Object)"handle must not be read-only.");
        Timer timer = new Timer();
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"write", (Object[])new Object[]{handle.getSegmentName(), offset, length});
        StreamSegmentInformation si = this.doGetStreamSegmentInfo(handle.getSegmentName());
        if (si.isSealed()) {
            throw new StreamSegmentSealedException(handle.getSegmentName());
        }
        if (si.getLength() != offset) {
            throw new BadOffsetException(handle.getSegmentName(), si.getLength(), offset);
        }
        this.client.putObject(this.config.getBucket(), this.config.getPrefix() + handle.getSegmentName(), Range.fromOffsetLength((long)offset, (long)length), (Object)data);
        Duration elapsed = timer.getElapsed();
        ExtendedS3Metrics.WRITE_LATENCY.reportSuccessEvent(elapsed);
        ExtendedS3Metrics.WRITE_BYTES.add((long)length);
        log.debug("Write segment={} offset={} bytesWritten={} latency={}.", new Object[]{handle.getSegmentName(), offset, length, elapsed.toMillis()});
        LoggerHelpers.traceLeave((Logger)log, (String)"write", (long)traceId, (Object[])new Object[0]);
        return null;
    }

    private Void doSeal(SegmentHandle handle) {
        Preconditions.checkArgument((!handle.isReadOnly() ? 1 : 0) != 0, (Object)"handle must not be read-only.");
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"seal", (Object[])new Object[]{handle.getSegmentName()});
        this.setPermission(handle, READ_ONLY_PERMISSION);
        LoggerHelpers.traceLeave((Logger)log, (String)"seal", (long)traceId, (Object[])new Object[0]);
        return null;
    }

    private Void doUnseal(SegmentHandle handle) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"unseal", (Object[])new Object[]{handle.getSegmentName()});
        this.setPermission(handle, READ_WRITE_PERMISSION);
        LoggerHelpers.traceLeave((Logger)log, (String)"unseal", (long)traceId, (Object[])new Object[0]);
        return null;
    }

    private void setPermission(SegmentHandle handle, Permission permission) {
        AccessControlList acl = this.client.getObjectAcl(this.config.getBucket(), this.config.getPrefix() + handle.getSegmentName());
        acl.getGrants().clear();
        acl.addGrants(new Grant[]{new Grant((AbstractGrantee)new CanonicalUser(this.config.getAccessKey(), this.config.getAccessKey()), permission)});
        this.client.setObjectAcl(new SetObjectAclRequest(this.config.getBucket(), this.config.getPrefix() + handle.getSegmentName()).withAcl(acl));
    }

    private Void doConcat(SegmentHandle targetHandle, long offset, String sourceSegment) throws Exception {
        Preconditions.checkArgument((!targetHandle.isReadOnly() ? 1 : 0) != 0, (Object)"target handle must not be read-only.");
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"concat", (Object[])new Object[]{targetHandle.getSegmentName(), offset, sourceSegment});
        Timer timer = new Timer();
        String targetPath = this.config.getPrefix() + targetHandle.getSegmentName();
        if (!this.doExists(targetHandle.getSegmentName())) {
            throw new StreamSegmentNotExistsException(targetHandle.getSegmentName());
        }
        StreamSegmentInformation si = this.doGetStreamSegmentInfo(sourceSegment);
        String sourcePath = this.config.getPrefix() + sourceSegment;
        Preconditions.checkState((boolean)si.isSealed(), (String)"Cannot concat segment '%s' into '%s' because it is not sealed.", (Object)sourceSegment, (Object)targetHandle.getSegmentName());
        if ((long)this.config.getSmallObjectSizeLimitForConcat() < si.getLength()) {
            this.doConcatWithMultipartUpload(targetPath, sourceSegment, offset);
            ExtendedS3Metrics.LARGE_CONCAT_COUNT.inc();
        } else {
            this.doConcatWithAppend(targetPath, sourcePath, offset, si.getLength());
        }
        this.client.deleteObject(this.config.getBucket(), sourcePath);
        Duration elapsed = timer.getElapsed();
        log.debug("Concat target={} source={} offset={} bytesWritten={} latency={}.", new Object[]{targetHandle.getSegmentName(), sourceSegment, offset, si.getLength(), elapsed.toMillis()});
        ExtendedS3Metrics.CONCAT_LATENCY.reportSuccessEvent(elapsed);
        ExtendedS3Metrics.CONCAT_BYTES.add(si.getLength());
        ExtendedS3Metrics.CONCAT_COUNT.inc();
        LoggerHelpers.traceLeave((Logger)log, (String)"concat", (long)traceId, (Object[])new Object[0]);
        return null;
    }

    private void doConcatWithAppend(String targetPath, String sourcePath, long offset, long length) throws Exception {
        try (InputStream reader = this.client.readObjectStream(this.config.getBucket(), sourcePath, Range.fromOffsetLength((long)0L, (long)length));){
            this.client.putObject(this.config.getBucket(), targetPath, Range.fromOffsetLength((long)offset, (long)length), (Object)new BufferedInputStream(reader, Math.toIntExact(length)));
        }
    }

    private void doConcatWithMultipartUpload(String targetPath, String sourceSegment, long offset) {
        String uploadId = this.client.initiateMultipartUpload(this.config.getBucket(), targetPath);
        TreeSet<MultipartPartETag> partEtags = new TreeSet<MultipartPartETag>();
        CopyPartRequest copyRequest = new CopyPartRequest(this.config.getBucket(), targetPath, this.config.getBucket(), targetPath, uploadId, 1).withSourceRange(Range.fromOffsetLength((long)0L, (long)offset));
        CopyPartResult copyResult = this.client.copyPart(copyRequest);
        partEtags.add(new MultipartPartETag(copyResult.getPartNumber(), copyResult.getETag()));
        S3ObjectMetadata metadataResult = this.client.getObjectMetadata(this.config.getBucket(), this.config.getPrefix() + sourceSegment);
        long objectSize = metadataResult.getContentLength();
        copyRequest = new CopyPartRequest(this.config.getBucket(), this.config.getPrefix() + sourceSegment, this.config.getBucket(), targetPath, uploadId, 2).withSourceRange(Range.fromOffsetLength((long)0L, (long)objectSize));
        copyResult = this.client.copyPart(copyRequest);
        partEtags.add(new MultipartPartETag(copyResult.getPartNumber(), copyResult.getETag()));
        this.client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.config.getBucket(), targetPath, uploadId).withParts(partEtags));
    }

    private Void doDelete(SegmentHandle handle) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"delete", (Object[])new Object[]{handle.getSegmentName()});
        Timer timer = new Timer();
        this.client.deleteObject(this.config.getBucket(), this.config.getPrefix() + handle.getSegmentName());
        Duration elapsed = timer.getElapsed();
        ExtendedS3Metrics.DELETE_LATENCY.reportSuccessEvent(elapsed);
        ExtendedS3Metrics.DELETE_COUNT.inc();
        log.debug("Delete segment={} latency={}.", (Object)handle.getSegmentName(), (Object)elapsed.toMillis());
        LoggerHelpers.traceLeave((Logger)log, (String)"delete", (long)traceId, (Object[])new Object[0]);
        return null;
    }

    private <T> T throwException(String segmentName, Exception e) throws StreamSegmentException {
        if (e instanceof S3Exception) {
            S3Exception s3Exception = (S3Exception)((Object)e);
            String errorCode = Strings.nullToEmpty((String)s3Exception.getErrorCode());
            if (errorCode.equals("NoSuchKey")) {
                throw new StreamSegmentNotExistsException(segmentName);
            }
            if (errorCode.equals("PreconditionFailed")) {
                throw new StreamSegmentExistsException(segmentName);
            }
            if (errorCode.equals("InvalidRange") || errorCode.equals("InvalidArgument") || errorCode.equals("MethodNotAllowed") || s3Exception.getHttpCode() == 416) {
                throw new IllegalArgumentException(segmentName, e);
            }
            if (errorCode.equals("AccessDenied")) {
                throw new StreamSegmentSealedException(segmentName, (Throwable)e);
            }
        }
        if (e instanceof IndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage());
        }
        throw Exceptions.sneakyThrow((Throwable)e);
    }

    private <R> R execute(String segmentName, Callable<R> operation) throws StreamSegmentException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        try {
            return operation.call();
        }
        catch (Exception e) {
            return (R)this.throwException(segmentName, e);
        }
    }

    public void close() {
        if (this.shouldClose && !this.closed.getAndSet(true)) {
            this.client.destroy();
        }
    }

    public Iterator<SegmentProperties> listSegments() {
        return new ExtendedS3SegmentIterator(s3object -> true);
    }

    private class ExtendedS3SegmentIterator
    implements Iterator<SegmentProperties> {
        private final Predicate<S3Object> patternMatchPredicate;
        private final ListObjectsResult results;
        private Iterator<SegmentProperties> innerIterator;
        private boolean nextBatch;

        ExtendedS3SegmentIterator(Predicate<S3Object> patternMatchPredicate) {
            this.results = ExtendedS3Storage.this.client.listObjects(ExtendedS3Storage.this.config.getBucket(), ExtendedS3Storage.this.config.getPrefix());
            this.innerIterator = this.results.getObjects().stream().filter(patternMatchPredicate).map(this::toSegmentProperties).iterator();
            this.patternMatchPredicate = patternMatchPredicate;
            this.nextBatch = false;
        }

        public SegmentProperties toSegmentProperties(S3Object s3Object) {
            AccessControlList acls = ExtendedS3Storage.this.client.getObjectAcl(ExtendedS3Storage.this.config.getBucket(), s3Object.getKey());
            boolean canWrite = acls.getGrants().stream().anyMatch(grant -> grant.getPermission().compareTo((Enum)Permission.WRITE) >= 0);
            return StreamSegmentInformation.builder().name(s3Object.getKey().replaceFirst(ExtendedS3Storage.this.config.getPrefix(), "")).length(s3Object.getSize().longValue()).sealed(!canWrite).lastModified(new ImmutableDate(s3Object.getLastModified().toInstant().toEpochMilli())).build();
        }

        @Override
        public boolean hasNext() {
            if (this.innerIterator == null) {
                return false;
            }
            if (this.innerIterator.hasNext()) {
                return true;
            }
            if (this.nextBatch || this.results.getObjects().size() < this.results.getMaxKeys()) {
                return false;
            }
            this.innerIterator = ExtendedS3Storage.this.client.listMoreObjects(this.results).getObjects().stream().filter(this.patternMatchPredicate).map(this::toSegmentProperties).iterator();
            this.nextBatch = true;
            return this.innerIterator.hasNext();
        }

        @Override
        public SegmentProperties next() throws NoSuchElementException {
            return this.innerIterator.next();
        }
    }
}

