/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.extendeds3;

import com.emc.object.s3.S3Config;
import com.emc.object.util.ConfigUri;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedS3StorageConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtendedS3StorageConfig.class);
    public static final Property<String> CONFIGURI = Property.named((String)"connect.config.uri", (Object)"", (String)"configUri");
    public static final Property<String> BUCKET = Property.named((String)"bucket", (Object)"");
    public static final Property<String> PREFIX = Property.named((String)"prefix", (Object)"/");
    public static final Property<Boolean> USENONEMATCH = Property.named((String)"noneMatch.enable", (Object)false, (String)"useNoneMatch");
    public static final Property<Integer> SMALL_OBJECT_THRESHOLD = Property.named((String)"concat.smallObject.threshold.size", (Object)0x100000, (String)"smallObjectSizeLimitForConcat");
    private static final String COMPONENT_CODE = "extendeds3";
    private static final String PATH_SEPARATOR = "/";
    private final S3Config s3Config;
    private final String accessKey;
    private final String secretKey;
    private final String bucket;
    private final String prefix;
    private final boolean useNoneMatch;
    private final int smallObjectSizeLimitForConcat;

    private ExtendedS3StorageConfig(TypedProperties properties) throws ConfigurationException {
        ConfigUri s3ConfigUri = new ConfigUri(S3Config.class);
        this.s3Config = (S3Config)Preconditions.checkNotNull((Object)((S3Config)s3ConfigUri.parseUri(properties.get(CONFIGURI))), (Object)"configUri");
        this.accessKey = (String)Preconditions.checkNotNull((Object)this.s3Config.getIdentity(), (Object)"identity");
        this.secretKey = (String)Preconditions.checkNotNull((Object)this.s3Config.getSecretKey(), (Object)"secretKey");
        this.bucket = (String)Preconditions.checkNotNull((Object)properties.get(BUCKET), (Object)"bucket");
        String givenPrefix = (String)Preconditions.checkNotNull((Object)properties.get(PREFIX), (Object)"prefix");
        this.prefix = givenPrefix.endsWith(PATH_SEPARATOR) ? givenPrefix : givenPrefix + PATH_SEPARATOR;
        this.useNoneMatch = properties.getBoolean(USENONEMATCH);
        this.smallObjectSizeLimitForConcat = properties.getInt(SMALL_OBJECT_THRESHOLD);
    }

    public static ConfigBuilder<ExtendedS3StorageConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, ExtendedS3StorageConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public S3Config getS3Config() {
        return this.s3Config;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAccessKey() {
        return this.accessKey;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getBucket() {
        return this.bucket;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseNoneMatch() {
        return this.useNoneMatch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSmallObjectSizeLimitForConcat() {
        return this.smallObjectSizeLimitForConcat;
    }
}

