/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.extendeds3;

import com.emc.object.s3.S3Client;
import com.emc.object.s3.jersey.S3JerseyClient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.AsyncStorageWrapper;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.segmentstore.storage.rolling.RollingStorage;
import io.pravega.storage.extendeds3.ExtendedS3Storage;
import io.pravega.storage.extendeds3.ExtendedS3StorageConfig;
import java.beans.ConstructorProperties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import lombok.NonNull;

public class ExtendedS3StorageFactory
implements StorageFactory {
    @NonNull
    private final ExtendedS3StorageConfig config;
    @NonNull
    private final ExecutorService executor;

    public Storage createStorageAdapter() {
        return new AsyncStorageWrapper((SyncStorage)new RollingStorage((SyncStorage)this.createS3Storage()), (Executor)this.executor);
    }

    public SyncStorage createSyncStorage() {
        return this.createS3Storage();
    }

    private ExtendedS3Storage createS3Storage() {
        S3JerseyClient client = new S3JerseyClient(this.config.getS3Config());
        return new ExtendedS3Storage((S3Client)client, this.config, true);
    }

    @ConstructorProperties(value={"config", "executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExtendedS3StorageFactory(@NonNull ExtendedS3StorageConfig config, @NonNull ExecutorService executor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.config = config;
        this.executor = executor;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }
}

