/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.extendeds3;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.storage.ConfigSetup;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.StorageFactoryCreator;
import io.pravega.segmentstore.storage.StorageFactoryInfo;
import io.pravega.segmentstore.storage.StorageLayoutType;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.storage.extendeds3.ExtendedS3SimpleStorageFactory;
import io.pravega.storage.extendeds3.ExtendedS3StorageConfig;
import io.pravega.storage.extendeds3.ExtendedS3StorageFactory;
import java.util.concurrent.ScheduledExecutorService;

public class ExtendedS3StorageFactoryCreator
implements StorageFactoryCreator {
    public StorageFactory createFactory(StorageFactoryInfo storageFactoryInfo, ConfigSetup setup, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)storageFactoryInfo, (Object)"storageFactoryInfo");
        Preconditions.checkNotNull((Object)setup, (Object)"setup");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        Preconditions.checkArgument((boolean)storageFactoryInfo.getName().equals("EXTENDEDS3"));
        if (storageFactoryInfo.getStorageLayoutType().equals((Object)StorageLayoutType.CHUNKED_STORAGE)) {
            return new ExtendedS3SimpleStorageFactory((ChunkedSegmentStorageConfig)setup.getConfig(ChunkedSegmentStorageConfig::builder), (ExtendedS3StorageConfig)setup.getConfig(ExtendedS3StorageConfig::builder), executor);
        }
        return new ExtendedS3StorageFactory((ExtendedS3StorageConfig)setup.getConfig(ExtendedS3StorageConfig::builder), executor);
    }

    public StorageFactoryInfo[] getStorageFactories() {
        return new StorageFactoryInfo[]{StorageFactoryInfo.builder().name("EXTENDEDS3").storageLayoutType(StorageLayoutType.CHUNKED_STORAGE).build(), StorageFactoryInfo.builder().name("EXTENDEDS3").storageLayoutType(StorageLayoutType.ROLLING_STORAGE).build()};
    }
}

