/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.filesystem;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.chunklayer.BaseChunkStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkAlreadyExistsException;
import io.pravega.segmentstore.storage.chunklayer.ChunkHandle;
import io.pravega.segmentstore.storage.chunklayer.ChunkInfo;
import io.pravega.segmentstore.storage.chunklayer.ChunkNotFoundException;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageException;
import io.pravega.segmentstore.storage.chunklayer.ConcatArgument;
import io.pravega.segmentstore.storage.chunklayer.InvalidOffsetException;
import io.pravega.storage.filesystem.FileSystemStorageConfig;
import io.pravega.storage.filesystem.FileSystemWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemChunkStorage
extends BaseChunkStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSystemChunkStorage.class);
    private final FileSystemStorageConfig config;
    private final FileSystemWrapper fileSystem;

    public FileSystemChunkStorage(FileSystemStorageConfig config, Executor executor) {
        super(executor);
        this.config = (FileSystemStorageConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.fileSystem = new FileSystemWrapper();
    }

    public FileSystemChunkStorage(FileSystemStorageConfig config, FileSystemWrapper fileSystem, Executor executor) {
        super(executor);
        this.config = (FileSystemStorageConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.fileSystem = (FileSystemWrapper)Preconditions.checkNotNull((Object)fileSystem, (Object)"fileSystem");
    }

    public boolean supportsConcat() {
        return true;
    }

    public boolean supportsAppend() {
        return true;
    }

    public boolean supportsTruncation() {
        return false;
    }

    protected ChunkInfo doGetInfo(String chunkName) throws ChunkStorageException {
        try {
            long chunkSize = this.fileSystem.getFileSize(this.getFilePath(chunkName));
            return ChunkInfo.builder().name(chunkName).length(chunkSize).build();
        }
        catch (IOException e) {
            throw this.convertExeption(chunkName, "doGetInfo", e);
        }
    }

    protected ChunkHandle doCreate(String chunkName) throws ChunkStorageException {
        try {
            FileAttribute<Set<PosixFilePermission>> fileAttributes = PosixFilePermissions.asFileAttribute(FileSystemWrapper.READ_WRITE_PERMISSION);
            Path path = this.getFilePath(chunkName);
            Path parent = path.getParent();
            assert (parent != null);
            this.fileSystem.createDirectories(parent);
            this.fileSystem.createFile(fileAttributes, path);
        }
        catch (IOException e) {
            throw this.convertExeption(chunkName, "doCreate", e);
        }
        return ChunkHandle.writeHandle((String)chunkName);
    }

    protected boolean checkExists(String chunkName) {
        return this.fileSystem.exists(this.getFilePath(chunkName));
    }

    protected void doDelete(ChunkHandle handle) throws ChunkStorageException {
        try {
            this.fileSystem.delete(this.getFilePath(handle.getChunkName()));
        }
        catch (IOException e) {
            throw this.convertExeption(handle.getChunkName(), "doDelete", e);
        }
    }

    protected ChunkHandle doOpenRead(String chunkName) throws ChunkStorageException {
        Path path = this.getFilePath(chunkName);
        if (!this.fileSystem.exists(path)) {
            throw new ChunkNotFoundException(chunkName, "doOpenRead");
        }
        if (!this.fileSystem.isRegularFile(path)) {
            throw new ChunkStorageException(chunkName, "doOpenRead - chunk is not a regular file.");
        }
        return ChunkHandle.readHandle((String)chunkName);
    }

    protected ChunkHandle doOpenWrite(String chunkName) throws ChunkStorageException {
        Path path = this.getFilePath(chunkName);
        if (!this.fileSystem.exists(path)) {
            throw new ChunkNotFoundException(chunkName, "doOpenWrite");
        }
        if (!this.fileSystem.isRegularFile(path)) {
            throw new ChunkStorageException(chunkName, "doOpenWrite - chunk is not a regular file.");
        }
        if (this.fileSystem.isWritable(path)) {
            return ChunkHandle.writeHandle((String)chunkName);
        }
        return ChunkHandle.readHandle((String)chunkName);
    }

    protected int doRead(ChunkHandle handle, long fromOffset, int length, byte[] buffer, int bufferOffset) throws ChunkStorageException, NullPointerException, IndexOutOfBoundsException {
        int n;
        block12: {
            Path path = this.getFilePath(handle.getChunkName());
            try {
                long fileSize = this.fileSystem.getFileSize(path);
                if (fileSize < fromOffset) {
                    throw new IllegalArgumentException(String.format("Reading at offset (%d) which is beyond the current size of chunk (%d).", fromOffset, fileSize));
                }
            }
            catch (IOException e) {
                throw this.convertExeption(handle.getChunkName(), "doRead", e);
            }
            FileChannel channel = this.fileSystem.getFileChannel(path, StandardOpenOption.READ);
            try {
                int bytesRead;
                int totalBytesRead = 0;
                long readOffset = fromOffset;
                do {
                    ByteBuffer readBuffer = ByteBuffer.wrap(buffer, bufferOffset, length);
                    bytesRead = channel.read(readBuffer, readOffset);
                    bufferOffset += bytesRead;
                    totalBytesRead += bytesRead;
                    readOffset += (long)bytesRead;
                } while ((length -= bytesRead) > 0);
                n = totalBytesRead;
                if (channel == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw this.convertExeption(handle.getChunkName(), "doRead", e);
                }
            }
            channel.close();
        }
        return n;
    }

    protected int doWrite(ChunkHandle handle, long offset, int length, InputStream data) throws ChunkStorageException {
        Path path = this.getFilePath(handle.getChunkName());
        long totalBytesWritten = 0L;
        try (FileChannel channel = this.fileSystem.getFileChannel(path, StandardOpenOption.WRITE);){
            long fileSize = channel.size();
            if (fileSize != offset) {
                throw new InvalidOffsetException(handle.getChunkName(), fileSize, offset, "doWrite");
            }
            ReadableByteChannel sourceChannel = Channels.newChannel(data);
            while (length > 0) {
                long bytesWritten = channel.transferFrom(sourceChannel, offset, length);
                assert (bytesWritten > 0L) : "Unable to make any progress transferring data.";
                offset += bytesWritten;
                totalBytesWritten += bytesWritten;
                length = (int)((long)length - bytesWritten);
            }
            channel.force(true);
        }
        catch (IOException e) {
            throw this.convertExeption(handle.getChunkName(), "doWrite", e);
        }
        return (int)totalBytesWritten;
    }

    public int doConcat(ConcatArgument[] chunks) throws ChunkStorageException {
        try {
            int totalBytesConcated = 0;
            Path targetPath = this.getFilePath(chunks[0].getName());
            long offset = chunks[0].getLength();
            try (FileChannel targetChannel = this.fileSystem.getFileChannel(targetPath, StandardOpenOption.WRITE);){
                for (int i = 1; i < chunks.length; ++i) {
                    long length;
                    ConcatArgument source = chunks[i];
                    Preconditions.checkArgument((!chunks[0].getName().equals(source.getName()) ? 1 : 0) != 0, (Object)"target and source can not be same.");
                    Path sourcePath = this.getFilePath(source.getName());
                    Preconditions.checkState((offset <= this.fileSystem.getFileSize(targetPath) ? 1 : 0) != 0);
                    Preconditions.checkState((length <= this.fileSystem.getFileSize(sourcePath) ? 1 : 0) != 0);
                    try (FileChannel sourceChannel = this.fileSystem.getFileChannel(sourcePath, StandardOpenOption.READ);){
                        long bytesTransferred;
                        for (length = chunks[i].getLength(); length > 0L; length -= bytesTransferred) {
                            bytesTransferred = targetChannel.transferFrom(sourceChannel, offset, length);
                            offset += bytesTransferred;
                        }
                        targetChannel.force(true);
                        totalBytesConcated = (int)((long)totalBytesConcated + length);
                        offset += length;
                        continue;
                    }
                }
            }
            return totalBytesConcated;
        }
        catch (IOException e) {
            throw this.convertExeption(chunks[0].getName(), "doConcat", e);
        }
    }

    protected void doSetReadOnly(ChunkHandle handle, boolean isReadOnly) throws ChunkStorageException {
        Path path = null;
        try {
            path = this.getFilePath(handle.getChunkName());
            this.fileSystem.setPermissions(path, isReadOnly ? FileSystemWrapper.READ_ONLY_PERMISSION : FileSystemWrapper.READ_WRITE_PERMISSION);
        }
        catch (IOException e) {
            throw this.convertExeption(path.toString(), "doSetReadOnly", e);
        }
    }

    private ChunkStorageException convertExeption(String chunkName, String message, Exception e) {
        if (e instanceof ChunkStorageException) {
            return (ChunkStorageException)e;
        }
        if (e instanceof FileNotFoundException || e instanceof NoSuchFileException) {
            return new ChunkNotFoundException(chunkName, message, (Throwable)e);
        }
        if (e instanceof FileAlreadyExistsException) {
            return new ChunkAlreadyExistsException(chunkName, message, (Throwable)e);
        }
        return new ChunkStorageException(chunkName, message, (Throwable)e);
    }

    private Path getFilePath(String chunkName) {
        return Paths.get(this.config.getRoot(), chunkName);
    }
}

