/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.AsyncStorageWrapper;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.segmentstore.storage.rolling.RollingStorage;
import io.pravega.storage.filesystem.FileSystemStorage;
import io.pravega.storage.filesystem.FileSystemStorageConfig;
import java.beans.ConstructorProperties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import lombok.NonNull;

public class FileSystemStorageFactory
implements StorageFactory {
    @NonNull
    private final FileSystemStorageConfig config;
    @NonNull
    private final ExecutorService executor;

    public Storage createStorageAdapter() {
        FileSystemStorage s = new FileSystemStorage(this.config);
        return new AsyncStorageWrapper((SyncStorage)new RollingStorage((SyncStorage)s), (Executor)this.executor);
    }

    public SyncStorage createSyncStorage() {
        return new FileSystemStorage(this.config);
    }

    @ConstructorProperties(value={"config", "executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FileSystemStorageFactory(@NonNull FileSystemStorageConfig config, @NonNull ExecutorService executor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.config = config;
        this.executor = executor;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }
}

