/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.filesystem;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.storage.ConfigSetup;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.StorageFactoryCreator;
import io.pravega.segmentstore.storage.StorageFactoryInfo;
import io.pravega.segmentstore.storage.StorageLayoutType;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.storage.filesystem.FileSystemSimpleStorageFactory;
import io.pravega.storage.filesystem.FileSystemStorageConfig;
import io.pravega.storage.filesystem.FileSystemStorageFactory;
import java.util.concurrent.ScheduledExecutorService;

public class FileSystemStorageFactoryCreator
implements StorageFactoryCreator {
    public StorageFactoryInfo[] getStorageFactories() {
        return new StorageFactoryInfo[]{StorageFactoryInfo.builder().name("FILESYSTEM").storageLayoutType(StorageLayoutType.CHUNKED_STORAGE).build(), StorageFactoryInfo.builder().name("FILESYSTEM").storageLayoutType(StorageLayoutType.ROLLING_STORAGE).build()};
    }

    public StorageFactory createFactory(StorageFactoryInfo storageFactoryInfo, ConfigSetup setup, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)storageFactoryInfo, (Object)"storageFactoryInfo");
        Preconditions.checkNotNull((Object)setup, (Object)"setup");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        Preconditions.checkArgument((boolean)storageFactoryInfo.getName().equals("FILESYSTEM"));
        if (storageFactoryInfo.getStorageLayoutType().equals((Object)StorageLayoutType.CHUNKED_STORAGE)) {
            return new FileSystemSimpleStorageFactory((ChunkedSegmentStorageConfig)setup.getConfig(ChunkedSegmentStorageConfig::builder), (FileSystemStorageConfig)setup.getConfig(FileSystemStorageConfig::builder), executor);
        }
        return new FileSystemStorageFactory((FileSystemStorageConfig)setup.getConfig(FileSystemStorageConfig::builder), executor);
    }
}

