/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.filesystem;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public class FileSystemWrapper {
    static final Set<PosixFilePermission> READ_ONLY_PERMISSION = ImmutableSet.of((Object)((Object)PosixFilePermission.OWNER_READ), (Object)((Object)PosixFilePermission.GROUP_READ), (Object)((Object)PosixFilePermission.OTHERS_READ));
    static final Set<PosixFilePermission> READ_WRITE_PERMISSION = ImmutableSet.of((Object)((Object)PosixFilePermission.OWNER_WRITE), (Object)((Object)PosixFilePermission.OWNER_READ), (Object)((Object)PosixFilePermission.GROUP_READ), (Object)((Object)PosixFilePermission.OTHERS_READ));

    Path createFile(FileAttribute<Set<PosixFilePermission>> fileAttributes, Path path) throws IOException {
        return Files.createFile(path, fileAttributes);
    }

    Path createDirectories(Path parent) throws IOException {
        return Files.createDirectories(parent, new FileAttribute[0]);
    }

    void delete(Path path) throws IOException {
        Files.delete(path);
    }

    boolean isRegularFile(Path path) {
        return Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS) && !Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS);
    }

    boolean isWritable(Path path) {
        return Files.isWritable(path);
    }

    boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    FileChannel getFileChannel(Path path, StandardOpenOption openOption) throws IOException {
        return FileChannel.open(path, openOption);
    }

    long getFileSize(Path path) throws IOException {
        return Files.size(path);
    }

    Path setPermissions(Path path, Set<PosixFilePermission> permissions) throws IOException {
        return Files.setPosixFilePermissions(path, permissions);
    }
}

