/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.hdfs;

import io.pravega.common.Exceptions;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.contracts.StreamSegmentExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import java.io.FileNotFoundException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.ipc.RemoteException;

final class HDFSExceptionHelpers {
    HDFSExceptionHelpers() {
    }

    static StreamSegmentException convertException(String segmentName, Throwable e) {
        if (e instanceof RemoteException) {
            e = ((RemoteException)e).unwrapRemoteException();
        }
        if (e instanceof PathNotFoundException || e instanceof FileNotFoundException) {
            return new StreamSegmentNotExistsException(segmentName, e);
        }
        if (e instanceof FileAlreadyExistsException || e instanceof AlreadyBeingCreatedException) {
            return new StreamSegmentExistsException(segmentName, e);
        }
        if (e instanceof AclException) {
            return new StreamSegmentSealedException(segmentName, e);
        }
        throw Exceptions.sneakyThrow((Throwable)e);
    }

    static FileAlreadyExistsException segmentExistsException(String segmentName) {
        return new FileAlreadyExistsException(segmentName);
    }

    static FileNotFoundException segmentNotExistsException(String segmentName) {
        return new FileNotFoundException(segmentName);
    }

    static AclException segmentSealedException(String segmentName) {
        return new AclException(segmentName);
    }
}

