/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.hdfs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.SimpleStorageFactory;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.segmentstore.storage.metadata.ChunkMetadataStore;
import io.pravega.storage.hdfs.HDFSChunkStorage;
import io.pravega.storage.hdfs.HDFSStorageConfig;
import java.beans.ConstructorProperties;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import lombok.NonNull;

public class HDFSSimpleStorageFactory
implements SimpleStorageFactory {
    @NonNull
    private final ChunkedSegmentStorageConfig chunkedSegmentStorageConfig;
    @NonNull
    private final HDFSStorageConfig config;
    @NonNull
    private final ScheduledExecutorService executor;

    public Storage createStorageAdapter(int containerId, ChunkMetadataStore metadataStore) {
        ChunkedSegmentStorage chunkedSegmentStorage = new ChunkedSegmentStorage(containerId, (ChunkStorage)new HDFSChunkStorage(this.config, this.executor), metadataStore, this.executor, this.chunkedSegmentStorageConfig);
        return chunkedSegmentStorage;
    }

    public Storage createStorageAdapter() {
        throw new UnsupportedOperationException("SimpleStorageFactory requires ChunkMetadataStore");
    }

    @ConstructorProperties(value={"chunkedSegmentStorageConfig", "config", "executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HDFSSimpleStorageFactory(@NonNull ChunkedSegmentStorageConfig chunkedSegmentStorageConfig, @NonNull HDFSStorageConfig config, @NonNull ScheduledExecutorService executor) {
        if (chunkedSegmentStorageConfig == null) {
            throw new NullPointerException("chunkedSegmentStorageConfig is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.chunkedSegmentStorageConfig = chunkedSegmentStorageConfig;
        this.config = config;
        this.executor = executor;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkedSegmentStorageConfig getChunkedSegmentStorageConfig() {
        return this.chunkedSegmentStorageConfig;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }
}

