/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.hdfs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.AsyncStorageWrapper;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.segmentstore.storage.rolling.RollingStorage;
import io.pravega.storage.hdfs.HDFSStorage;
import io.pravega.storage.hdfs.HDFSStorageConfig;
import java.beans.ConstructorProperties;
import java.util.concurrent.Executor;
import lombok.Generated;
import lombok.NonNull;

public class HDFSStorageFactory
implements StorageFactory {
    @NonNull
    private final HDFSStorageConfig config;
    @NonNull
    private final Executor executor;

    public Storage createStorageAdapter() {
        HDFSStorage s = new HDFSStorage(this.config);
        return new AsyncStorageWrapper((SyncStorage)new RollingStorage((SyncStorage)s), this.executor);
    }

    public SyncStorage createSyncStorage() {
        return new HDFSStorage(this.config);
    }

    @ConstructorProperties(value={"config", "executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HDFSStorageFactory(@NonNull HDFSStorageConfig config, @NonNull Executor executor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.config = config;
        this.executor = executor;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Executor getExecutor() {
        return this.executor;
    }
}

