/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.hdfs;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.storage.ConfigSetup;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.StorageFactoryCreator;
import io.pravega.segmentstore.storage.StorageFactoryInfo;
import io.pravega.segmentstore.storage.StorageLayoutType;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.storage.hdfs.HDFSSimpleStorageFactory;
import io.pravega.storage.hdfs.HDFSStorageConfig;
import io.pravega.storage.hdfs.HDFSStorageFactory;
import java.util.concurrent.ScheduledExecutorService;

public class HDFSStorageFactoryCreator
implements StorageFactoryCreator {
    public StorageFactoryInfo[] getStorageFactories() {
        return new StorageFactoryInfo[]{StorageFactoryInfo.builder().name("HDFS").storageLayoutType(StorageLayoutType.CHUNKED_STORAGE).build(), StorageFactoryInfo.builder().name("HDFS").storageLayoutType(StorageLayoutType.ROLLING_STORAGE).build()};
    }

    public StorageFactory createFactory(StorageFactoryInfo storageFactoryInfo, ConfigSetup setup, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)storageFactoryInfo, (Object)"storageFactoryInfo");
        Preconditions.checkNotNull((Object)setup, (Object)"setup");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        Preconditions.checkArgument((boolean)storageFactoryInfo.getName().equals("HDFS"));
        if (storageFactoryInfo.getStorageLayoutType().equals((Object)StorageLayoutType.CHUNKED_STORAGE)) {
            return new HDFSSimpleStorageFactory((ChunkedSegmentStorageConfig)setup.getConfig(ChunkedSegmentStorageConfig::builder), (HDFSStorageConfig)setup.getConfig(HDFSStorageConfig::builder), executor);
        }
        return new HDFSStorageFactory((HDFSStorageConfig)setup.getConfig(HDFSStorageConfig::builder), executor);
    }
}

