/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public abstract class BufferViewComparator
implements Comparator<byte[]>,
Serializable {
    public static final byte MIN_VALUE = 0;
    public static final byte MAX_VALUE = -1;
    private static final long serialVersionUID = 1L;
    private static final boolean INTRINSIC_SUPPORTED;

    private BufferViewComparator() {
    }

    public static BufferViewComparator create() {
        return INTRINSIC_SUPPORTED ? new IntrinsicComparator() : new LegacyComparator();
    }

    @Override
    public abstract int compare(byte[] var1, byte[] var2);

    public abstract int compare(byte[] var1, int var2, byte[] var3, int var4, int var5);

    @Override
    public abstract int compare(ArrayView var1, ArrayView var2);

    @Override
    public abstract int compare(BufferView var1, BufferView var2);

    public static byte[] getMinValue() {
        return new byte[]{0};
    }

    public static byte[] getMinValue(int length) {
        byte[] r = new byte[length];
        Arrays.fill(r, 0, r.length, (byte)0);
        return r;
    }

    public static byte[] getMaxValue(int length) {
        byte[] r = new byte[length];
        Arrays.fill(r, 0, r.length, (byte)-1);
        return r;
    }

    public static ArrayView getNextItemOfSameLength(ArrayView array) {
        int maxValue = 255;
        byte[] result = array.getCopy();
        for (int index = result.length - 1; index >= 0; --index) {
            int v = result[index] & 0xFF;
            if (v < 255) {
                result[index] = (byte)(v + 1);
                return new ByteArraySegment(result);
            }
            result[index] = 0;
        }
        return null;
    }

    static {
        boolean intrinsicSupported = true;
        try {
            ByteBuffer bb = ByteBuffer.wrap(new byte[1]);
            bb.mismatch(bb);
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError | UnsatisfiedLinkError e) {
            intrinsicSupported = false;
        }
        INTRINSIC_SUPPORTED = intrinsicSupported;
    }

    @VisibleForTesting
    static class IntrinsicComparator
    extends BufferViewComparator {
        IntrinsicComparator() {
        }

        @Override
        public int compare(byte[] b1, byte[] b2) {
            assert (b1.length == b2.length);
            return this.compare(b1, 0, b2, 0, b1.length);
        }

        @Override
        public int compare(byte[] b1, int offset1, byte[] b2, int offset2, int length) {
            return Arrays.compareUnsigned(b1, offset1, offset1 + length, b2, offset2, offset2 + length);
        }

        @Override
        public int compare(ArrayView b1, ArrayView b2) {
            return Arrays.compareUnsigned(b1.array(), b1.arrayOffset(), b1.arrayOffset() + b1.getLength(), b2.array(), b2.arrayOffset(), b2.arrayOffset() + b2.getLength());
        }

        @Override
        public int compare(BufferView bufferView1, BufferView bufferView2) {
            if (bufferView1 instanceof ArrayView && bufferView2 instanceof ArrayView) {
                return this.compare((ArrayView)bufferView1, (ArrayView)bufferView2);
            }
            if (bufferView1.getLength() == 0) {
                return bufferView2.getLength() > 0 ? -1 : 0;
            }
            if (bufferView2.getLength() == 0) {
                return 1;
            }
            return this.compare(bufferView1.iterateBuffers(), bufferView2.iterateBuffers());
        }

        @Override
        private int compare(Iterator<ByteBuffer> i1, Iterator<ByteBuffer> i2) {
            ByteBuffer b1 = i1.next();
            ByteBuffer b2 = i2.next();
            while (b1 != null && b2 != null) {
                int mismatchIndex = b1.mismatch(b2);
                if (mismatchIndex >= 0 && mismatchIndex < Math.min(b1.remaining(), b2.remaining())) {
                    return Byte.compareUnsigned(b1.get(b1.position() + mismatchIndex), b2.get(b2.position() + mismatchIndex));
                }
                int lengthDiff = b1.remaining() - b2.remaining();
                if (lengthDiff == 0) {
                    b1 = null;
                    b2 = null;
                } else if (lengthDiff < 0) {
                    b1 = null;
                    b2.position(b2.limit() + lengthDiff);
                } else {
                    b1.position(b1.limit() - lengthDiff);
                    b2 = null;
                }
                if (b1 == null && i1.hasNext()) {
                    b1 = i1.next();
                }
                if (b2 != null || !i2.hasNext()) continue;
                b2 = i2.next();
            }
            if (b1 == null) {
                return b2 == null ? 0 : -1;
            }
            return b2 == null ? 1 : 0;
        }
    }

    @VisibleForTesting
    static class LegacyComparator
    extends BufferViewComparator {
        LegacyComparator() {
        }

        @Override
        public int compare(byte[] b1, byte[] b2) {
            assert (b1.length == b2.length);
            return this.compare(b1, 0, b2, 0, b1.length);
        }

        @Override
        public int compare(byte[] b1, int offset1, byte[] b2, int offset2, int length) {
            for (int i = 0; i < length; ++i) {
                int r = (b1[offset1 + i] & 0xFF) - (b2[offset2 + i] & 0xFF);
                if (r == 0) continue;
                return r;
            }
            return 0;
        }

        @Override
        public int compare(ArrayView b1, ArrayView b2) {
            if (b1.getLength() == b2.getLength()) {
                return this.compare(b1.array(), b1.arrayOffset(), b2.array(), b2.arrayOffset(), b1.getLength());
            }
            int len = Math.min(b1.getLength(), b2.getLength());
            int c = this.compare(b1.array(), b1.arrayOffset(), b2.array(), b2.arrayOffset(), len);
            if (c == 0) {
                c = b2.getLength() > b1.getLength() ? -1 : 1;
            }
            return c;
        }

        @Override
        public int compare(BufferView b1, BufferView b2) {
            if (b1 instanceof ArrayView && b2 instanceof ArrayView) {
                return this.compare((ArrayView)b1, (ArrayView)b2);
            }
            BufferView.Reader r1 = b1.getBufferViewReader();
            BufferView.Reader r2 = b2.getBufferViewReader();
            while (r1.available() > 0 && r2.available() > 0) {
                int r = (r1.readByte() & 0xFF) - (r2.readByte() & 0xFF);
                if (r == 0) continue;
                return r;
            }
            if (r1.available() == r2.available()) {
                return 0;
            }
            return r2.available() > 0 ? -1 : 1;
        }
    }
}

