/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

public class PageEntry {
    @NonNull
    private final ByteArraySegment key;
    private final ByteArraySegment value;

    static PageEntry noValue(ByteArraySegment key) {
        return new PageEntry(key, null);
    }

    boolean hasValue() {
        return this.value != null;
    }

    public String toString() {
        return String.format("KeyLength = %s, ValueLength = %s", this.key.getLength(), this.value == null ? "[NO VALUE]" : Integer.valueOf(this.value.getLength()));
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteArraySegment getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteArraySegment getValue() {
        return this.value;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageEntry)) {
            return false;
        }
        PageEntry other = (PageEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ByteArraySegment this$key = this.getKey();
        ByteArraySegment other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        ByteArraySegment this$value = this.getValue();
        ByteArraySegment other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageEntry;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArraySegment $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        ByteArraySegment $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @ConstructorProperties(value={"key", "value"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PageEntry(@NonNull ByteArraySegment key, ByteArraySegment value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.value = value;
    }
}

