/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;

public final class Statistics {
    static final Statistics EMPTY = new Statistics(0L, 0L);
    static final Serializer SERIALIZER = new Serializer();
    private final long entryCount;
    private final long pageCount;

    Statistics update(int entryCountDelta, int pageCountDelta) {
        long newEntryCount = this.entryCount + (long)entryCountDelta;
        long newPageCount = this.pageCount + (long)pageCountDelta;
        Preconditions.checkArgument((newEntryCount >= 0L ? 1 : 0) != 0, (String)"New Entry Count would be negative (EntryCount=%s, Delta=%s)", (long)this.entryCount, (int)entryCountDelta);
        Preconditions.checkArgument((newPageCount >= 0L ? 1 : 0) != 0, (String)"New Page Count would be negative (PageCount=%s, Delta=%s)", (long)this.pageCount, (int)pageCountDelta);
        return new Statistics(newEntryCount, newPageCount);
    }

    public String toString() {
        return String.format("EntryCount = %s, PageCount = %s", this.entryCount, this.pageCount);
    }

    @ConstructorProperties(value={"entryCount", "pageCount"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    Statistics(long entryCount, long pageCount) {
        this.entryCount = entryCount;
        this.pageCount = pageCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static StatisticsBuilder builder() {
        return new StatisticsBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getEntryCount() {
        return this.entryCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getPageCount() {
        return this.pageCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Statistics)) {
            return false;
        }
        Statistics other = (Statistics)o;
        if (this.getEntryCount() != other.getEntryCount()) {
            return false;
        }
        return this.getPageCount() == other.getPageCount();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $entryCount = this.getEntryCount();
        result = result * 59 + (int)($entryCount >>> 32 ^ $entryCount);
        long $pageCount = this.getPageCount();
        result = result * 59 + (int)($pageCount >>> 32 ^ $pageCount);
        return result;
    }

    static class Serializer
    extends VersionedSerializer.WithBuilder<Statistics, StatisticsBuilder> {
        Serializer() {
        }

        protected StatisticsBuilder newBuilder() {
            return Statistics.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(Statistics s, RevisionDataOutput target) throws IOException {
            target.writeCompactLong(s.entryCount);
            target.writeCompactLong(s.pageCount);
        }

        private void read00(RevisionDataInput source, StatisticsBuilder b) throws IOException {
            b.entryCount(source.readCompactLong());
            b.pageCount(source.readCompactLong());
        }
    }

    static class StatisticsBuilder
    implements ObjectBuilder<Statistics> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long entryCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long pageCount;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        StatisticsBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StatisticsBuilder entryCount(long entryCount) {
            this.entryCount = entryCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StatisticsBuilder pageCount(long pageCount) {
            this.pageCount = pageCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Statistics build() {
            return new Statistics(this.entryCount, this.pageCount);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Statistics.StatisticsBuilder(entryCount=" + this.entryCount + ", pageCount=" + this.pageCount + ")";
        }
    }
}

