/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree;

import com.google.common.base.Preconditions;
import io.pravega.common.util.btree.PageCollection;
import io.pravega.common.util.btree.PageWrapper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class UpdateablePageCollection
extends PageCollection {
    @GuardedBy(value="this")
    private long incompleteNewPageOffset = -1L;
    @GuardedBy(value="this")
    private final HashSet<Long> deletedPageOffsets = new HashSet();
    private final AtomicInteger entryCountDelta = new AtomicInteger(0);
    private final AtomicInteger pageCountDelta = new AtomicInteger(0);

    UpdateablePageCollection(long indexLength) {
        super(indexLength);
    }

    @Override
    synchronized PageWrapper insert(PageWrapper page) {
        Preconditions.checkArgument((this.incompleteNewPageOffset == -1L ? 1 : 0) != 0, (Object)"Cannot insert new page while a new page is incomplete.");
        if (page.isNewPage()) {
            this.incompleteNewPageOffset = page.getOffset();
            this.pageCountDelta.incrementAndGet();
        }
        return super.insert(page);
    }

    @Override
    synchronized void remove(PageWrapper page) {
        super.remove(page);
        if (this.incompleteNewPageOffset == page.getOffset()) {
            this.incompleteNewPageOffset = -1L;
        }
        this.deletedPageOffsets.add(page.getOffset());
        page.setOffset(-1L);
        this.pageCountDelta.decrementAndGet();
        if (!page.isIndexPage()) {
            this.entryCountDelta.addAndGet(page.getEntryCountDelta());
        }
    }

    synchronized void complete(PageWrapper page) {
        Preconditions.checkArgument((boolean)this.pageByOffset.containsKey(page.getOffset()), (Object)"Given page is not registered.");
        Preconditions.checkArgument((this.incompleteNewPageOffset == -1L || this.incompleteNewPageOffset == page.getOffset() ? 1 : 0) != 0, (Object)"Not expecting this page to be completed.");
        this.incompleteNewPageOffset = -1L;
        long pageOffset = this.indexLength;
        this.indexLength += (long)page.getPage().getLength();
        this.pageByOffset.remove(page.getOffset());
        page.setOffset(pageOffset);
        this.pageByOffset.put(page.getOffset(), page);
        if (!page.isIndexPage()) {
            this.entryCountDelta.addAndGet(page.getEntryCountDelta());
        }
    }

    synchronized void collectRemovedPageOffsets(Collection<Long> target) {
        target.addAll(this.deletedPageOffsets);
    }

    synchronized void collectLeafPages(Collection<PageWrapper> target) {
        this.pageByOffset.values().stream().filter(p -> !p.isIndexPage()).forEach(target::add);
    }

    synchronized void collectPages(Collection<Long> offsets, Collection<PageWrapper> target) {
        offsets.forEach(offset -> {
            PageWrapper p = this.pageByOffset.getOrDefault(offset, null);
            if (p != null) {
                target.add(p);
            }
        });
    }

    synchronized List<PageWrapper> getPagesSortedByOffset() {
        return this.pageByOffset.values().stream().sorted(Comparator.comparingLong(PageWrapper::getOffset)).collect(Collectors.toList());
    }

    int getEntryCountDelta() {
        return this.entryCountDelta.get();
    }

    synchronized int getPageCountDelta() {
        return this.pageCountDelta.get();
    }
}

