/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.authplugin.basic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthHandler;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

class AccessControlEntry {
    private static final Pattern PATTERN_STAR_NOT_PRECEDED_BY_DOT = Pattern.compile("(?!=.)\\*");
    private final String resourcePattern;
    private final AuthHandler.Permissions permissions;

    @VisibleForTesting
    AccessControlEntry(@NonNull String aceResource, @NonNull AuthHandler.Permissions permissions) {
        this(aceResource, permissions, false);
        if (aceResource == null) {
            throw new NullPointerException("aceResource is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
    }

    @VisibleForTesting
    AccessControlEntry(@NonNull String aceResource, @NonNull AuthHandler.Permissions permissions, boolean isLegacyFormat) {
        if (aceResource == null) {
            throw new NullPointerException("aceResource is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.resourcePattern = isLegacyFormat ? aceResource : PATTERN_STAR_NOT_PRECEDED_BY_DOT.matcher(aceResource).replaceAll(".*");
        this.permissions = permissions;
    }

    static AccessControlEntry fromString(String ace) {
        AuthHandler.Permissions permissions;
        String[] splits = null;
        if (Strings.isNullOrEmpty((String)ace) || (splits = ace.split(",")).length != 2) {
            return null;
        }
        String resource = null;
        if (Strings.isNullOrEmpty((String)splits[0]) || Strings.isNullOrEmpty((String)splits[1])) {
            return null;
        }
        resource = splits[0].trim();
        try {
            permissions = AuthHandler.Permissions.valueOf((String)splits[1].trim());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return new AccessControlEntry(resource, permissions, false);
    }

    boolean isResource(String resource) {
        return this.resourcePattern.equals(resource);
    }

    boolean resourceEndsWith(String resource) {
        return this.resourcePattern.endsWith(resource);
    }

    boolean resourceStartsWith(String resource) {
        return this.resourcePattern.startsWith(resource);
    }

    boolean hasHigherPermissionsThan(AuthHandler.Permissions input) {
        return this.permissions.ordinal() > input.ordinal();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    String getResourcePattern() {
        return this.resourcePattern;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    AuthHandler.Permissions getPermissions() {
        return this.permissions;
    }
}

