/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.authplugin.basic;

import io.pravega.auth.AuthHandler;
import io.pravega.authplugin.basic.AccessControlEntry;
import io.pravega.authplugin.basic.AccessControlList;
import io.pravega.authplugin.basic.AclAuthorizer;
import lombok.NonNull;

class AclAuthorizerImpl
extends AclAuthorizer {
    AclAuthorizerImpl() {
    }

    @Override
    public AuthHandler.Permissions authorize(@NonNull AccessControlList accessControlList, @NonNull String resource) {
        if (accessControlList == null) {
            throw new NullPointerException("accessControlList is marked non-null but is null");
        }
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        AuthHandler.Permissions result = AuthHandler.Permissions.NONE;
        String resourceDomain = resource.split("::")[0];
        for (AccessControlEntry accessControlEntry : accessControlList.getEntries()) {
            if (accessControlEntry == null || !accessControlEntry.resourceStartsWith(resourceDomain) || !resource.matches(accessControlEntry.getResourcePattern())) continue;
            result = accessControlEntry.getPermissions();
            break;
        }
        return result;
    }
}

