/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.authplugin.basic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthException;
import io.pravega.auth.AuthHandler;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.ServerConfig;
import io.pravega.authplugin.basic.AccessControlEntry;
import io.pravega.authplugin.basic.AccessControlList;
import io.pravega.authplugin.basic.AclAuthorizer;
import io.pravega.shared.security.auth.UserPrincipal;
import io.pravega.shared.security.crypto.StrongPasswordProcessor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthHandler
implements AuthHandler {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordAuthHandler.class);
    @VisibleForTesting
    private final ConcurrentHashMap<String, AccessControlList> aclsByUser;
    private final StrongPasswordProcessor encryptor;

    public PasswordAuthHandler() {
        this(new ConcurrentHashMap<String, AccessControlList>());
    }

    @VisibleForTesting
    PasswordAuthHandler(ConcurrentHashMap<String, AccessControlList> aclByUser) {
        this.aclsByUser = aclByUser;
        this.encryptor = StrongPasswordProcessor.builder().build();
    }

    private void loadPasswordFile(String userPasswordFile) {
        log.info("Loading {}", (Object)userPasswordFile);
        try (FileReader reader = new FileReader(userPasswordFile);
             BufferedReader lineReader = new BufferedReader(reader);){
            String line;
            while (!Strings.isNullOrEmpty((String)(line = lineReader.readLine()))) {
                if (line.startsWith("#")) continue;
                this.processUserEntry(line, this.aclsByUser);
            }
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
    }

    @VisibleForTesting
    void processUserEntry(String line, ConcurrentHashMap<String, AccessControlList> userMap) {
        String[] userFields = line.split(":", 3);
        if (userFields.length >= 2) {
            String acls = userFields.length == 2 ? "" : userFields[2];
            userMap.put(userFields[0], new AccessControlList(userFields[1], this.parseAcl(acls)));
        }
    }

    public String getHandlerName() {
        return "Basic";
    }

    public Principal authenticate(String token) throws AuthException {
        String[] parts = PasswordAuthHandler.parseToken(token);
        String userName = parts[0];
        char[] password = parts[1].toCharArray();
        try {
            if (this.aclsByUser.containsKey(userName) && this.encryptor.checkPassword(password, this.aclsByUser.get(userName).getEncryptedPassword())) {
                UserPrincipal userPrincipal = new UserPrincipal(userName);
                return userPrincipal;
            }
            try {
                throw new AuthenticationException("User authentication exception");
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                log.warn("Exception during password authentication", (Throwable)e);
                throw new AuthenticationException((Exception)e);
            }
        }
        finally {
            Arrays.fill(password, '0');
        }
    }

    public AuthHandler.Permissions authorize(String resource, Principal principal) {
        String userName = principal.getName();
        if (Strings.isNullOrEmpty((String)userName) || !this.aclsByUser.containsKey(userName)) {
            throw new CompletionException((Throwable)new AuthenticationException(userName));
        }
        return this.authorizeForUser(this.aclsByUser.get(userName), resource);
    }

    public void initialize(@NonNull ServerConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.initialize(config.toAuthHandlerProperties());
    }

    @VisibleForTesting
    void initialize(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        String userAccountsDatabaseFilePath = properties.getProperty("basic.authplugin.dbfile");
        if (userAccountsDatabaseFilePath == null) {
            throw new RuntimeException("User account database config was absent");
        }
        this.initialize(userAccountsDatabaseFilePath);
    }

    @VisibleForTesting
    public void initialize(String passwordFile) {
        this.loadPasswordFile(passwordFile);
    }

    private static String[] parseToken(String token) {
        String[] parts = new String(Base64.getDecoder().decode(token), Charsets.UTF_8).split(":", 2);
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)"Invalid authorization token");
        return parts;
    }

    private AuthHandler.Permissions authorizeForUser(AccessControlList accessControlList, String resource) {
        AclAuthorizer aclAuthorizer = AclAuthorizer.instance();
        return aclAuthorizer.authorize(accessControlList, resource);
    }

    @VisibleForTesting
    List<AccessControlEntry> parseAcl(String aclString) {
        if (aclString == null || aclString.trim().equals("")) {
            return new ArrayList<AccessControlEntry>();
        }
        return Arrays.stream(aclString.trim().split(";")).map(ace -> AccessControlEntry.fromString(ace)).collect(Collectors.toList());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    ConcurrentHashMap<String, AccessControlList> getAclsByUser() {
        return this.aclsByUser;
    }
}

