/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.local;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.function.Callbacks;
import io.pravega.common.security.TLSProtocolVersion;
import io.pravega.common.security.ZKTLSUtils;
import io.pravega.controller.server.ControllerServiceConfig;
import io.pravega.controller.server.ControllerServiceMain;
import io.pravega.controller.server.eventProcessor.impl.ControllerEventProcessorConfigImpl;
import io.pravega.controller.server.impl.ControllerServiceConfigImpl;
import io.pravega.controller.server.rpc.grpc.impl.GRPCServerConfigImpl;
import io.pravega.controller.store.client.StoreClientConfig;
import io.pravega.controller.store.client.ZKClientConfig;
import io.pravega.controller.store.client.impl.StoreClientConfigImpl;
import io.pravega.controller.store.client.impl.ZKClientConfigImpl;
import io.pravega.controller.store.host.HostMonitorConfig;
import io.pravega.controller.store.host.impl.HostMonitorConfigImpl;
import io.pravega.controller.timeout.TimeoutServiceConfig;
import io.pravega.controller.util.Config;
import io.pravega.local.LocalHDFSEmulator;
import io.pravega.local.SingleNodeConfig;
import io.pravega.segmentstore.server.host.ServiceStarter;
import io.pravega.segmentstore.server.host.stat.AutoScalerConfig;
import io.pravega.segmentstore.server.logs.DurableLogConfig;
import io.pravega.segmentstore.server.store.ServiceBuilderConfig;
import io.pravega.segmentstore.server.store.ServiceConfig;
import io.pravega.segmentstore.storage.StorageLayoutType;
import io.pravega.segmentstore.storage.impl.bookkeeper.ZooKeeperServiceRunner;
import io.pravega.shared.metrics.MetricsConfig;
import io.pravega.shared.rest.impl.RESTServerConfigImpl;
import io.pravega.shared.security.auth.DefaultCredentials;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcPravegaCluster
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InProcPravegaCluster.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private static final String LOCALHOST = "localhost";
    private static final String ALL_INTERFACES = "0.0.0.0";
    private static final int THREADPOOL_SIZE = 20;
    private boolean isInMemStorage;
    private final String clusterName = "singlenode-" + UUID.randomUUID();
    private boolean enableAuth;
    private boolean enableTls;
    private String[] tlsProtocolVersion;
    private boolean enableTlsReload;
    private boolean enableMetrics;
    private boolean enableInfluxDB;
    private int metricsReportInterval;
    private boolean isInProcController;
    private int controllerCount;
    private int[] controllerPorts;
    private String controllerURI;
    private int restServerPort;
    private boolean isInProcSegmentStore;
    private int segmentStoreCount;
    private int[] segmentStorePorts;
    private boolean isInProcZK;
    private int zkPort;
    private String zkHost;
    private ZooKeeperServiceRunner zkService;
    private boolean isInProcHDFS;
    private String hdfsUrl;
    private int containerCount;
    private ServiceStarter[] nodeServiceStarter;
    private LocalHDFSEmulator localHdfs;
    @GuardedBy(value="$lock")
    private ControllerServiceMain[] controllerServers;
    private String zkUrl;
    private boolean enableRestServer;
    private String userName;
    private String passwd;
    private String certFile;
    private String keyFile;
    private String jksTrustFile;
    private String passwdFile;
    private boolean secureZK;
    private String keyPasswordFile;
    private String jksKeyFile;
    private boolean enableAdminGateway;
    private int adminGatewayPort;
    private boolean replyWithStackTraceOnError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControllerPorts(int[] controllerPorts) {
        Object object = this.$lock;
        synchronized (object) {
            this.controllerPorts = Arrays.copyOf(controllerPorts, controllerPorts.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSegmentStorePorts(int[] segmentStorePorts) {
        Object object = this.$lock;
        synchronized (object) {
            this.segmentStorePorts = Arrays.copyOf(segmentStorePorts, segmentStorePorts.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            if (this.isInProcZK) {
                this.zkUrl = "localhost:" + this.zkPort;
                this.startLocalZK();
            } else {
                URI zkUri = new URI("temp://" + this.zkUrl);
                this.zkHost = zkUri.getHost();
                this.zkPort = zkUri.getPort();
            }
            if (this.isInProcHDFS) {
                this.startLocalHDFS();
                this.hdfsUrl = String.format("hdfs://localhost:%d/", this.localHdfs.getNameNodePort());
            }
            this.cleanUpZK();
            if (this.isInProcController) {
                this.startLocalControllers();
            }
            if (this.isInProcSegmentStore) {
                this.nodeServiceStarter = new ServiceStarter[this.segmentStoreCount];
                this.startLocalSegmentStores();
            }
        }
    }

    private void startLocalZK() throws Exception {
        this.zkService = new ZooKeeperServiceRunner(this.zkPort, this.secureZK, this.jksKeyFile, this.keyPasswordFile, this.jksTrustFile);
        this.zkService.initialize();
        this.zkService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpZK() {
        String[] pathsTobeCleaned = new String[]{"/pravega", "/hostIndex", "/store", "/taskIndex"};
        ExponentialBackoffRetry rp = new ExponentialBackoffRetry(1000, 3);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.zkUrl).connectionTimeoutMs(5000).sessionTimeoutMs(5000).retryPolicy((RetryPolicy)rp);
        if (this.secureZK) {
            ZKTLSUtils.setSecureZKClientProperties((String)this.jksTrustFile, (String)"1111_aaaa");
        }
        CuratorFramework zclient = builder.build();
        try {
            zclient.start();
            for (String path : pathsTobeCleaned) {
                try {
                    ((ChildrenDeletable)zclient.delete().guaranteed()).deletingChildrenIfNeeded().forPath(path);
                }
                catch (Exception e) {
                    log.warn("Not able to delete path {} . Exception {}", (Object)path, (Object)e.getMessage());
                }
            }
            zclient.close();
        }
        finally {
            if (Collections.singletonList(zclient).get(0) != null) {
                zclient.close();
            }
        }
    }

    private void startLocalHDFS() throws IOException {
        String baseDir = "temp";
        log.info("Starting HDFS Emulator @ {}/{}", (Object)System.getProperty("java.io.tmpdir"), (Object)baseDir);
        this.localHdfs = LocalHDFSEmulator.newBuilder().baseDirName(baseDir).build();
        this.localHdfs.start();
    }

    private void startLocalSegmentStores() throws Exception {
        for (int i = 0; i < this.segmentStoreCount; ++i) {
            this.startLocalSegmentStore(i);
        }
    }

    private void startLocalSegmentStore(int segmentStoreId) throws Exception {
        if (this.enableAuth) {
            this.setAuthSystemProperties();
        }
        ServiceBuilderConfig.Builder configBuilder = ServiceBuilderConfig.builder().include(System.getProperties()).include(ServiceConfig.builder().with(ServiceConfig.CONTAINER_COUNT, (Object)this.containerCount).with(ServiceConfig.THREAD_POOL_SIZE, (Object)20).with(ServiceConfig.ZK_URL, (Object)("localhost:" + this.zkPort)).with(ServiceConfig.SECURE_ZK, (Object)this.secureZK).with(ServiceConfig.ZK_TRUSTSTORE_LOCATION, (Object)this.jksTrustFile).with(ServiceConfig.ZK_TRUST_STORE_PASSWORD_PATH, (Object)this.keyPasswordFile).with(ServiceConfig.LISTENING_PORT, (Object)this.segmentStorePorts[segmentStoreId]).with(ServiceConfig.CLUSTER_NAME, (Object)this.clusterName).with(ServiceConfig.ENABLE_TLS, (Object)this.enableTls).with(ServiceConfig.TLS_PROTOCOL_VERSION, (Object)Arrays.stream(this.tlsProtocolVersion).collect(Collectors.joining(","))).with(ServiceConfig.KEY_FILE, (Object)this.keyFile).with(ServiceConfig.REST_KEYSTORE_FILE, (Object)this.jksKeyFile).with(ServiceConfig.REST_KEYSTORE_PASSWORD_FILE, (Object)this.keyPasswordFile).with(ServiceConfig.CERT_FILE, (Object)this.certFile).with(ServiceConfig.ENABLE_TLS_RELOAD, (Object)this.enableTlsReload).with(ServiceConfig.LISTENING_IP_ADDRESS, (Object)ALL_INTERFACES).with(ServiceConfig.PUBLISHED_IP_ADDRESS, (Object)LOCALHOST).with(ServiceConfig.CACHE_POLICY_MAX_TIME, (Object)60).with(ServiceConfig.CACHE_POLICY_MAX_SIZE, (Object)0x8000000L).with(ServiceConfig.DATALOG_IMPLEMENTATION, (Object)(this.isInMemStorage ? ServiceConfig.DataLogType.INMEMORY : ServiceConfig.DataLogType.BOOKKEEPER)).with(ServiceConfig.STORAGE_LAYOUT, (Object)StorageLayoutType.ROLLING_STORAGE).with(ServiceConfig.STORAGE_IMPLEMENTATION, (Object)(this.isInMemStorage ? ServiceConfig.StorageType.INMEMORY.name() : ServiceConfig.StorageType.FILESYSTEM.name())).with(ServiceConfig.ENABLE_ADMIN_GATEWAY, (Object)this.enableAdminGateway).with(ServiceConfig.ADMIN_GATEWAY_PORT, (Object)this.adminGatewayPort).with(ServiceConfig.REPLY_WITH_STACK_TRACE_ON_ERROR, (Object)this.replyWithStackTraceOnError).with(ServiceConfig.REST_LISTENING_PORT, (Object)((Integer)ServiceConfig.REST_LISTENING_PORT.getDefaultValue() + segmentStoreId)).with(ServiceConfig.REST_LISTENING_ENABLE, (Object)this.enableRestServer)).include(DurableLogConfig.builder().with(DurableLogConfig.CHECKPOINT_COMMIT_COUNT, (Object)100).with(DurableLogConfig.CHECKPOINT_MIN_COMMIT_COUNT, (Object)100).with(DurableLogConfig.CHECKPOINT_TOTAL_COMMIT_LENGTH, (Object)0x6400000L)).include(AutoScalerConfig.builder().with(AutoScalerConfig.CONTROLLER_URI, (Object)((this.enableTls ? "tls" : "tcp") + "://localhost:" + this.controllerPorts[0])).with(AutoScalerConfig.TOKEN_SIGNING_KEY, (Object)"secret").with(AutoScalerConfig.AUTH_ENABLED, (Object)this.enableAuth).with(AutoScalerConfig.TLS_ENABLED, (Object)this.enableTls).with(AutoScalerConfig.TLS_CERT_FILE, (Object)this.certFile).with(AutoScalerConfig.VALIDATE_HOSTNAME, (Object)false)).include(MetricsConfig.builder().with(MetricsConfig.ENABLE_STATISTICS, (Object)this.enableMetrics).with(MetricsConfig.ENABLE_INFLUXDB_REPORTER, (Object)this.enableInfluxDB).with(MetricsConfig.OUTPUT_FREQUENCY, (Object)this.metricsReportInterval));
        this.nodeServiceStarter[segmentStoreId] = new ServiceStarter(configBuilder.build());
        this.nodeServiceStarter[segmentStoreId].start();
    }

    private void setAuthSystemProperties() {
        if (this.authPropertiesAlreadySet()) {
            log.debug("Auth params already specified via system properties or environment variables.");
        } else if (!Strings.isNullOrEmpty((String)this.userName)) {
            DefaultCredentials credentials = new DefaultCredentials(this.passwd, this.userName);
            System.setProperty("pravega.client.auth.loadDynamic", "false");
            System.setProperty("pravega.client.auth.method", credentials.getAuthenticationType());
            System.setProperty("pravega.client.auth.token", credentials.getAuthenticationToken());
            log.debug("Done setting auth params via system properties.");
        } else {
            log.debug("Cannot set auth params as username is null or empty");
        }
    }

    private boolean authPropertiesAlreadySet() {
        return !Strings.isNullOrEmpty((String)System.getProperty("pravega.client.auth.method")) || !Strings.isNullOrEmpty((String)System.getenv("pravega_client_auth_method"));
    }

    private void startLocalControllers() {
        int i;
        this.controllerServers = new ControllerServiceMain[this.controllerCount];
        for (i = 0; i < this.controllerCount; ++i) {
            this.controllerServers[i] = this.startLocalController(i);
        }
        this.controllerURI = (this.enableTls ? "tls" : "tcp") + "://localhost:" + this.controllerPorts[0];
        for (i = 1; i < this.controllerCount; ++i) {
            this.controllerURI = this.controllerURI + ",localhost:" + this.controllerPorts[i];
        }
    }

    private ControllerServiceMain startLocalController(int controllerId) {
        ZKClientConfigImpl zkClientConfig = ZKClientConfigImpl.builder().connectionString(this.zkUrl).namespace("pravega/" + this.clusterName).initialSleepInterval(2000).maxRetries(1).sessionTimeoutMs(10000).secureConnectionToZooKeeper(this.secureZK).trustStorePath(this.jksTrustFile).trustStorePasswordPath(this.keyPasswordFile).build();
        StoreClientConfig storeClientConfig = StoreClientConfigImpl.withPravegaTablesClient((ZKClientConfig)zkClientConfig);
        HostMonitorConfigImpl hostMonitorConfig = HostMonitorConfigImpl.builder().hostMonitorEnabled(true).containerCount(this.containerCount).hostMonitorMinRebalanceInterval(1).build();
        TimeoutServiceConfig timeoutServiceConfig = TimeoutServiceConfig.builder().maxLeaseValue(Config.MAX_LEASE_VALUE).build();
        ControllerEventProcessorConfigImpl eventProcessorConfig = ControllerEventProcessorConfigImpl.withDefaultBuilder().shutdownTimeout(Duration.ofMillis(100L)).build();
        GRPCServerConfigImpl grpcServerConfig = GRPCServerConfigImpl.builder().port(this.controllerPorts[controllerId]).publishedRPCHost(LOCALHOST).publishedRPCPort(Integer.valueOf(this.controllerPorts[controllerId])).authorizationEnabled(this.enableAuth).tlsEnabled(this.enableTls).tlsProtocolVersion(this.tlsProtocolVersion).tlsTrustStore(this.certFile).tlsCertFile(this.certFile).tlsKeyFile(this.keyFile).userPasswordFile(this.passwdFile).tokenSigningKey("secret").accessTokenTTLInSeconds(Integer.valueOf(600)).replyWithStackTraceOnError(false).requestTracingEnabled(true).build();
        RESTServerConfigImpl restServerConfig = null;
        if (this.enableRestServer) {
            restServerConfig = RESTServerConfigImpl.builder().host(ALL_INTERFACES).port(this.restServerPort).tlsEnabled(this.enableTls).tlsProtocolVersion(this.tlsProtocolVersion).keyFilePath(this.jksKeyFile).keyFilePasswordPath(this.keyPasswordFile).build();
        }
        ControllerServiceConfigImpl serviceConfig = ControllerServiceConfigImpl.builder().threadPoolSize(Runtime.getRuntime().availableProcessors()).storeClientConfig(storeClientConfig).hostMonitorConfig((HostMonitorConfig)hostMonitorConfig).controllerClusterListenerEnabled(false).timeoutServiceConfig(timeoutServiceConfig).eventProcessorConfig(Optional.of(eventProcessorConfig)).grpcServerConfig(Optional.of(grpcServerConfig)).restServerConfig(Optional.ofNullable(restServerConfig)).shutdownTimeout(Duration.ofMillis(100L)).build();
        ControllerServiceMain controllerService = new ControllerServiceMain((ControllerServiceConfig)serviceConfig);
        try {
            controllerService.startAsync().awaitRunning();
            return controllerService;
        }
        catch (Throwable ex) {
            Callbacks.invokeSafely(() -> ((ControllerServiceMain)controllerService).close(), ex2 -> log.error("Unable to clean up controller startup.", ex2));
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getControllerURI() {
        Object object = this.$lock;
        synchronized (object) {
            return this.controllerURI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            if (this.isInProcSegmentStore) {
                for (ServiceStarter serviceStarter : this.nodeServiceStarter) {
                    serviceStarter.shutdown();
                }
            }
            if (this.isInProcController) {
                for (ServiceStarter serviceStarter : this.controllerServers) {
                    Callbacks.invokeSafely(() -> ((ControllerServiceMain)serviceStarter).close(), ex -> log.error("Unable to shut down Controller.", ex));
                }
            }
            if (this.zkService != null) {
                this.zkService.close();
                this.zkService = null;
            }
        }
    }

    public String print() {
        String auto = this.toString();
        int start = auto.indexOf("(") + 1;
        int end = auto.indexOf(")");
        String[] opts = auto.substring(start, end).split(",");
        StringBuilder result = new StringBuilder(String.format("%s%n", auto.substring(0, start)));
        for (String opt : opts) {
            result.append(String.format("\t%s%n", opt.trim()));
        }
        result.append(auto.substring(end, auto.length()));
        return result.toString();
    }

    @ConstructorProperties(value={"isInMemStorage", "enableAuth", "enableTls", "tlsProtocolVersion", "enableTlsReload", "enableMetrics", "enableInfluxDB", "metricsReportInterval", "isInProcController", "controllerCount", "controllerPorts", "controllerURI", "restServerPort", "isInProcSegmentStore", "segmentStoreCount", "segmentStorePorts", "isInProcZK", "zkPort", "zkHost", "zkService", "isInProcHDFS", "hdfsUrl", "containerCount", "nodeServiceStarter", "localHdfs", "controllerServers", "zkUrl", "enableRestServer", "userName", "passwd", "certFile", "keyFile", "jksTrustFile", "passwdFile", "secureZK", "keyPasswordFile", "jksKeyFile", "enableAdminGateway", "adminGatewayPort", "replyWithStackTraceOnError"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    InProcPravegaCluster(boolean isInMemStorage, boolean enableAuth, boolean enableTls, String[] tlsProtocolVersion, boolean enableTlsReload, boolean enableMetrics, boolean enableInfluxDB, int metricsReportInterval, boolean isInProcController, int controllerCount, int[] controllerPorts, String controllerURI, int restServerPort, boolean isInProcSegmentStore, int segmentStoreCount, int[] segmentStorePorts, boolean isInProcZK, int zkPort, String zkHost, ZooKeeperServiceRunner zkService, boolean isInProcHDFS, String hdfsUrl, int containerCount, ServiceStarter[] nodeServiceStarter, LocalHDFSEmulator localHdfs, ControllerServiceMain[] controllerServers, String zkUrl, boolean enableRestServer, String userName, String passwd, String certFile, String keyFile, String jksTrustFile, String passwdFile, boolean secureZK, String keyPasswordFile, String jksKeyFile, boolean enableAdminGateway, int adminGatewayPort, boolean replyWithStackTraceOnError) {
        this.isInMemStorage = isInMemStorage;
        this.enableAuth = enableAuth;
        this.enableTls = enableTls;
        this.tlsProtocolVersion = tlsProtocolVersion;
        this.enableTlsReload = enableTlsReload;
        this.enableMetrics = enableMetrics;
        this.enableInfluxDB = enableInfluxDB;
        this.metricsReportInterval = metricsReportInterval;
        this.isInProcController = isInProcController;
        this.controllerCount = controllerCount;
        this.controllerPorts = controllerPorts;
        this.controllerURI = controllerURI;
        this.restServerPort = restServerPort;
        this.isInProcSegmentStore = isInProcSegmentStore;
        this.segmentStoreCount = segmentStoreCount;
        this.segmentStorePorts = segmentStorePorts;
        this.isInProcZK = isInProcZK;
        this.zkPort = zkPort;
        this.zkHost = zkHost;
        this.zkService = zkService;
        this.isInProcHDFS = isInProcHDFS;
        this.hdfsUrl = hdfsUrl;
        this.containerCount = containerCount;
        this.nodeServiceStarter = nodeServiceStarter;
        this.localHdfs = localHdfs;
        this.controllerServers = controllerServers;
        this.zkUrl = zkUrl;
        this.enableRestServer = enableRestServer;
        this.userName = userName;
        this.passwd = passwd;
        this.certFile = certFile;
        this.keyFile = keyFile;
        this.jksTrustFile = jksTrustFile;
        this.passwdFile = passwdFile;
        this.secureZK = secureZK;
        this.keyPasswordFile = keyPasswordFile;
        this.jksKeyFile = jksKeyFile;
        this.enableAdminGateway = enableAdminGateway;
        this.adminGatewayPort = adminGatewayPort;
        this.replyWithStackTraceOnError = replyWithStackTraceOnError;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static InProcPravegaClusterBuilder builder() {
        return new InProcPravegaClusterBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "InProcPravegaCluster(isInMemStorage=" + this.isInMemStorage + ", clusterName=" + this.clusterName + ", enableAuth=" + this.enableAuth + ", enableTls=" + this.enableTls + ", tlsProtocolVersion=" + Arrays.deepToString(this.tlsProtocolVersion) + ", enableTlsReload=" + this.enableTlsReload + ", enableMetrics=" + this.enableMetrics + ", enableInfluxDB=" + this.enableInfluxDB + ", metricsReportInterval=" + this.metricsReportInterval + ", isInProcController=" + this.isInProcController + ", controllerCount=" + this.controllerCount + ", controllerPorts=" + Arrays.toString(this.controllerPorts) + ", controllerURI=" + this.getControllerURI() + ", restServerPort=" + this.restServerPort + ", isInProcSegmentStore=" + this.isInProcSegmentStore + ", segmentStoreCount=" + this.segmentStoreCount + ", segmentStorePorts=" + Arrays.toString(this.segmentStorePorts) + ", isInProcZK=" + this.isInProcZK + ", zkPort=" + this.zkPort + ", zkHost=" + this.zkHost + ", zkService=" + this.zkService + ", isInProcHDFS=" + this.isInProcHDFS + ", hdfsUrl=" + this.hdfsUrl + ", containerCount=" + this.containerCount + ", nodeServiceStarter=" + Arrays.deepToString(this.nodeServiceStarter) + ", localHdfs=" + this.localHdfs + ", controllerServers=" + Arrays.deepToString(this.controllerServers) + ", zkUrl=" + this.zkUrl + ", enableRestServer=" + this.enableRestServer + ", userName=" + this.userName + ", passwd=" + this.passwd + ", certFile=" + this.certFile + ", keyFile=" + this.keyFile + ", jksTrustFile=" + this.jksTrustFile + ", passwdFile=" + this.passwdFile + ", secureZK=" + this.secureZK + ", keyPasswordFile=" + this.keyPasswordFile + ", jksKeyFile=" + this.jksKeyFile + ", enableAdminGateway=" + this.enableAdminGateway + ", adminGatewayPort=" + this.adminGatewayPort + ", replyWithStackTraceOnError=" + this.replyWithStackTraceOnError + ")";
    }

    public static final class InProcPravegaClusterBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean isInMemStorage;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableAuth;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableTls;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableTlsReload;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableMetrics;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableInfluxDB;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int metricsReportInterval;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean isInProcController;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int controllerCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int[] controllerPorts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String controllerURI;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int restServerPort;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean isInProcSegmentStore;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int segmentStoreCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int[] segmentStorePorts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean isInProcZK;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int zkPort;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String zkHost;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZooKeeperServiceRunner zkService;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean isInProcHDFS;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String hdfsUrl;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ServiceStarter[] nodeServiceStarter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalHDFSEmulator localHdfs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ControllerServiceMain[] controllerServers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String zkUrl;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String userName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String passwd;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String certFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String keyFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String jksTrustFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String passwdFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean secureZK;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String keyPasswordFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String jksKeyFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableAdminGateway;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int adminGatewayPort;
        private int containerCount = 4;
        private boolean enableRestServer = true;
        private boolean replyWithStackTraceOnError = true;
        private String[] tlsProtocolVersion = new TLSProtocolVersion((String)SingleNodeConfig.TLS_PROTOCOL_VERSION.getDefaultValue()).getProtocols();

        public InProcPravegaCluster build() {
            Preconditions.checkState((this.isInProcZK || this.zkUrl != null ? 1 : 0) != 0, (Object)"ZkUrl must be specified");
            Preconditions.checkState((this.isInProcController || this.controllerURI != null ? 1 : 0) != 0, (Object)"ControllerURI should be defined for external controller");
            Preconditions.checkState((this.isInProcController || this.controllerPorts != null ? 1 : 0) != 0, (Object)"Controller ports not present");
            Preconditions.checkState((this.isInProcSegmentStore || this.segmentStorePorts != null ? 1 : 0) != 0, (Object)"SegmentStore ports not declared");
            Preconditions.checkState((!this.enableTls || !Strings.isNullOrEmpty((String)this.keyFile) && !Strings.isNullOrEmpty((String)this.certFile) && !Strings.isNullOrEmpty((String)this.jksKeyFile) && !Strings.isNullOrEmpty((String)this.jksTrustFile) && !Strings.isNullOrEmpty((String)this.keyPasswordFile) ? 1 : 0) != 0, (Object)"TLS enabled, but not all parameters set");
            this.isInProcHDFS = !this.isInMemStorage;
            return new InProcPravegaCluster(this.isInMemStorage, this.enableAuth, this.enableTls, this.tlsProtocolVersion, this.enableTlsReload, this.enableMetrics, this.enableInfluxDB, this.metricsReportInterval, this.isInProcController, this.controllerCount, this.controllerPorts, this.controllerURI, this.restServerPort, this.isInProcSegmentStore, this.segmentStoreCount, this.segmentStorePorts, this.isInProcZK, this.zkPort, this.zkHost, this.zkService, this.isInProcHDFS, this.hdfsUrl, this.containerCount, this.nodeServiceStarter, this.localHdfs, this.controllerServers, this.zkUrl, this.enableRestServer, this.userName, this.passwd, this.certFile, this.keyFile, this.jksTrustFile, this.passwdFile, this.secureZK, this.keyPasswordFile, this.jksKeyFile, this.enableAdminGateway, this.adminGatewayPort, this.replyWithStackTraceOnError);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        InProcPravegaClusterBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder isInMemStorage(boolean isInMemStorage) {
            this.isInMemStorage = isInMemStorage;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder enableAuth(boolean enableAuth) {
            this.enableAuth = enableAuth;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder enableTls(boolean enableTls) {
            this.enableTls = enableTls;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder tlsProtocolVersion(String[] tlsProtocolVersion) {
            this.tlsProtocolVersion = tlsProtocolVersion;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder enableTlsReload(boolean enableTlsReload) {
            this.enableTlsReload = enableTlsReload;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder enableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder enableInfluxDB(boolean enableInfluxDB) {
            this.enableInfluxDB = enableInfluxDB;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder metricsReportInterval(int metricsReportInterval) {
            this.metricsReportInterval = metricsReportInterval;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder isInProcController(boolean isInProcController) {
            this.isInProcController = isInProcController;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder controllerCount(int controllerCount) {
            this.controllerCount = controllerCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder controllerPorts(int[] controllerPorts) {
            this.controllerPorts = controllerPorts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder controllerURI(String controllerURI) {
            this.controllerURI = controllerURI;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder restServerPort(int restServerPort) {
            this.restServerPort = restServerPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder isInProcSegmentStore(boolean isInProcSegmentStore) {
            this.isInProcSegmentStore = isInProcSegmentStore;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder segmentStoreCount(int segmentStoreCount) {
            this.segmentStoreCount = segmentStoreCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder segmentStorePorts(int[] segmentStorePorts) {
            this.segmentStorePorts = segmentStorePorts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder isInProcZK(boolean isInProcZK) {
            this.isInProcZK = isInProcZK;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder zkPort(int zkPort) {
            this.zkPort = zkPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder zkHost(String zkHost) {
            this.zkHost = zkHost;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder zkService(ZooKeeperServiceRunner zkService) {
            this.zkService = zkService;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder isInProcHDFS(boolean isInProcHDFS) {
            this.isInProcHDFS = isInProcHDFS;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder hdfsUrl(String hdfsUrl) {
            this.hdfsUrl = hdfsUrl;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder containerCount(int containerCount) {
            this.containerCount = containerCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder nodeServiceStarter(ServiceStarter[] nodeServiceStarter) {
            this.nodeServiceStarter = nodeServiceStarter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder localHdfs(LocalHDFSEmulator localHdfs) {
            this.localHdfs = localHdfs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder controllerServers(ControllerServiceMain[] controllerServers) {
            this.controllerServers = controllerServers;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder zkUrl(String zkUrl) {
            this.zkUrl = zkUrl;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder enableRestServer(boolean enableRestServer) {
            this.enableRestServer = enableRestServer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder certFile(String certFile) {
            this.certFile = certFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder keyFile(String keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder jksTrustFile(String jksTrustFile) {
            this.jksTrustFile = jksTrustFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder passwdFile(String passwdFile) {
            this.passwdFile = passwdFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder secureZK(boolean secureZK) {
            this.secureZK = secureZK;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder keyPasswordFile(String keyPasswordFile) {
            this.keyPasswordFile = keyPasswordFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder jksKeyFile(String jksKeyFile) {
            this.jksKeyFile = jksKeyFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder enableAdminGateway(boolean enableAdminGateway) {
            this.enableAdminGateway = enableAdminGateway;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder adminGatewayPort(int adminGatewayPort) {
            this.adminGatewayPort = adminGatewayPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InProcPravegaClusterBuilder replyWithStackTraceOnError(boolean replyWithStackTraceOnError) {
            this.replyWithStackTraceOnError = replyWithStackTraceOnError;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "InProcPravegaCluster.InProcPravegaClusterBuilder(isInMemStorage=" + this.isInMemStorage + ", enableAuth=" + this.enableAuth + ", enableTls=" + this.enableTls + ", tlsProtocolVersion=" + Arrays.deepToString(this.tlsProtocolVersion) + ", enableTlsReload=" + this.enableTlsReload + ", enableMetrics=" + this.enableMetrics + ", enableInfluxDB=" + this.enableInfluxDB + ", metricsReportInterval=" + this.metricsReportInterval + ", isInProcController=" + this.isInProcController + ", controllerCount=" + this.controllerCount + ", controllerPorts=" + Arrays.toString(this.controllerPorts) + ", controllerURI=" + this.controllerURI + ", restServerPort=" + this.restServerPort + ", isInProcSegmentStore=" + this.isInProcSegmentStore + ", segmentStoreCount=" + this.segmentStoreCount + ", segmentStorePorts=" + Arrays.toString(this.segmentStorePorts) + ", isInProcZK=" + this.isInProcZK + ", zkPort=" + this.zkPort + ", zkHost=" + this.zkHost + ", zkService=" + this.zkService + ", isInProcHDFS=" + this.isInProcHDFS + ", hdfsUrl=" + this.hdfsUrl + ", containerCount=" + this.containerCount + ", nodeServiceStarter=" + Arrays.deepToString(this.nodeServiceStarter) + ", localHdfs=" + this.localHdfs + ", controllerServers=" + Arrays.deepToString(this.controllerServers) + ", zkUrl=" + this.zkUrl + ", enableRestServer=" + this.enableRestServer + ", userName=" + this.userName + ", passwd=" + this.passwd + ", certFile=" + this.certFile + ", keyFile=" + this.keyFile + ", jksTrustFile=" + this.jksTrustFile + ", passwdFile=" + this.passwdFile + ", secureZK=" + this.secureZK + ", keyPasswordFile=" + this.keyPasswordFile + ", jksKeyFile=" + this.jksKeyFile + ", enableAdminGateway=" + this.enableAdminGateway + ", adminGatewayPort=" + this.adminGatewayPort + ", replyWithStackTraceOnError=" + this.replyWithStackTraceOnError + ")";
        }
    }
}

